/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmshutdown;

import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.CreateVCenterAlarm;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.FaultToleranceConfigInfo;
import com.vmware.vim25.FaultTolerancePrimaryConfigInfo;
import com.vmware.vim25.FaultToleranceSecondaryConfigInfo;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.ToolsUnavailable;
import com.vmware.vim25.VirtualMachineFaultToleranceState;
import com.vmware.vim25.VirtualMachineGuestState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsRunningStatus;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.TaskManager;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMShutdownVMList {
    private static final Logger logger = LogManager.getLogger(VMShutdownVMList.class);
    private boolean bPreShutdownVcsaVmTasksComplete = false;
    private VMHostState hostState = null;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public VMShutdownVMList(VMHostState vMHostState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.hostState = vMHostState;
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    public boolean executeGuestVMShutdown(List<VirtualMachine> list, boolean bl, VMPriority vMPriority) throws TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        if (list == null) {
            logger.debug("executeGuestVMShutdown() - no critical VMs found");
            return true;
        }
        logger.info("executeGuestVMShutdown() - {} VMs to shut down for priority: {}", (Object)list.size(), (Object)vMPriority);
        Iterator<VirtualMachine> iterator = list.iterator();
        while (iterator.hasNext()) {
            VirtualMachine virtualMachine = iterator.next();
            String string = virtualMachine.getName();
            logger.info("executeGuestVMShutdown() - VM: {}", (Object)string);
            if (Thread.currentThread().isInterrupted()) {
                logger.error("executeGuestVMShutdown() - shutdown has been interrupted");
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        VirtualMachine virtualMachine2 = iterator.next();
                        logger.error("executeGuestVMShutdown() - timeout skipped shutdown of VM: {}", (Object)virtualMachine2.getName());
                    }
                }
                return false;
            }
            if (this.isVMPoweredOffOrShuttingDown(virtualMachine, string)) {
                logger.info("executeGuestVMShutdown() - not shutting down, VM already off or shutting down");
                continue;
            }
            if (this.isVsanWitnessHostVM(virtualMachine, string)) {
                logger.info("executeGuestVMShutdown() - not shutting down, VM is vSAN witness host");
                continue;
            }
            this.services.getVsanUtils();
            if (this.hostState.isVsanNonCriticalHost() && !VsanUtils.isVmUsingDatastore(virtualMachine, this.hostState.getVsanDatastoreName())) {
                logger.info("executeGuestVMShutdown() - not shutting down, non-critical host VM not using vSAN datastore");
                continue;
            }
            boolean bl2 = this.isVCenterVM(virtualMachine, bl, string);
            if (bl2 && !this.isShutdownOfVCSAVMOk(virtualMachine, string, vMPriority)) {
                logger.info("executeGuestVMShutdown() - not shutting down; vCSA VM");
                continue;
            }
            if (this.isPCNSInstalledOnVM(string)) {
                logger.info("executeGuestVMShutdown() - not shutting down; PCNS installed on VM");
                continue;
            }
            if (!this.checkIfShutdownOfVAppVMIsOk(virtualMachine, bl, string)) {
                logger.info("executeGuestVMShutdown() - not shutting down; VM is part of a vApp");
                continue;
            }
            if ((virtualMachine = this.checkFaultTolerantVMShutdown(virtualMachine)) == null) {
                logger.info("executeGuestVMShutdown() - not shutting down; FT VM is null");
                continue;
            }
            if (this.isVMGettingMigrated(string)) {
                logger.info("executeGuestVMShutdown() - not shutting down; VM getting migrated");
                continue;
            }
            if (bl2) {
                this.preShutdownVCSAVmTasks(virtualMachine, string);
            }
            this.shutdownORPowerOffVM(virtualMachine, string);
            logger.info("executeGuestVMShutdown() - after shutdown");
        }
        logger.debug("executeGuestVMShutdown() - end");
        return true;
    }

    private boolean isVsanWitnessHostVM(VirtualMachine virtualMachine, String string) {
        boolean bl = false;
        if (this.hostState.getVsanWitnessHostIp() == null) {
            logger.debug("isVsanWitnessHostVM() - vSanWitnessHostIp is null");
            return bl;
        }
        if (virtualMachine.getGuest() != null && virtualMachine.getGuest().getIpAddress() != null && virtualMachine.getGuest().getIpAddress().equals(this.hostState.getVsanWitnessHostIp())) {
            bl = true;
        }
        return bl;
    }

    private void preShutdownVCSAVmTasks(VirtualMachine virtualMachine, String string) {
        logger.debug("preShutdownVCSAVmTasks() - start");
        if (!this.bPreShutdownVcsaVmTasksComplete && virtualMachine.getRuntime() != null && virtualMachine.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn && !virtualMachine.getGuest().getGuestState().equalsIgnoreCase(VirtualMachineGuestState.shuttingDown.toString())) {
            logger.debug("preShutdownVCSAVmTasks() - carrying out tasks");
            this.vmwareConnection.setVCenterOffline(true);
            this.services.getVirtualLoggingUtils().logVCSAVMShutdownEvent(string);
            if (virtualMachine.getGuest().getToolsRunningStatus().equalsIgnoreCase(VirtualMachineToolsRunningStatus.guestToolsRunning.toString())) {
                this.hostState.setHostSystem(this.services.getHostSystemUtils().getValidHostSystem(this.hostState.getHostSystem(), this.hostState.getMappedHostName()));
                if (this.hostState.getHostSystem() != null) {
                    CreateVCenterAlarm.getInstance().createUPSCriticalEvent(this.hostState.getHostSystem().getName(), "alert");
                }
            }
            if (this.hostState.getHostSystemName() != null && !this.hostState.isDelayMaintenanceModeEnabled() && !this.hostState.isSkipMaintenanceModeEnabled()) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeCancelledEvent(this.hostState.getHostSystemName());
            }
            this.bPreShutdownVcsaVmTasksComplete = true;
        } else {
            logger.debug("preShutdownVCSAVmTasks() - not carrying out tasks");
        }
        logger.debug("preShutdownVCSAVmTasks() - end");
    }

    private boolean isVMPoweredOffOrShuttingDown(VirtualMachine virtualMachine, String string) {
        return virtualMachine.getRuntime().getPowerState() != VirtualMachinePowerState.poweredOn || virtualMachine.getGuest().getGuestState().equalsIgnoreCase(VirtualMachineGuestState.shuttingDown.toString());
    }

    private boolean isVCenterVM(VirtualMachine virtualMachine, boolean bl, String string) {
        if (!bl && this.services.getHostSystemUtils().isVCenterServerInstalledOnVM(virtualMachine, this.hostState.getServiceInstance())) {
            logger.debug("isVCenterVM() - found vCSA VM: {}", (Object)string);
            return true;
        }
        if (this.hostState.getVCSAUuid() != null && virtualMachine.getConfig().getUuid().equalsIgnoreCase(this.hostState.getVCSAUuid())) {
            logger.debug("isVCenterVM() - found vCSA VM: {} using UUID", (Object)string);
            return true;
        }
        return false;
    }

    private boolean isShutdownOfVCSAVMOk(VirtualMachine virtualMachine, String string, VMPriority vMPriority) {
        if (this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled() && vMPriority != VMPriority.NONE) {
            logger.debug("isShutdownOfVCSAVMOk() - found vCSA VM: {} in priority group: {}, OK to shut down", (Object)string, (Object)vMPriority);
            this.hostState.setVCSAVMShutdown(true);
            return true;
        }
        logger.debug("isShutdownOfVCSAVMOk() - found vCSA VM: {} in priority group: {}, not shutting it down", (Object)string, (Object)vMPriority);
        return false;
    }

    private boolean isPCNSInstalledOnVM(String string) {
        return this.hostState.getPCNSVMName() != null && (this.hostState.getPCNSVMName() == null || string.equals(this.hostState.getPCNSVMName()));
    }

    private boolean checkIfShutdownOfVAppVMIsOk(VirtualMachine virtualMachine, boolean bl, String string) {
        if (bl || !bl && virtualMachine.getParentVApp().getMOR() == null) {
            boolean bl2 = false;
            if (!this.hostState.getVAppVMMap().isEmpty()) {
                for (List<String> list : this.hostState.getVAppVMMap().values()) {
                    if (!list.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl && bl2) {
                logger.debug("checkIfShutdownOfVAppVMIsOk() - skipping vApp VM: {}", (Object)string);
                return false;
            }
            return true;
        }
        logger.debug("checkIfShutdownOfVAppVMIsOk() - skipped shutdown of VM: {} as its part of a vApp", (Object)string);
        return false;
    }

    private VirtualMachine checkFaultTolerantVMShutdown(VirtualMachine virtualMachine) {
        if (VirtualMachineFaultToleranceState.running.toString().equalsIgnoreCase(virtualMachine.getSummary().getRuntime().getFaultToleranceState().toString())) {
            boolean bl = true;
            logger.debug("checkFaultTolerantVMShutdown() - checking Fault Tolerance configuration");
            FaultToleranceConfigInfo faultToleranceConfigInfo = virtualMachine.getSummary().getConfig().getFtInfo();
            if (faultToleranceConfigInfo instanceof FaultTolerancePrimaryConfigInfo) {
                ManagedObjectReference managedObjectReference;
                ManagedObjectReference[] managedObjectReferenceArray;
                logger.debug("checkFaultTolerantVMShutdown() - configured as primary VM");
                ManagedObjectReference[] managedObjectReferenceArray2 = managedObjectReferenceArray = ((FaultTolerancePrimaryConfigInfo)faultToleranceConfigInfo).getSecondaries();
                int n = managedObjectReferenceArray2.length;
                for (int i = 0; i < n && (bl = this.checkIfFaultTolerantVMNeedsShutdown(managedObjectReference = managedObjectReferenceArray2[i])); ++i) {
                }
            } else if (faultToleranceConfigInfo instanceof FaultToleranceSecondaryConfigInfo) {
                logger.debug("checkFaultTolerantVMShutdown() - configured as secondary VM");
                ManagedObjectReference managedObjectReference = ((FaultToleranceSecondaryConfigInfo)faultToleranceConfigInfo).getPrimaryVM();
                bl = this.checkIfFaultTolerantVMNeedsShutdown(managedObjectReference);
                if (bl) {
                    if (this.hostState.getServiceInstance() != null) {
                        virtualMachine = new VirtualMachine(this.hostState.getServiceInstance().getServerConnection(), managedObjectReference);
                    } else {
                        logger.error("checkFaultTolerantVMShutdown() - serviceInstance not set");
                    }
                }
            }
            if (!bl) {
                logger.debug("checkFaultTolerantVMShutdown() - VM does not need to be shut down");
                return null;
            }
        }
        return virtualMachine;
    }

    private boolean isVMGettingMigrated(String string) throws TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        String string2;
        boolean bl = false;
        logger.debug("isVMGettingMigrated() - start, VM: {}", (Object)string);
        if (this.hostState.getServiceInstance() != null && "VirtualCenter".equalsIgnoreCase(string2 = this.hostState.getServiceInstance().getAboutInfo().getApiType())) {
            TaskManager taskManager = this.hostState.getServiceInstance().getTaskManager();
            try {
                Task[] taskArray;
                for (Task task : taskArray = taskManager.getRecentTasks()) {
                    TaskInfo taskInfo;
                    if (task.getAssociatedManagedEntity() == null || !(task.getAssociatedManagedEntity() instanceof VirtualMachine) || task.getAssociatedManagedEntity().getName() == null || !task.getAssociatedManagedEntity().getName().equalsIgnoreCase(string) || (taskInfo = task.getTaskInfo()) == null || taskInfo.getName() == null || !taskInfo.getName().equalsIgnoreCase("MigrateVM_Task") || (taskInfo.getState() == null || !taskInfo.getState().toString().equalsIgnoreCase(TaskInfoState.queued.toString())) && !taskInfo.getState().toString().equalsIgnoreCase(TaskInfoState.running.toString())) continue;
                    bl = true;
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.error("isVMGettingMigrated() - RuntimeException for VM: " + string + " : " + String.valueOf(runtimeException));
            }
        }
        if (bl) {
            logger.error("isVMGettingMigrated() - skipped shutdown of VM: " + string + " because its getting migrated");
        }
        logger.debug("isVMGettingMigrated() - end");
        return bl;
    }

    private void shutdownORPowerOffVM(VirtualMachine virtualMachine, String string) {
        String string2 = null;
        logger.debug("shutdownAndPowerOffVM() - start, VM: {}", (Object)string);
        string2 = virtualMachine.getGuest().getToolsRunningStatus().equalsIgnoreCase(VirtualMachineToolsRunningStatus.guestToolsRunning.toString()) ? this.shutdownGuestVM(virtualMachine, string) : this.powerOffVM(virtualMachine, string);
        if (string2 != null) {
            this.virtualisationStatusStore.saveVMToPropertyFile(this.hostState.getMappedHostName(), string2);
        }
        logger.debug("shutdownAndPowerOffVM() - end");
    }

    private String shutdownGuestVM(VirtualMachine virtualMachine, String string) {
        String string2 = null;
        logger.debug("shutdownGuestVM() - start, VM: {}", (Object)string);
        try {
            virtualMachine.shutdownGuest();
            logger.debug("shutdownGuestVM() - after VM: {} shutdown", (Object)string);
            string2 = string;
        }
        catch (TaskInProgress taskInProgress) {
            logger.error("shutdownGuestVM() - TaskInProgress VM: {}, reason: {}", (Object)string, (Object)taskInProgress.getLocalizedMessage());
        }
        catch (InvalidState invalidState) {
            logger.error("shutdownGuestVM() - InvalidState VM: {}, reason: {}", (Object)string, (Object)invalidState.getLocalizedMessage());
        }
        catch (ToolsUnavailable toolsUnavailable) {
            logger.error("shutdownGuestVM() - ToolsUnavailable VM: {}, reason: {}", (Object)string, (Object)toolsUnavailable.getLocalizedMessage());
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("shutdownGuestVM() - RuntimeFault VM: {}, reason: {}", (Object)string, (Object)runtimeFault.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            logger.error("shutdownGuestVM() - RemoteException VM: {}, reason: {}", (Object)string, (Object)remoteException.getLocalizedMessage());
        }
        catch (Exception exception) {
            logger.error("shutdownGuestVM() - Exception VM: {}, reason: {}", (Object)string, (Object)exception.getLocalizedMessage());
        }
        return string2;
    }

    private String powerOffVM(VirtualMachine virtualMachine, String string) {
        String string2 = null;
        logger.debug("powerOffVM() - start, VM: {}", (Object)string);
        try {
            virtualMachine.powerOffVM_Task();
            logger.debug("powerOffVM() - after VM: {} power off", (Object)string);
            string2 = string;
        }
        catch (TaskInProgress taskInProgress) {
            logger.error("powerOffVM() - TaskInProgress VM: {}", (Object)string);
        }
        catch (InvalidState invalidState) {
            logger.error("powerOffVM() - InvalidState VM: {}", (Object)string);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("powerOffVM() - RuntimeFault VM: {}", (Object)string);
        }
        catch (RemoteException remoteException) {
            logger.error("powerOffVM() - RemoteException VM: {}", (Object)string);
        }
        catch (Exception exception) {
            logger.error("powerOffVM() - Exception VM: {}", (Object)string);
        }
        return string2;
    }

    private boolean checkIfFaultTolerantVMNeedsShutdown(ManagedObjectReference managedObjectReference) {
        boolean bl = false;
        if (this.hostState.getServiceInstance() == null) {
            logger.error("checkIfFaultTolerantVMNeedsShutdown() - service instance not set");
            return bl;
        }
        VirtualMachine virtualMachine = new VirtualMachine(this.hostState.getServiceInstance().getServerConnection(), managedObjectReference);
        HostSystem hostSystem = new HostSystem(this.hostState.getServiceInstance().getServerConnection(), virtualMachine.getRuntime().getHost());
        if (this.hostState.getVirtualHostsToShutdown().contains(hostSystem.getName()) || this.hostState.getVirtualHostsToShutdown().contains(this.services.getHostSystemUtils().getESXiHostIPAddress(hostSystem))) {
            bl = true;
        }
        logger.debug("checkIfFaultTolerantVMNeedsShutdown() - result: {}", (Object)bl);
        return bl;
    }
}

