/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vsan;

import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.shutdowner.EventKey;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanHost;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.HostSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VsanFaultToleranceThreshold {
    private static final Logger logger = LogManager.getLogger(VsanFaultToleranceThreshold.class);
    private Map<Integer, LinkedHashSet<VsanHost>> nonCriticalVsanGroupMap = new HashMap<Integer, LinkedHashSet<VsanHost>>();
    private Map<Integer, LinkedHashSet<VsanHost>> protectedVsanGroupMap;
    private ShutdownState theState;
    private int fttLevel = 0;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;

    public VsanFaultToleranceThreshold(ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        logger.debug("VsanFaultToleranceThreshold() - constructor");
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.theState = shutdownState;
        this.fttLevel = serviceManager.getVirtualConfigurationManager().getVsanFTTLevel();
        this.protectedVsanGroupMap = serviceManager.getVsanUtils().getProtectedVsanGroupMap();
    }

    public void createMapOfNonCriticalVsanGroups(int n) {
        Map<Integer, Set<String>> map;
        logger.debug("createMapOfNonCriticalVsanGroups() - start, ups_setup_idx: {}", (Object)n);
        this.nonCriticalVsanGroupMap.clear();
        this.nonCriticalVsanGroupMap.putAll(this.protectedVsanGroupMap);
        logger.debug("createMapOfNonCriticalVsanGroups() - nonCriticalVsanHostMap groups: {}", this.nonCriticalVsanGroupMap.keySet());
        if (n >= 0 && this.nonCriticalVsanGroupMap.containsKey(n) && this.nonCriticalVsanGroupMap.get(n).size() > 0) {
            logger.debug("createMapOfNonCriticalVsanGroups() - removing group: {} from nonCriticalVsanHostMap", (Object)n);
            this.nonCriticalVsanGroupMap.remove(n);
        }
        if (!(map = this.theState.getAllCriticalHostsInAdvancedGroups(n)).isEmpty()) {
            for (Map.Entry<Integer, Set<String>> entry : map.entrySet()) {
                if (!this.nonCriticalVsanGroupMap.containsKey(entry.getKey())) continue;
                LinkedHashSet<VsanHost> linkedHashSet = this.nonCriticalVsanGroupMap.get(entry.getKey());
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    VsanHost vsanHost = (VsanHost)iterator.next();
                    if (!entry.getValue().contains(vsanHost.getName())) continue;
                    logger.debug("createMapOfNonCriticalVsanGroups() - removing critical host: {} from group: {}", (Object)vsanHost.getName(), (Object)entry.getKey());
                    iterator.remove();
                }
                if (!this.nonCriticalVsanGroupMap.get(entry.getKey()).isEmpty()) continue;
                logger.debug("createMapOfNonCriticalVsanGroups() - removing group: {} from nonCriticalVsanGroupMap", (Object)entry.getKey());
                this.nonCriticalVsanGroupMap.remove(entry.getKey());
            }
        }
        logger.debug("createMapOfNonCriticalVsanGroups() - end, non critical vSAN groups: {}", this.nonCriticalVsanGroupMap.keySet());
    }

    public void setUnhealthySingleUpsGroups(Set<Integer> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        set.forEach(n -> {
            logger.debug("setUnhealthySingleUpsGroups() - removing unhealthy groups: {} from nonCriticalVsanHostMap", n);
            this.nonCriticalVsanGroupMap.remove(n);
            this.createGroupLock((int)n);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonCriticalVsanHostsToCriticalTimer(Event event) {
        logger.debug("addNonCriticalVsanHostsToCriticalTimer() - start");
        if (event == null) {
            logger.debug("addNonCriticalVsanHostsToCriticalTimer() - triggerEvent is null");
            return;
        }
        Object object = this.theState.getCriticalShutdownTimersLock();
        logger.debug("addNonCriticalVsanHostsToCriticalTimer() seek Lock (it is reentrant){}", (Object)object.hashCode());
        Object object2 = object;
        synchronized (object2) {
            try {
                Object object3;
                logger.debug("addNonCriticalVsanHostsToCriticalTimer() - got Lock {}", (Object)object.hashCode());
                HashSet<String> hashSet = new HashSet<String>();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                Object object4 = this.nonCriticalVsanGroupMap.entrySet().iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    LinkedHashSet<VsanHost> linkedHashSet = object3.getValue();
                    ArrayList arrayList2 = new ArrayList();
                    linkedHashSet.forEach(vsanHost -> {
                        logger.debug("addNonCriticalVsanHostsToCriticalTimer() - Checking if critical Host {}", (Object)vsanHost.getName());
                        if (!this.theState.checkIfCriticalEventActive(vsanHost.getName())) {
                            hashSet.add(vsanHost.getName());
                        } else {
                            logger.debug("addNonCriticalVsanHostsToCriticalTimer() - Host {} already critical", (Object)vsanHost.getName());
                            arrayList2.add(vsanHost);
                        }
                    });
                    try {
                        linkedHashSet.removeAll(arrayList2);
                    }
                    catch (Exception exception) {
                        logger.error("addNonCriticalVsanHostsToCriticalTimer() - Error removing Hosts{}", (Throwable)exception);
                    }
                    if (!linkedHashSet.isEmpty()) continue;
                    logger.debug("addNonCriticalVsanHostsToCriticalTimer() - empty group {} will be removed", object3.getKey());
                    arrayList.add((Integer)object3.getKey());
                }
                arrayList.forEach(n -> this.nonCriticalVsanGroupMap.remove(n));
                logger.debug("addNonCriticalVsanHostsToCriticalTimer() - non-critical hosts to lock: {}", hashSet);
                if (hashSet.size() > 0 && (object3 = this.theState.getCriticalShutdownTimer((EventKey)(object4 = new EventKey(event)))) != null) {
                    ((ShutdownTimer)object3).addNonCriticalHosts(hashSet);
                    logger.info("addNonCriticalVsanHostsToCriticalTimer() - adding non-critical vSAN hosts: {} to critical timer", hashSet);
                }
            }
            finally {
                logger.debug("addNonCriticalVsanHostsToCriticalTimer() - free Lock {} nonCriticalVsanGroupMap:{}", (Object)object.hashCode(), this.nonCriticalVsanGroupMap);
            }
        }
        logger.debug("addNonCriticalVsanHostsToCriticalTimer() - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNonCriticalVsanHostsFromCriticalTimer(Set<String> set, Event event) {
        logger.debug("removeNonCriticalVsanHostsFromCriticalTimer() - start");
        logger.debug("removeNonCriticalVsanHostsFromCriticalTimer() - seek Lock");
        Object object = this.theState.getCriticalShutdownTimersLock();
        synchronized (object) {
            logger.debug("removeNonCriticalVsanHostsFromCriticalTimer() - got Lock");
            EventKey eventKey = new EventKey(event);
            ShutdownTimer shutdownTimer = this.theState.getCriticalShutdownTimer(eventKey);
            if (shutdownTimer != null) {
                shutdownTimer.removeHosts(set);
                logger.info("removeNonCriticalVsanHostsFromCriticalTimer() - removing non-critical vSAN hosts: {} from critical timer", set);
            }
        }
        logger.debug("removeNonCriticalVsanHostsFromCriticalTimer() - free Lock");
        logger.debug("removeNonCriticalVsanHostsFromCriticalTimer() - end");
    }

    public boolean isFTTExceeded() {
        logger.debug("isFTTExceeded() - start");
        boolean bl = false;
        Set<Integer> set = this.virtualisationStatusStore.getGroupLocks();
        if (set.size() > this.fttLevel) {
            logger.info("isFTTExceeded() - FTT exceeded, critical vSAN groups: {} > FTT Level: {}", (Object)set.size(), (Object)this.fttLevel);
            bl = true;
        } else {
            logger.debug("isFTTExceeded() - FTT not exceeded, critical vSAN groups: {} <= FTT Level: {}", (Object)set.size(), (Object)this.fttLevel);
        }
        logger.debug("isFTTExceeded() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getVsanDatastoreName() {
        String string = null;
        logger.debug("getVsanDatastoreName() - start");
        if (this.nonCriticalVsanGroupMap == null || this.nonCriticalVsanGroupMap.isEmpty()) {
            return null;
        }
        String string2 = null;
        for (Map.Entry<Integer, LinkedHashSet<VsanHost>> entry : this.nonCriticalVsanGroupMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            string2 = ((VsanHost)entry.getValue().iterator().next()).getName();
            break;
        }
        if (string2 == null) {
            logger.debug("getVsanDatastoreName() - vSanHostname is null");
            return null;
        }
        logger.debug("getVsanDatastoreName() - using host: {}", string2);
        HostSystem hostSystem = this.services.getHostSystemUtils().getHostSystem(string2);
        if (hostSystem != null) {
            string = this.services.getHostSystemUtils().getVsanDatastoreName(hostSystem);
        }
        logger.debug("getVsanDatastoreName() - end, result: {}", string);
        return string;
    }

    public void createGroupLock(int n) {
        if (!this.virtualisationStatusStore.isGroupLocked(n)) {
            this.virtualisationStatusStore.createGroupLock(n);
        }
    }

    public void checkGroupLockRemoval() {
        logger.debug("checkGroupLockRemoval() - start");
        Set<Integer> set = this.virtualisationStatusStore.getGroupLocks();
        for (int n : set) {
            if (!this.virtualisationStatusStore.isGroupLocked(n)) continue;
            boolean bl = true;
            if (!this.areProtectedGroupHostsOk(n, bl)) {
                logger.debug("checkGroupLockRemoval() - all hosts for group: {} are not Ok", (Object)n);
                continue;
            }
            this.virtualisationStatusStore.removeGroupLock(n);
        }
        logger.debug("checkGroupLockRemoval() - end");
    }

    public boolean areProtectedGroupHostsOk(int n, boolean bl) {
        logger.debug("areProtectedGroupHostsOk() - start, group: {}, isHostInMaintenanceModeUnhealthy: {}", (Object)n, (Object)bl);
        if (!this.protectedVsanGroupMap.containsKey(n)) {
            logger.warn("areProtectedGroupHostsOk() - group: {} not found", (Object)n);
            return false;
        }
        boolean bl2 = true;
        for (VsanHost vsanHost : this.protectedVsanGroupMap.get(n)) {
            logger.debug("areProtectedGroupHostsOk() - checking host: {} for group: {}", (Object)vsanHost.getName(), (Object)n);
            if (this.theState.checkIfCriticalEventActive(vsanHost.getName())) {
                bl2 = false;
                break;
            }
            HostSystem hostSystem = this.services.getHostSystemUtils().getHostSystem(vsanHost.getName());
            if (this.services.getHostSystemUtils().isHostHealthy(hostSystem, vsanHost.getName(), bl)) continue;
            bl2 = false;
            break;
        }
        logger.debug("areProtectedGroupHostsOk() - end, result: {}", (Object)bl2);
        return bl2;
    }

    public boolean isFTTResolved() {
        logger.debug("isFTTResolved() - start");
        Set<Integer> set = this.virtualisationStatusStore.getGroupLocks();
        if (set.isEmpty()) {
            logger.debug("isFTTResolved() - no group locks found, FTT is OK");
            return true;
        }
        boolean bl = false;
        boolean bl2 = this.services.getVirtualConfigurationManager().isStartupWaitsForAllHostsOnlineEnabled();
        boolean bl3 = true;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl4 = true;
        for (int n2 : set) {
            if (!this.areProtectedGroupHostsOk(n2, bl4)) {
                bl3 = false;
                continue;
            }
            hashSet.add(n2);
        }
        if (bl2 && !bl3) {
            logger.info("isFTTResolved() - not ready to start VMs, there are still critical events/host accessibility issues on groups");
            return false;
        }
        if (hashSet.size() > 0) {
            logger.info("isFTTResolved() - removing locks on groups: {}", hashSet);
            hashSet.forEach(n -> this.virtualisationStatusStore.removeGroupLock((int)n));
        }
        if (!this.isFTTExceeded()) {
            bl = true;
        }
        logger.debug("isFTTResolved() - end, result: {}", (Object)bl);
        return bl;
    }

    public void unlockNonCriticalHosts(Set<String> set, Event event) {
        logger.debug("unlockNonCriticalHosts() - start, hosts: {}", set);
        if (set == null || set.isEmpty()) {
            return;
        }
        this.removeNonCriticalVsanHostsFromCriticalTimer(set, event);
        set.forEach(string -> this.virtualisationStatusStore.unlockHostForShutdown((String)string));
    }

    public void createGroupLocksForAllGroups() {
        logger.debug("createGroupLocksForAllGroups() - start");
        for (Map.Entry<Integer, LinkedHashSet<VsanHost>> entry : this.protectedVsanGroupMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            this.createGroupLock(entry.getKey());
        }
    }

    @Generated
    public Map<Integer, LinkedHashSet<VsanHost>> getNonCriticalVsanGroupMap() {
        return this.nonCriticalVsanGroupMap;
    }
}

