/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vsan;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.vmware.vim25.mo.HostSystem;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VsanSyncTraffic {
    private static Logger logger = LogManager.getLogger(VsanSyncTraffic.class);
    public static final String VSAN_SYNC_TRAFFIC_LSOM_OBJECTS = "lsom_objects";
    public static final String VSAN_SYNC_TRAFFIC_DISK_OBJECTS = "disk_objects";
    public static final String VSAN_SYNC_TRAFFIC_DOM_OBJECTS = "dom_objects";

    public boolean isSyncTrafficActiveForHost(HostSystem hostSystem) {
        logger.debug("isSyncTrafficActiveForHost() - start");
        if (hostSystem == null) {
            logger.debug("isSyncTrafficActiveForHost() - hostSystem is null");
            return false;
        }
        String string = this.getSyncTrafficForHost(hostSystem);
        if (string == null) {
            logger.debug("isSyncTrafficActiveForHost() - result is null");
            return false;
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = (JsonObject)Jsoner.deserialize((String)string);
        }
        catch (JsonException jsonException) {
            logger.debug("isSyncTrafficActiveForHost() - JsonException: ", (Throwable)jsonException);
        }
        catch (Exception exception) {
            logger.error("isSyncTrafficActiveForHost() - Exception: ", (Throwable)exception);
        }
        if (jsonObject == null) {
            logger.debug("isSyncTrafficActiveForHost() - parsed result is null");
            return false;
        }
        logger.debug("isSyncTrafficActiveForHost() - end");
        return this.isSyncTrafficActive(jsonObject);
    }

    private String getSyncTrafficForHost(HostSystem hostSystem) {
        String string = null;
        String[] stringArray = new String[]{};
        logger.debug("getSyncTrafficForHost() - start");
        try {
            if (hostSystem.getHostVsanInternalSystem() != null) {
                string = hostSystem.getHostVsanInternalSystem().querySyncingVsanObjects(stringArray);
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getSyncTrafficForHost() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("getSyncTrafficForHost() - Exception: ", (Throwable)exception);
        }
        logger.debug("getSyncTrafficForHost() - end");
        return string;
    }

    private boolean isSyncTrafficActive(JsonObject jsonObject) {
        JsonObject jsonObject2;
        JsonObject jsonObject3;
        boolean bl = false;
        logger.debug("isSyncTrafficActive() - start");
        JsonObject jsonObject4 = (JsonObject)jsonObject.get((Object)VSAN_SYNC_TRAFFIC_LSOM_OBJECTS);
        if (jsonObject4 != null) {
            if (!jsonObject4.isEmpty()) {
                logger.debug("isSyncTrafficActive() - lsom_objects not empty, sync traffic active");
                bl = true;
            } else {
                logger.debug("isSyncTrafficActive() - lsom_objects empty, sync traffic not active");
            }
        }
        if ((jsonObject3 = (JsonObject)jsonObject.get((Object)VSAN_SYNC_TRAFFIC_DISK_OBJECTS)) != null) {
            if (!jsonObject3.isEmpty()) {
                logger.debug("isSyncTrafficActive() - disk_objects not empty, sync traffic active");
                bl = true;
            } else {
                logger.debug("isSyncTrafficActive() - disk_objects empty, sync traffic not active");
            }
        }
        if ((jsonObject2 = (JsonObject)jsonObject.get((Object)VSAN_SYNC_TRAFFIC_DOM_OBJECTS)) != null) {
            if (!jsonObject2.isEmpty()) {
                logger.debug("isSyncTrafficActive() - dom_objects not empty, sync traffic active");
                bl = true;
            } else {
                logger.debug("isSyncTrafficActive() - dom_objects empty, sync traffic not active");
            }
        }
        logger.debug("isSyncTrafficActive() - end, result: {}", (Object)bl);
        return bl;
    }
}

