/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vsan;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanFaultToleranceThreshold;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanHost;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ClusterUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareESXiHostType;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.vsan.VsanHostConnection;
import com.apcc.pcns.vsan.VsanHostConnectionManager;
import com.apcc.pcns.vsan.VsanHostDetails;
import com.vmware.vim25.VsanHostHealthState;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VsanUtils {
    private static Logger logger = LogManager.getLogger(VsanUtils.class);
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private ClusterUtils clusterUtils;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private VsanHostConnectionManager vsanHostConnectionManager;
    @NonNull
    private VirtualizationLoggingUtils virtualizationLoggingUtils;

    public VsanUtils() {
    }

    public VsanUtils(@NonNull HostSystemUtils hostSystemUtils, @NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull ClusterUtils clusterUtils, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull ConfigurationManager configurationManager, @NonNull VMWareConnection vMWareConnection, VsanHostConnectionManager vsanHostConnectionManager, VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostUtils is marked non-null but is null");
        }
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigManager is marked non-null but is null");
        }
        if (clusterUtils == null) {
            throw new IllegalArgumentException("clusterUtils is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.clusterUtils = clusterUtils;
        this.advancedSetupHelper = advancedSetupHelper;
        this.config = configurationManager;
        this.vmwareConnection = vMWareConnection;
        this.vsanHostConnectionManager = vsanHostConnectionManager;
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
    }

    public VMWareESXiHostType isHostPartOfVsanCluster(ServiceInstance serviceInstance, String string) {
        if (serviceInstance == null) {
            logger.debug("isHostPartOfVsanCluster() - serviceInstance is null");
            return VMWareESXiHostType.STANDARD;
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("isHostPartOfVsanCluster() - hostname is null or empty");
            return VMWareESXiHostType.STANDARD;
        }
        return this.checkHostType(this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string));
    }

    public VsanHostHealthState getVsanClusterHealth() {
        VsanHostHealthState vsanHostHealthState = VsanHostHealthState.unknown;
        ClusterComputeResource clusterComputeResource = this.clusterUtils.findCluster();
        if (clusterComputeResource == null) {
            return null;
        }
        HostSystem[] hostSystemArray = clusterComputeResource.getHosts();
        HostSystem hostSystem = hostSystemArray[0];
        try {
            String string = hostSystem.getHostVsanSystem().queryHostStatus().getHealth();
            vsanHostHealthState = VsanHostHealthState.valueOf((String)string);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException);
        }
        return vsanHostHealthState;
    }

    public VMWareESXiHostType checkHostType(ServiceInstance serviceInstance, String string) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("ServiceInstance can't be null.");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Hostname can't be null or empty.");
        }
        HostSystem hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
        return this.checkHostType(hostSystem);
    }

    public VMWareESXiHostType checkHostType(HostSystem hostSystem) {
        VMWareESXiHostType vMWareESXiHostType = VMWareESXiHostType.STANDARD;
        try {
            if (VsanUtils.isHostVsanEnabled(hostSystem)) {
                vMWareESXiHostType = !this.hostSystemUtils.isHostPartOfCluster(hostSystem) ? VMWareESXiHostType.VSAN_WITNESS : VMWareESXiHostType.VSAN;
                logger.debug("checkHostType() - vSan Host: {}", (Object)vMWareESXiHostType);
            }
        }
        catch (RemoteException remoteException) {
            logger.error("checkHostType() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("checkHostType() - Exception: ", (Throwable)exception);
        }
        logger.trace("checkHostType() - result: {}", (Object)vMWareESXiHostType);
        return vMWareESXiHostType;
    }

    private static boolean isHostVsanEnabled(HostSystem hostSystem) throws RemoteException {
        boolean bl = false;
        if (hostSystem == null) {
            logger.info("isHostVsanEnabled() - hostSystem is null");
            return bl;
        }
        logger.trace("isHostVsanEnabled() - start, host: {}", (Object)hostSystem.getName());
        try {
            if (hostSystem.getHostVsanSystem() != null && hostSystem.getHostVsanSystem().getConfig() != null && hostSystem.getHostVsanSystem().getConfig().getEnabled().booleanValue()) {
                bl = true;
                logger.info("isHostVsanEnabled() - vSan is enabled on {}", (Object)hostSystem.getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("isHostVsanEnabled() - unable to determine if host is vSAN enabled, probably a powered off Witness Host");
        }
        logger.trace("isHostVsanEnabled() - result: {}", (Object)bl);
        return bl;
    }

    public Map<String, MappedHost> removeVsanTagsFromMappedHosts(Map<String, MappedHost> map) {
        if (!this.virtualConfigurationManager.isESXi()) {
            return map;
        }
        if (map == null) {
            return null;
        }
        HashMap<String, MappedHost> hashMap = new HashMap<String, MappedHost>();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!VsanUtils.isHostnameWithVsanTags(string)) continue;
            MappedHost mappedHost = map.get(string);
            iterator.remove();
            String string2 = VsanUtils.removeVsanTagsFromHostname(string);
            mappedHost.setHostIPAddress(string2);
            hashMap.put(string2, mappedHost);
        }
        if (!hashMap.isEmpty()) {
            map.putAll(hashMap);
        }
        logger.debug("removeVsanTagsFromMappedHosts() - result: {}", map);
        return map;
    }

    public List<String> removeVsanTagsFromHostlist(List<String> list) {
        if (!this.virtualConfigurationManager.isESXi()) {
            return list;
        }
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!VsanUtils.isHostnameWithVsanTags(string)) continue;
            list.set(i, VsanUtils.removeVsanTagsFromHostname(string));
        }
        logger.trace("removeVsanTagsFromHostlist() - result: {}", list);
        return list;
    }

    public static String removeVsanTagsFromHostname(String string) {
        if (string == null) {
            return null;
        }
        if (VsanUtils.isHostnameWithVsanTag(string)) {
            string = VsanUtils.removeVsanTagFromHostname(string);
            logger.debug("removeVsanTagsFromHostname() - removed {} from hostname: {}", (Object)"_vsan", (Object)string);
        } else if (VsanUtils.isHostnameWithVsanWitnessTag(string)) {
            string = VsanUtils.removeVsanWitnessTagFromHostname(string);
            logger.debug("removeVsanTagsFromHostname() - removed {} from hostname: {}", (Object)"_vsan", (Object)string);
        }
        return string;
    }

    public static boolean isHostnameWithVsanTags(String string) {
        return string.endsWith("_vsan") || string.endsWith("_vsan_witness");
    }

    public static boolean isHostnameWithVsanTag(String string) {
        return string.endsWith("_vsan");
    }

    public static boolean isHostnameWithVsanWitnessTag(String string) {
        return string.endsWith("_vsan_witness");
    }

    public static String addVsanTagToHostname(String string) {
        return string + "_vsan";
    }

    public static String addVsanWitnessTagToHostname(String string) {
        return string + "_vsan_witness";
    }

    public static String removeVsanTagFromHostname(String string) {
        return string.substring(0, string.length() - "_vsan".length());
    }

    public static String removeVsanWitnessTagFromHostname(String string) {
        return string.substring(0, string.length() - "_vsan_witness".length());
    }

    public LinkedHashSet<String> removeVsanTagsFromSet(LinkedHashSet<String> linkedHashSet) {
        return this.removeVsanTagsFromSet(linkedHashSet, true);
    }

    public LinkedHashSet<String> removeVsanTagsFromSet(LinkedHashSet<String> linkedHashSet, boolean bl) {
        if (linkedHashSet == null) {
            return null;
        }
        logger.debug("removeVsanTagsFromSet() - start, hosts: {}", linkedHashSet);
        if (!bl) {
            logger.debug("removeVsanTagsFromSet(): Non ESX result set {}", linkedHashSet);
            return linkedHashSet;
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet.stream().map(string -> VsanUtils.isHostnameWithVsanTags(string) ? VsanUtils.removeVsanTagsFromHostname(string) : string).collect(Collectors.toCollection(LinkedHashSet::new));
        logger.debug("removeVsanTagsFromSet(): ESX result set {}", (Object)linkedHashSet2);
        return linkedHashSet2;
    }

    public List<String> checkVsanConfigurationOfTargetHosts(List<String> list) {
        logger.info("checkVsanConfigurationOfTargetHosts() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                VMWareESXiHostType vMWareESXiHostType = this.checkHostType(serviceInstance, string);
                if (vMWareESXiHostType == VMWareESXiHostType.STANDARD) continue;
                if (vMWareESXiHostType == VMWareESXiHostType.VSAN) {
                    list.set(i, VsanUtils.addVsanTagToHostname(string));
                    logger.info("checkVsanConfigurationOfTargetHosts() - added vSAN tag to host: {}", (Object)string);
                    continue;
                }
                if (vMWareESXiHostType != VMWareESXiHostType.VSAN_WITNESS) continue;
                list.set(i, VsanUtils.addVsanWitnessTagToHostname(string));
                logger.info("checkVsanConfigurationOfTargetHosts() - added vSAN Witness tag to host: {}", (Object)string);
            }
        }
        logger.info("checkVsanConfigurationOfTargetHosts() - end, result: {}", list);
        return list;
    }

    public LinkedHashMap<String, MappedHost> checkVsanConfigurationOfMappedHosts(LinkedHashMap<String, MappedHost> linkedHashMap) {
        logger.info("checkVsanConfigurationOfMappedHosts() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            for (String string : linkedHashMap.keySet()) {
                VMWareESXiHostType vMWareESXiHostType = this.checkHostType(serviceInstance, string);
                if (vMWareESXiHostType == VMWareESXiHostType.STANDARD) continue;
                MappedHost mappedHost = linkedHashMap.get(string);
                if (vMWareESXiHostType == VMWareESXiHostType.VSAN) {
                    mappedHost.setVsanHost();
                    logger.info("checkVsanConfigurationOfMappedHosts() - setting host: {} to vSAN", (Object)string);
                } else if (vMWareESXiHostType == VMWareESXiHostType.VSAN_WITNESS) {
                    mappedHost.setVsanWitnessHost();
                    logger.info("checkVsanConfigurationOfMappedHosts() - setting host: {} to vSAN Witness", (Object)string);
                }
                linkedHashMap.put(string, mappedHost);
            }
        }
        logger.info("checkVsanConfigurationOfMappedHosts() - end, result: {}", linkedHashMap);
        return linkedHashMap;
    }

    public boolean isAnyMappedHostPartOfVsanCluster(Map<String, MappedHost> map) {
        if (map == null || map.size() <= 0) {
            return false;
        }
        boolean bl = false;
        for (String string : map.keySet()) {
            MappedHost mappedHost = map.get(string);
            if (!mappedHost.isVsanHost()) continue;
            logger.info("isAnyMappedHostPartOfVsanCluster() - found vSAN enabled host: {}", (Object)string);
            bl = true;
            break;
        }
        logger.info("isAnyMappedHostPartOfVsanCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isAnyTargetHostPartOfVsanCluster(List<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bl = false;
        for (String string : list) {
            if (!VsanUtils.isHostnameWithVsanTags(string)) continue;
            logger.info("isAnyTargetHostPartOfVsanCluster() - found vSAN enabled host: {}", (Object)string);
            bl = true;
            break;
        }
        logger.info("isAnyTargetHostPartOfVsanCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVsanCluster() {
        boolean bl = false;
        logger.trace("isVsanCluster() - start");
        if (this.virtualConfigurationManager.isManagedESXi()) {
            List<Host> list = this.hostSystemUtils.getConfiguredHosts();
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Host host : list) {
                    arrayList.add(host.getIPAddress());
                }
                bl = this.isAnyHostPartOfVsanCluster(arrayList);
            } else if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
                List<String> list2 = this.virtualConfigurationManager.parseHostListParameter("HostConfigSettings");
                bl = list2.stream().anyMatch(string -> VsanUtils.isHostnameWithVsanTags(string));
            } else {
                List list3 = this.advancedSetupHelper.readUPSSetupsFromConfig().stream().map(uPSSetup -> uPSSetup.getHosts()).collect(Collectors.toList());
                bl = list3.stream().anyMatch(linkedHashSet -> linkedHashSet.stream().anyMatch(string -> VsanUtils.isHostnameWithVsanTags(string)));
            }
        }
        logger.trace("isVsanCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isAnyHostPartOfVsanCluster(Collection<String> collection) {
        boolean bl = false;
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            for (String string : collection) {
                if (this.isHostPartOfVsanCluster(serviceInstance, string) != VMWareESXiHostType.VSAN) continue;
                bl = true;
                logger.info("isAnyHostPartOfVsanCluster() - Cluster Host Found:{}", (Object)string);
                break;
            }
        }
        logger.trace("isAnyHostPartOfVsanCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public Map<String, VsanHost> checkVsanHosts(Set<String> set) {
        HashMap<String, VsanHost> hashMap = new HashMap<String, VsanHost>();
        logger.debug("checkVsanHosts() - start");
        for (String string : set) {
            String string2;
            if (VsanUtils.isHostnameWithVsanTag(string)) {
                string2 = VsanUtils.removeVsanTagFromHostname(string);
                logger.debug("checkVsanHosts() - added vSAN host: {}", (Object)string);
                hashMap.put(string2, new VsanHost(string2, false, 0));
                continue;
            }
            if (VsanUtils.isHostnameWithVsanWitnessTag(string)) {
                string2 = VsanUtils.removeVsanWitnessTagFromHostname(string);
                logger.debug("checkVsanHosts() - added vSAN Witness host: {}", (Object)string);
                hashMap.put(string2, new VsanHost(string2, true, 0));
                continue;
            }
            string2 = this.vmwareConnection.getVCenterConnection();
            VMWareESXiHostType vMWareESXiHostType = this.isHostPartOfVsanCluster((ServiceInstance)string2, string);
            if (vMWareESXiHostType == VMWareESXiHostType.VSAN) {
                logger.warn("checkVsanHosts() - vSAN host: {} found without a vSAN tag", (Object)string);
                hashMap.put(string, new VsanHost(string, false, 0));
                continue;
            }
            if (vMWareESXiHostType != VMWareESXiHostType.VSAN_WITNESS) continue;
            logger.warn("checkVsanHosts() - vSAN host: {} found without a vSAN Witness tag", (Object)string);
            hashMap.put(string, new VsanHost(string, true, 0));
        }
        logger.debug("checkVsanHosts() - end");
        return hashMap;
    }

    public static boolean isVmUsingDatastore(VirtualMachine virtualMachine, String string) {
        boolean bl = false;
        if (virtualMachine == null || StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        logger.info("isVmUsingDatastore() - start");
        try {
            Datastore[] datastoreArray;
            for (Datastore datastore : datastoreArray = virtualMachine.getDatastores()) {
                if (datastore == null || !datastore.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("isVmUsingDatastore() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("isVmUsingDatastore() - Exception: ", (Throwable)exception);
        }
        logger.info("isVmUsingDatastore() - VM: {} using Datastore: {} result: {}", (Object)virtualMachine.getName(), (Object)string, (Object)bl);
        return bl;
    }

    public static boolean isAnyVMInArrayUsingDatastore(VirtualMachine[] virtualMachineArray, String string) {
        boolean bl = false;
        logger.info("isAnyVMInArrayUsingDatastore() - start");
        if (virtualMachineArray == null || virtualMachineArray.length <= 0 || StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        for (VirtualMachine virtualMachine : virtualMachineArray) {
            if (!VsanUtils.isVmUsingDatastore(virtualMachine, string)) continue;
            bl = true;
            break;
        }
        logger.info("isAnyVMInArrayUsingDatastore() - end, result: {}", (Object)bl);
        return bl;
    }

    public static boolean isVsanHostFoundInList(List<String> list, String string) {
        boolean bl = false;
        for (String string2 : list) {
            if (VsanUtils.isHostnameWithVsanTag(string2) && string2.equals(VsanUtils.addVsanTagToHostname(string))) {
                bl = true;
            } else if (VsanUtils.isHostnameWithVsanWitnessTag(string2) && string2.equals(VsanUtils.addVsanWitnessTagToHostname(string))) {
                bl = true;
            }
            if (!bl) continue;
            logger.info("isVsanHostFoundInList() - found vSAN tag in host: {}", (Object)string2);
            break;
        }
        logger.info("isVsanHostFoundInList() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isPCNSInstalledOnVsanHost() {
        boolean bl = false;
        logger.trace("isPCNSInstalledOnVsanHost() - start");
        ServiceInstance serviceInstance = this.getServiceInstance();
        if (serviceInstance != null) {
            HostSystem hostSystem = this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(serviceInstance);
            if (this.isVsanHost(hostSystem)) {
                logger.info("isPCNSInstalledOnVsanHost() - PCNS is installed on vSAN host: {}", (Object)hostSystem.getName());
                bl = true;
                logger.trace("isPCNSInstalledOnVsanHost() - true");
            }
        } else {
            logger.warn("isPCNSInstalledOnVsanHost() - serviceInstance is null");
        }
        logger.trace("isPCNSInstalledOnVsanHost() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVcsaOnAVsanHost() {
        boolean bl = false;
        logger.trace("isVcsaInstalledOnVsanHost() - start");
        ServiceInstance serviceInstance = this.getServiceInstance();
        if (serviceInstance != null) {
            HostSystem hostSystem = this.hostSystemUtils.getHostSystemWithVCSAInstalled();
            if (this.isVsanHost(hostSystem)) {
                logger.info("isVcsaInstalledOnVsanHost() - VCSA is installed on vSAN host: {}", (Object)hostSystem.getName());
                bl = true;
            }
        } else {
            logger.warn("isVcsaInstalledOnVsanHost() - serviceInstance is null");
        }
        logger.trace("isVcsaInstalledOnVsanHost() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVsanHost(HostSystem hostSystem) {
        boolean bl = false;
        if (hostSystem != null && this.checkHostType(hostSystem) == VMWareESXiHostType.VSAN) {
            bl = true;
        }
        return bl;
    }

    private ServiceInstance getServiceInstance() {
        ServiceInstance serviceInstance = null;
        if (this.virtualConfigurationManager.isManagedHost()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        } else if (this.virtualConfigurationManager.isUnmanagedHost()) {
            serviceInstance = this.vmwareConnection.getESXiHostInstance();
        }
        return serviceInstance;
    }

    public Set<Integer> getUnhealthyVsanSingleUpsGroups(Map<Integer, LinkedHashSet<VsanHost>> map) {
        logger.debug("getUnhealthyVsanSingleUpsGroups() - start");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = true;
        for (Map.Entry<Integer, LinkedHashSet<VsanHost>> entry : map.entrySet()) {
            VsanHost vsanHost;
            HostSystem hostSystem;
            if (entry.getValue().size() != 1 || this.hostSystemUtils.isHostHealthy(hostSystem = this.hostSystemUtils.getHostSystem((vsanHost = (VsanHost)entry.getValue().iterator().next()).getName()), vsanHost.getName(), bl)) continue;
            hashSet.add(entry.getKey());
        }
        logger.info("getUnhealthyVsanSingleUpsGroups() - end, result: {}", hashSet);
        return hashSet;
    }

    public String getWitnessHost(boolean bl) {
        logger.info("getWitnessHost() - start");
        String string = null;
        if (bl) {
            int n = 0;
            boolean bl2 = false;
            do {
                String string2 = ConfigurationKeys.getAdvancedSetupKey(n);
                try {
                    String string3 = this.config.getString(string2, "hostlist");
                    if (string3 != null) {
                        logger.debug("getWitnessHost() - checking in group: {}, hostlist: {}", (Object)string2, (Object)string3);
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "&");
                            String string5 = null;
                            string5 = stringTokenizer2.nextToken();
                            if (!VsanUtils.isHostnameWithVsanWitnessTag(string5)) continue;
                            string = VsanUtils.removeVsanWitnessTagFromHostname(string5);
                            logger.info("getWitnessHost() - found Witness Host: {}", (Object)string);
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                }
                catch (ConversionException conversionException) {
                    logger.warn("getWitnessHost() - ConversionException: {}", (Object)conversionException.getMessage());
                }
                ++n;
            } while (!bl2);
        } else {
            List<String> list = this.virtualConfigurationManager.parseHostListParameterWithVsanTags("HostConfigSettings");
            string = this.getWitnessHostFromList(list);
        }
        logger.debug("getWitnessHost() - result: {}", (Object)string);
        return string;
    }

    private String getWitnessHostFromList(Collection<String> collection) {
        String string = null;
        for (String string2 : collection) {
            if (!VsanUtils.isHostnameWithVsanWitnessTag(string2)) continue;
            String string3 = VsanUtils.removeVsanWitnessTagFromHostname(string2);
            if (string == null) {
                string = string3;
                logger.info("getWitnessHostFromList() - witness host: {}", (Object)string);
                continue;
            }
            logger.warn("getWitnessHostFromList() - found another witness host: {}", (Object)string3);
        }
        return string;
    }

    public VsanFaultToleranceThreshold getVsanFaultToleranceThreshold(ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        return new VsanFaultToleranceThreshold(shutdownState, serviceManager);
    }

    private void setIgnoreClusterMemberListUpdates(Set<String> set, boolean bl) {
        logger.debug("setIgnoreClusterMemberListUpdates() - start, set IgnoreClusterMemberUpdates to {}", (Object)(bl ? "active" : "inactive"));
        if (set == null || set.isEmpty()) {
            logger.debug("setIgnoreClusterMemberListUpdates() - no hosts given, unable to execute command");
            return;
        }
        String string = this.virtualConfigurationManager.getVCenterUsername();
        String string2 = this.virtualConfigurationManager.getVCenterPassword();
        set.stream().forEach(string3 -> {
            if (!this.isHostConfiguredAsVsanHost((String)string3)) {
                logger.debug("setIgnoreClusterMemberListUpdates() - skipping host {), not configured as vSAN host", string3);
                return;
            }
            String string4 = this.getWitnessHost(this.advancedSetupHelper.isAdvancedShutdownMode());
            if (StringUtils.equalsIgnoreCase((CharSequence)string4, (CharSequence)string3)) {
                logger.debug("setIgnoreClusterMemberListUpdates() - skipping witness host {}", string3);
                return;
            }
            logger.debug("setIgnoreClusterMemberListUpdates() - setting IgnoreClusterMemberListUpdates on host {}", string3);
            VsanHostDetails vsanHostDetails = new VsanHostDetails((String)string3, string, string2);
            VsanHostConnection vsanHostConnection = null;
            boolean bl2 = false;
            try {
                vsanHostConnection = this.vsanHostConnectionManager.createConnection(vsanHostDetails);
                vsanHostConnection.connect();
                bl2 = vsanHostConnection.setIgnoreClusterMemberListUpdates(bl);
            }
            catch (IOException iOException) {
                logger.error("setIgnoreClusterMemberListUpdates() - failed to connect to vSAN host {}, error: {}", string3, (Object)iOException);
            }
            logger.debug("setIgnoreClusterMemberListUpdates() - vSAN host {} IgnoreClusterMemberListUpdates set: {}", string3, (Object)bl2);
        });
    }

    public void activateIgnoreClusterMemberListUpdates(Set<String> set) {
        this.setIgnoreClusterMemberListUpdates(set, true);
    }

    public void deactivateIgnoreClusterMemberListUpdates(Set<String> set) {
        this.setIgnoreClusterMemberListUpdates(set, false);
    }

    private void executeRebootHelper(Set<String> set, boolean bl) {
        logger.debug("executeRebootHelper() - start, execute reboot helper command to {} VSAN cluster", (Object)(bl ? "prepare" : "recover"));
        if (set == null || set.isEmpty()) {
            logger.debug("executeRebootHelper() - no hosts given, unable to execute command");
            return;
        }
        String string = this.virtualConfigurationManager.getVCenterUsername();
        String string2 = this.virtualConfigurationManager.getVCenterPassword();
        String string3 = this.getWitnessHost(this.advancedSetupHelper.isAdvancedShutdownMode());
        String string5 = set.stream().filter(string4 -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)string3, (CharSequence)string4)) {
                logger.debug("executeRebootHelper() - skipping witness host {}", string4);
                return false;
            }
            if (!this.isHostConfiguredAsVsanHost((String)string4)) {
                logger.debug("executeRebootHelper() - skipping host {), not configured as vSAN host", string4);
                return false;
            }
            logger.debug("executeRebootHelper() - execute reboot helper command on host {}", string4);
            VsanHostDetails vsanHostDetails = new VsanHostDetails((String)string4, string, string2);
            VsanHostConnection vsanHostConnection = null;
            boolean bl2 = false;
            try {
                vsanHostConnection = this.vsanHostConnectionManager.createConnection(vsanHostDetails);
                vsanHostConnection.connect();
                if (bl) {
                    logger.debug("executeRebootHelper() - vSAN host found: {}, trying to execute command to prepare VSAN cluster for shutdown", string4);
                    bl2 = vsanHostConnection.setRebootHelperPrepare();
                    if (!bl2) {
                        this.logVsanClusterPrepareFailEvent();
                    }
                } else {
                    logger.debug("executeRebootHelper() - vSAN host found: {}, trying to execute command to recover VSAN cluster", string4);
                    bl2 = vsanHostConnection.setRebootHelperRecover();
                    if (!bl2) {
                        this.logVsanClusterRecoverFailEvent();
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("executeRebootHelper() - failed to connect to vSAN host {}, error: {}", string4, (Object)iOException);
            }
            logger.debug("executeRebootHelper() - vSAN host {} command executed: {}", string4, (Object)bl2);
            return bl2;
        }).findFirst().orElse(null);
        if (string5 == null) {
            logger.error("executeRebootHelper() - failed to execute reboot helper command on any of the hosts");
        } else {
            logger.debug("executeRebootHelper() - vSAN host {} command successfully executed", (Object)string5);
        }
    }

    public void prepareClusterShutown(Set<String> set) {
        this.executeRebootHelper(set, true);
    }

    public void recoverCluster(Set<String> set) {
        this.executeRebootHelper(set, false);
    }

    public boolean isHostConfiguredAsVsanHost(String string) {
        logger.debug("isHostConfiguredAsVsanHost() - start, checking host {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("isHostConfiguredAsVsanHost() - no hostname to check, returning false");
            return false;
        }
        List<Object> list = new ArrayList();
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            list = this.advancedSetupHelper.readVsanHostsFromConfig();
        } else {
            String string2 = this.config.getString("HostConfigSettings", "hostlist");
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                String[] stringArray = string2.split("\\|");
                list.addAll(Arrays.asList(stringArray));
            }
        }
        return list.contains(VsanUtils.addVsanTagToHostname(string));
    }

    public void logVsanClusterPrepareEvent() {
        this.virtualizationLoggingUtils.logVsanClusterPrepareEvent();
    }

    public void logVsanClusterPrepareFailEvent() {
        this.virtualizationLoggingUtils.logVsanClusterPrepareFailEvent();
    }

    public void logVsanClusterRecoverEvent() {
        this.virtualizationLoggingUtils.logVsanClusterRecoverEvent();
    }

    public void logVsanClusterRecoverFailEvent() {
        this.virtualizationLoggingUtils.logVsanClusterRecoverFailEvent();
    }

    public int getClusterPrepareDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getClusterPrepareDuration(bl, n);
    }

    public int getClusterRecoveryDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getClusterRecoveryDuration(bl, n);
    }

    public Map<Integer, LinkedHashSet<VsanHost>> getProtectedVsanGroupMap() {
        HashMap<Integer, LinkedHashSet<VsanHost>> hashMap = new HashMap<Integer, LinkedHashSet<VsanHost>>();
        logger.debug("getProtectedVsanGroupMap() - start");
        for (UPSSetup uPSSetup : this.advancedSetupHelper.readUPSSetupsFromConfig()) {
            for (String string : uPSSetup.getHosts()) {
                String string2 = null;
                boolean bl = false;
                if (VsanUtils.isHostnameWithVsanTag(string)) {
                    string2 = VsanUtils.removeVsanTagFromHostname(string);
                } else if (VsanUtils.isHostnameWithVsanWitnessTag(string)) {
                    string2 = VsanUtils.removeVsanWitnessTagFromHostname(string);
                    bl = true;
                }
                if (string2 == null) continue;
                LinkedHashSet linkedHashSet = null;
                linkedHashSet = hashMap.containsKey(uPSSetup.getGroup()) ? (LinkedHashSet)hashMap.get(uPSSetup.getGroup()) : new LinkedHashSet();
                linkedHashSet.add(new VsanHost(string2, bl, uPSSetup.getGroup()));
                hashMap.put(uPSSetup.getGroup(), linkedHashSet);
                logger.debug("getProtectedVsanGroupMap() - adding vSAN host: {}, setup: {}, witness: {}", (Object)string2, (Object)uPSSetup.getGroup(), (Object)bl);
            }
        }
        logger.debug("getProtectedVsanGroupMap() - end, found {} groups with protected vSAN hosts", (Object)hashMap.size());
        return hashMap;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setClusterUtils(@NonNull ClusterUtils clusterUtils) {
        if (clusterUtils == null) {
            throw new IllegalArgumentException("clusterUtils is marked non-null but is null");
        }
        this.clusterUtils = clusterUtils;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setVsanHostConnectionManager(@NonNull VsanHostConnectionManager vsanHostConnectionManager) {
        if (vsanHostConnectionManager == null) {
            throw new IllegalArgumentException("vsanHostConnectionManager is marked non-null but is null");
        }
        this.vsanHostConnectionManager = vsanHostConnectionManager;
    }

    @Generated
    public void setVirtualizationLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualizationLoggingUtils is marked non-null but is null");
        }
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
    }
}

