/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vsan;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VsanWitnessVMStartupRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VsanWitnessVMStartupRunnable.class);
    private ShutdownState theState;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public VsanWitnessVMStartupRunnable(ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theState = shutdownState;
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    @Override
    public void run() {
        String string = this.virtualisationStatusStore.getProperty("Witness_VM_HOST");
        if (string == null) {
            return;
        }
        String string2 = this.virtualisationStatusStore.getProperty("Witness_VM");
        if (string2 == null) {
            return;
        }
        this.checkVsanWitnessVmStartupConditions(string, string2);
    }

    private void checkVsanWitnessVmStartupConditions(String string, String string2) {
        logger.debug("checkVsanWitnessVmStartupConditions() - start, Management host: {}, Witness host VM name: {}", (Object)string, (Object)string2);
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
        }
        if (this.theState.checkIfCriticalEventActive(string)) {
            return;
        }
        if (serviceInstance == null) {
            logger.debug("checkVsanWitnessVmStartupConditions() - serviceInstance is null");
            return;
        }
        if (this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
            logger.debug("checkVsanWitnessVmStartupConditions() - Management host shutting down, not starting VM");
            return;
        }
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string2);
        }
        catch (RemoteException remoteException) {
            logger.debug("checkVsanWitnessVmStartupConditions() - RemoteException: " + String.valueOf(remoteException));
        }
        boolean bl = true;
        if (virtualMachine == null) {
            logger.debug("checkVsanWitnessVmStartupConditions() - VM is null");
        } else if (this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) {
            logger.debug("checkVsanWitnessVmStartupConditions() - VM is already powered on");
        } else if (this.services.getVirtualMachineUtils().isConnected(virtualMachine)) {
            if (!this.powerOnWitnessVm(virtualMachine, serviceInstance)) {
                bl = false;
            } else {
                this.services.getVirtualLoggingUtils().logVsanWitnessVMStartupLogEvent(string2);
            }
        } else {
            logger.error("checkVsanWitnessVmStartupConditions() - VM is not connected, unable to start");
            bl = false;
        }
        if (bl) {
            this.virtualisationStatusStore.removeProperty("Witness_VM_HOST");
            this.virtualisationStatusStore.removeProperty("Witness_VM");
        }
    }

    private boolean powerOnWitnessVm(VirtualMachine virtualMachine, ServiceInstance serviceInstance) {
        boolean bl = false;
        HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, serviceInstance);
        if (hostSystem == null) {
            logger.debug("powerOnWitnessVm() - hostSystem is null");
            return bl;
        }
        if (hostSystem.getRuntime().isInMaintenanceMode()) {
            logger.debug("powerOnWitnessVm() - not powering on Witness host VM as Management host is in Maintenance Mode");
            return bl;
        }
        logger.info("powerOnWitnessVm() - attempting to start Witness host VM");
        try {
            Task task = virtualMachine.powerOnVM_Task(hostSystem);
            String string = task.waitForTask();
            if (string.equals("success")) {
                logger.info("powerOnWitnessVm() - successfully powered on");
                bl = true;
            } else {
                logger.warn("powerOnWitnessVm() - failed to power on with taskResult: {}", (Object)string);
            }
        }
        catch (Exception exception) {
            logger.warn("powerOnWitnessVm() - Exception: {}", (Object)exception.getLocalizedMessage(), (Object)exception);
        }
        return bl;
    }
}

