/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentCertificateHostnameVerifier
implements HostnameVerifier {
    private static final Logger logger = LogManager.getLogger(AgentCertificateHostnameVerifier.class);
    private boolean acceptAll;
    private boolean validHost = false;

    public AgentCertificateHostnameVerifier(boolean bl) {
        this.acceptAll = bl;
        this.validHost = bl;
    }

    private String getCN(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            if (!string2.startsWith("cn=") && !string2.startsWith("CN=")) continue;
            return new String(string2.substring(3));
        }
        return "";
    }

    public synchronized boolean isValidHost() {
        logger.debug("isValidHost(): " + this.validHost);
        return this.validHost;
    }

    @Override
    public synchronized boolean verify(String string, SSLSession sSLSession) {
        this.validHost = this.acceptAll;
        if (this.acceptAll) {
            logger.info("Acepting all addresses");
        } else {
            logger.debug("Verifying SSL Cert.");
            try {
                Object object;
                X500Principal x500Principal = (X500Principal)sSLSession.getPeerPrincipal();
                String string2 = x500Principal.getName();
                String string3 = this.getCN(string2);
                InetAddress inetAddress = InetAddress.getByName(string);
                try {
                    object = InetAddress.getByName(string3);
                    if (((InetAddress)object).equals(inetAddress)) {
                        this.validHost = true;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    logger.info("Unknown Host Exception", (Throwable)unknownHostException);
                }
                if (!this.validHost) {
                    object = string3.replace(".", "\\.");
                    object = ((String)object).replace("*", ".*");
                    String string4 = inetAddress.getCanonicalHostName();
                    this.validHost = string4.matches((String)object);
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.info("Unknown Host Exception", (Throwable)unknownHostException);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                logger.info("SSLPeerUnverifiedException", (Throwable)sSLPeerUnverifiedException);
            }
        }
        logger.debug("Hostname is verified as " + this.validHost);
        return this.validHost;
    }
}

