/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.KeepAliveTimer;
import com.apcc.m11.components.stdpowersource.MyTimer;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.pcns.datagramservice.DatagramListener;
import com.apcc.pcns.datagramservice.DatagramManager;
import com.apcc.pcns.util.IPUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BroadcastReceiver
implements DatagramListener {
    private static final Logger logger = LogManager.getLogger(BroadcastReceiver.class);
    private static final int kMaximumPacketSize = 4096;
    private static final int kDefaultEventPort = 3052;
    private static boolean flag;
    private static boolean timerFlag;
    private String theLastStatusUptime = "0";
    private String theLastConfigUptime = "0";
    private DatagramSocket theSocket;
    private MyTimer myTimer = null;
    private Set<InetAddress> theLocalIpSet;
    private InetAddress theBroadcastAddress;
    private DataStore theDataStore;
    private FlexEventGenerator theFlexEventGenerator;
    private M11ComponentSynchronizer theSynchronizer;
    private KeepAliveTimer theKeepAliveTimer;
    private PowerSourceComponent thePowerSourceComponent;
    private DatagramManager datagramManager;

    public BroadcastReceiver(@NonNull DataStore dataStore, @NonNull FlexEventGenerator flexEventGenerator, @NonNull M11ComponentSynchronizer m11ComponentSynchronizer, @NonNull KeepAliveTimer keepAliveTimer, @NonNull PowerSourceComponent powerSourceComponent, @NonNull DatagramManager datagramManager) {
        if (dataStore == null) {
            throw new IllegalArgumentException("aDataStore is marked non-null but is null");
        }
        if (flexEventGenerator == null) {
            throw new IllegalArgumentException("aFlexEventGenerator is marked non-null but is null");
        }
        if (m11ComponentSynchronizer == null) {
            throw new IllegalArgumentException("aSynch is marked non-null but is null");
        }
        if (keepAliveTimer == null) {
            throw new IllegalArgumentException("aKeepAliveTimer is marked non-null but is null");
        }
        if (powerSourceComponent == null) {
            throw new IllegalArgumentException("aPowerSourceComponent is marked non-null but is null");
        }
        if (datagramManager == null) {
            throw new IllegalArgumentException("datagramManager is marked non-null but is null");
        }
        logger.debug("BroadcastReceiver created.");
        this.datagramManager = datagramManager;
        this.theDataStore = dataStore;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theSynchronizer = m11ComponentSynchronizer;
        this.theKeepAliveTimer = keepAliveTimer;
        this.thePowerSourceComponent = powerSourceComponent;
        try {
            this.theSocket = new DatagramSocket();
            logger.warn("Opening PCNS Packet Rebroadcast port:" + this.theSocket.getLocalPort());
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        if (!timerFlag) {
            this.myTimer = new MyTimer(flag, this.thePowerSourceComponent, this, datagramManager);
            flag = true;
        }
    }

    public boolean isListening() {
        boolean bl = false;
        try {
            bl = this.datagramManager.hasDatagramTask(this.thePowerSourceComponent.getEventPort());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Somthing went wrong, not listening", (Throwable)illegalArgumentException);
        }
        catch (CommunicationException communicationException) {
            logger.error("Somthing went wrong, not listening", (Throwable)communicationException);
        }
        return bl;
    }

    private void relay_status_packet(byte[] byArray) {
        try {
            String string = this.theDataStore.readValue("SU");
            if (string != null && !string.equals(this.theLastStatusUptime)) {
                String string2 = this.theDataStore.readValue("TA");
                logger.debug("packet_target :" + string2);
                if (this.isValidAddress(string2)) {
                    this.theLastStatusUptime = string;
                    this.relay_packet(string2, byArray);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Status Packet could not be relayed, Exception :", (Throwable)exception);
        }
    }

    private void relay_config_packet(byte[] byArray) {
        try {
            String string = this.theDataStore.readConfigItem("SU");
            if (string != null && !string.equals(this.theLastConfigUptime)) {
                String string2 = this.theDataStore.readConfigItem("TA");
                logger.debug("packet_target :" + string2);
                if (this.isValidAddress(string2)) {
                    this.theLastConfigUptime = string;
                    this.relay_packet(string2, byArray);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Status Packet could not be relayed. Exception :", (Throwable)exception);
        }
    }

    private void relay_packet(String string, byte[] byArray) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        int n = this.end_of_valid_data(byArray);
        if (inetAddress != null) {
            InetAddress inetAddress2 = this.getBroadcastAddress(inetAddress);
            try {
                logger.debug("relay_packet(): Rebroadcast out of port:" + this.theSocket.getLocalPort());
                logger.debug("relay_packet(): Relay to:" + String.valueOf(inetAddress2));
                logger.trace("relay_packet(): Data Length, {}", (Object)n);
                logger.trace("relay_packet(): Data: {}", (Object)StringUtils.toEncodedString((byte[])byArray, null));
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress2, 3052);
                this.theSocket.send(datagramPacket);
            }
            catch (Exception exception) {
                logger.warn("Packet could not be relayed. Exception :", (Throwable)exception);
                throw new IOException(exception);
            }
        }
    }

    private int end_of_valid_data(byte[] byArray) {
        int n = 4096;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                n = i;
                i = 4096;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private boolean isValidAddress(String string) {
        if (string != null) {
            string = string.trim();
        }
        logger.debug("Checking if " + string + " is a valid localhost address.");
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            Set<InetAddress> set = this.getLocalhostAddresses();
            for (InetAddress inetAddress : set) {
                String string2 = inetAddress.getHostAddress();
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                    logger.debug(string + " matches " + string2);
                    break;
                }
                logger.debug(string + " does not match " + string2);
            }
        }
        if (bl) {
            logger.debug(string + " is a valid localhost address.");
        } else {
            logger.debug(string + " is not a valid localhost address.");
        }
        return bl;
    }

    private InetAddress getBroadcastAddress(InetAddress inetAddress) {
        if (this.theBroadcastAddress == null) {
            logger.debug("theBroadcastAddress is null");
            try {
                this.theBroadcastAddress = IPUtils.getBroadcastAddress(inetAddress);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        logger.debug("returning " + (this.theBroadcastAddress != null ? this.theBroadcastAddress.getHostAddress() : "null"));
        return this.theBroadcastAddress;
    }

    private Set<InetAddress> getLocalhostAddresses() {
        if (this.theLocalIpSet == null) {
            logger.debug("theLocalIpSet is NULL");
            this.theLocalIpSet = new HashSet<InetAddress>();
            try {
                this.theLocalIpSet = IPUtils.getLocalhostAddresses();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        } else {
            logger.debug("returning existing theLocalIpSet");
        }
        return this.theLocalIpSet;
    }

    @Override
    public synchronized void update(byte[] byArray) {
        logger.trace("update(): Received Data: {}", (Object)StringUtils.toEncodedString((byte[])byArray, null));
        if (this.theSynchronizer.getState() == 2) {
            boolean bl = this.theDataStore.refreshStatusPage(byArray);
            if (bl) {
                try {
                    this.relay_status_packet(byArray);
                    this.theKeepAliveTimer.stillRunning();
                    this.theFlexEventGenerator.checkForFlexEvents();
                }
                catch (Exception exception) {
                    logger.debug("Received Data: exception 1 ");
                }
            } else {
                boolean bl2 = this.theDataStore.refreshConfigPage(byArray);
                if (bl2) {
                    try {
                        this.relay_config_packet(byArray);
                    }
                    catch (Exception exception) {
                        logger.debug("Received Data: exception 2 ");
                    }
                } else {
                    logger.trace("Received Data: ignoring packet ");
                }
            }
        }
    }
}

