/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommunicationsStatusLogEntry
implements Comparable<CommunicationsStatusLogEntry> {
    private InetAddress ip;
    private Date timestamp;
    private String entry;
    private List<Object> params;
    private Integer entryId;
    private static final Logger logger = LogManager.getLogger(CommunicationsStatusLogEntry.class);

    public CommunicationsStatusLogEntry(Integer n, Date date, InetAddress inetAddress, String string, List<Object> list) {
        this.ip = inetAddress;
        this.entryId = n;
        this.timestamp = date != null ? new Date(date.getTime()) : new Date();
        this.entry = string;
        this.params = list;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public String getEntry() {
        return this.entry;
    }

    public String getLogMsg(ResourceBundleWrapper resourceBundleWrapper) {
        String string = this.entry;
        try {
            string = Utils.getResourceString(resourceBundleWrapper, this.entry);
            List<Object> list = this.getParams();
            if (list != null) {
                string = MessageFormat.format(string, list.toArray());
            }
            if (string.contains("{*}") && list != null) {
                String string2 = CommunicationsStatusLogEntry.arrayToString(list.toArray());
                string = string.replaceAll("\\{\\*\\}", string2);
            }
        }
        catch (Exception exception) {
            logger.debug("error loading resource:" + this.entry, (Throwable)exception);
        }
        return string;
    }

    public List<Object> getParams() {
        return this.params;
    }

    @Override
    public int compareTo(CommunicationsStatusLogEntry communicationsStatusLogEntry) {
        return communicationsStatusLogEntry.entryId.compareTo(this.entryId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CommunicationsStatusLogEntry)) {
            return false;
        }
        CommunicationsStatusLogEntry communicationsStatusLogEntry = (CommunicationsStatusLogEntry)object;
        boolean bl = true;
        if (this.entry != null) {
            bl = this.entry.equals(communicationsStatusLogEntry.entry);
        } else {
            boolean bl2 = bl = communicationsStatusLogEntry.entry == null;
        }
        bl = this.ip != null ? (bl &= this.ip.equals(communicationsStatusLogEntry.ip)) : (bl &= communicationsStatusLogEntry.ip == null);
        bl = this.params != null ? (bl &= this.params.equals(communicationsStatusLogEntry.params)) : (bl &= communicationsStatusLogEntry.params == null);
        bl = this.timestamp != null ? (bl &= this.timestamp.equals(communicationsStatusLogEntry.timestamp)) : (bl &= communicationsStatusLogEntry.timestamp == null);
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.entry != null) {
            n += this.entry.hashCode();
        }
        if (this.ip != null) {
            n += this.ip.hashCode();
        }
        if (this.params != null) {
            n += this.params.hashCode();
        }
        if (this.timestamp != null) {
            n += this.timestamp.hashCode();
        }
        return n;
    }

    public static String arrayToString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            if (i == objectArray.length - 1) {
                stringBuilder.append(object.toString() + ".");
                continue;
            }
            stringBuilder.append(object.toString() + ", ");
        }
        return stringBuilder.toString();
    }
}

