/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.ObjectIdTree;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.dataobjects.adapter.MaStatusPage;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryCapacity;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryChargeStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryConnectionStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryLastReplacementDate;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryReplacementIndicator;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.BatteryRunTimeRemaining;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.NumberOfBadBatteries;
import com.apcc.m11.components.stdpowersource.dataobjects.battery.NumberOfBatteries;
import com.apcc.m11.components.stdpowersource.dataobjects.bypass.BypassContactorStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.bypass.BypassReason;
import com.apcc.m11.components.stdpowersource.dataobjects.bypass.BypassState;
import com.apcc.m11.components.stdpowersource.dataobjects.bypass.ManualBypassState;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.CommunicationConnect;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.CommunicationStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.CommunicationStatusLog;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.CommunicationStatusLogFinished;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.CommunicationType;
import com.apcc.m11.components.stdpowersource.dataobjects.communication.UPSConfigurationStatusDataRule;
import com.apcc.m11.components.stdpowersource.dataobjects.configuration.LowBatteryRuntime;
import com.apcc.m11.components.stdpowersource.dataobjects.control.TurnOffPowerSourceOnShutdown;
import com.apcc.m11.components.stdpowersource.dataobjects.control.TurnOffSOGOnShutdown;
import com.apcc.m11.components.stdpowersource.dataobjects.dependentdevices.ListOfDependentDevices;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.ContactFault1;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.ContactFault2;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.ContactFault3;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.ContactFault4;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.EnvironmentCommunicationStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.HiHumidityViolationProbe1;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.HiHumidityViolationProbe2;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.HiTempViolationProbe1;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.HiTempViolationProbe2;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.LowHumidityViolationProbe1;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.LowHumidityViolationProbe2;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.LowTempViolationProbe1;
import com.apcc.m11.components.stdpowersource.dataobjects.environment.LowTempViolationProbe2;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.CurrentRedundancy;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.LoadCapabilityStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.NumberOfBadInverters;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.NumberOfInverters;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.PowerModuleStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.RedundancyStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.faulttolerance.RequireLoadCapability;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.DateOfManufacture;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.EventSelector;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.FirmwareRevision;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.Model;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.PowerSourceIdentifier;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.ReadOnlyOptionalValue;
import com.apcc.m11.components.stdpowersource.dataobjects.identification.SerialNumber;
import com.apcc.m11.components.stdpowersource.dataobjects.input.InputLineVoltage;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.FanStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.InternalTempWarningIndicator;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.InternalTemperature;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.OutletName;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.OutletNameForMultipleOutlets;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.OutletState;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.OutletStateForMultipleOutlets;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.ParallelRedundancyStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.ParallelUnitsCount;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceShutdownDelay;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffOnBattery;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffPending;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffPendingForMultipleOutlets;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffPendingForNonOutletAwareUPS;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffTime;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OutputLineLoadPctPhase1;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OutputLineLoadPctPhase2;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OutputLineLoadPctPhase3;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OutputLineVoltage;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OutputState;
import com.apcc.m11.components.stdpowersource.dataobjects.output.OverloadState;
import com.apcc.m11.components.stdpowersource.dataobjects.output.SilconOutputStatus;
import com.apcc.m11.components.stdpowersource.dataobjects.output.SinglePowerFailedState;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.ESXIConfigurationMode;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.LocalHostAddress;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.MulticastAddress;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceAuthKey;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceAuthUsername;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceDataRequestPort;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceEventReceiverPort;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceIpAddress;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceOutletGroup;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceOutletGroupList;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourcePasswordPhrase;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourcePollInterval;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.PowerSourceProtocol;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.UnicastAddress;
import com.apcc.m11.ds.environment.Contacts;
import com.apcc.m11.ds.environment.Environment;
import com.apcc.m11.ds.environment.Humidity;
import com.apcc.m11.ds.environment.Temperature;
import com.apcc.m11.ds.esxiconfiguration.ESXIConfig;
import com.apcc.m11.ds.powersource.Adapter;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Bypass;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.Control;
import com.apcc.m11.ds.powersource.DependentDevices;
import com.apcc.m11.ds.powersource.FaultTolerance;
import com.apcc.m11.ds.powersource.Group;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.powersource.Input;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.util.Enumeration;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSourceAdapter
implements IDataSource {
    private static final Logger logger = LogManager.getLogger(DataSourceAdapter.class);
    private PowerSourceComponent thePowerSourceComponent;
    private DataStore theDataStore;
    private M11ComponentSynchronizer theSynchronizer;
    private ObjectIdTree theSupportedObjects;
    private ServiceManager services;

    public DataSourceAdapter(PowerSourceComponent powerSourceComponent, DataStore dataStore, M11ComponentSynchronizer m11ComponentSynchronizer, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.thePowerSourceComponent = powerSourceComponent;
        this.theDataStore = dataStore;
        this.theSynchronizer = m11ComponentSynchronizer;
        this.theSupportedObjects = new ObjectIdTree();
        this.buildObjectTree();
        this.setOutletGroup(null);
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theSynchronizer.getState() == 2) {
            IDataObject iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                throw new InvalidObjectIdException();
            }
            try {
                Object object = iDataObject.getValue();
                getResult.setValue(object);
            }
            catch (CommunicationException communicationException) {
                getResult.setError();
            }
            catch (InvalidValueException invalidValueException) {
                throw new InvalidObjectIdException((Throwable)invalidValueException);
            }
        } else {
            throw new CommunicationException();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theSynchronizer.getState() == 2) {
            IDataObject iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                throw new InvalidObjectIdException();
            }
            try {
                Object object = null;
                switch (n) {
                    case 0: {
                        object = iDataObject.getValue();
                        break;
                    }
                    case 2: {
                        object = iDataObject.getAllowedValues();
                        break;
                    }
                    case 1: {
                        object = iDataObject.getAvailability();
                        break;
                    }
                    case 3: {
                        object = iDataObject.getFormatter();
                        break;
                    }
                    default: {
                        getResult.setError();
                    }
                }
                getResult.setValue(object);
            }
            catch (CommunicationException communicationException) {
                getResult.setError();
            }
            catch (InvalidValueException invalidValueException) {
                throw new InvalidObjectIdException();
            }
        } else {
            throw new CommunicationException();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        IDataObject iDataObject;
        SetResult setResult = new SetResult();
        if (this.theSynchronizer.getState() == 2) {
            iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                setResult.setSuccessful(false);
                throw new InvalidObjectIdException();
            }
        } else {
            setResult.setSuccessful(false);
            throw new CommunicationException();
        }
        iDataObject.setValue(object, setResult);
        return setResult;
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(Group.kOid);
        vector.addElement(Environment.getGroup());
        vector.addElement(ESXIConfig.getGroup());
        return vector.elements();
    }

    private void buildObjectTree() {
        this.theSupportedObjects.addNode(Identification.ModelName.getObjectId(), (Object)new Model(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.ModelNameList.getObjectId(), (Object)new Model(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.PowerSourceID.getObjectId(), (Object)new PowerSourceIdentifier(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.SerialNumber.getObjectId(), (Object)new SerialNumber(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.ManufactureDate.getObjectId(), (Object)new DateOfManufacture(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.FirmwareRevision.getObjectId(), (Object)new FirmwareRevision(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.EventSelector.getObjectId(), (Object)new EventSelector(this.theDataStore));
        this.theSupportedObjects.addNode(Identification.UPS_SKU.getObjectId(), (Object)new ReadOnlyOptionalValue(this.theDataStore, "UPS_SKU"));
        this.theSupportedObjects.addNode(Identification.NMC_SKU.getObjectId(), (Object)new ReadOnlyOptionalValue(this.theDataStore, "NMC_SKU"));
        this.theSupportedObjects.addNode(Identification.NMC_FW.getObjectId(), (Object)new ReadOnlyOptionalValue(this.theDataStore, "NMC_FW"));
        this.theSupportedObjects.addNode(Communication.CommunicationStatus.getObjectId(), (Object)new CommunicationStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Communication.CommunicationType.getObjectId(), (Object)new CommunicationType());
        this.theSupportedObjects.addNode(Communication.CommunicationConnectLog.getObjectId(), (Object)new CommunicationStatusLog(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(Communication.CommunicationConnect.getObjectId(), (Object)new CommunicationConnect(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(Communication.CommunicationConnectLogStatus.getObjectId(), (Object)new CommunicationStatusLogFinished(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(Communication.UPSConfigurationStatus.getObjectId(), (Object)new UPSConfigurationStatusDataRule(this));
        this.theSupportedObjects.addNode(TCPIPCommunication.IpAddress.getObjectId(), (Object)new PowerSourceIpAddress(this.thePowerSourceComponent, this.services));
        this.theSupportedObjects.addNode(TCPIPCommunication.OutletGroup.getObjectId(), (Object)new PowerSourceOutletGroup(this.thePowerSourceComponent, this.theDataStore));
        this.theSupportedObjects.addNode(TCPIPCommunication.OutletGroupList.getObjectId(), (Object)new PowerSourceOutletGroupList(this.thePowerSourceComponent, this.theDataStore));
        this.theSupportedObjects.addNode(TCPIPCommunication.AuthUserName.getObjectId(), (Object)new PowerSourceAuthUsername(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(ESXIConfig.ChangeMode.getObjectId(), (Object)new ESXIConfigurationMode(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.PasswordPhrase.getObjectId(), (Object)new PowerSourcePasswordPhrase(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.AuthKey.getObjectId(), (Object)new PowerSourceAuthKey(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.PollInterval.getObjectId(), (Object)new PowerSourcePollInterval(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.EventReceiverPort.getObjectId(), (Object)new PowerSourceEventReceiverPort(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.DataRequestPort.getObjectId(), (Object)new PowerSourceDataRequestPort(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.LocalhostAddress.getObjectId(), (Object)new LocalHostAddress(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.Protocol.getObjectId(), (Object)new PowerSourceProtocol(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.MulticastAddress.getObjectId(), (Object)new MulticastAddress(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(TCPIPCommunication.UnicastAddress.getObjectId(), (Object)new UnicastAddress(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(OperatingStatus.InternalTemperature.getObjectId(), (Object)new InternalTemperature(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.InternalTemperatureWarningIndicator.getObjectId(), (Object)new InternalTempWarningIndicator(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.FanStatus.getObjectId(), (Object)new FanStatus(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffPending.getObjectId(), (Object)new PowerSourceTurnOffPending(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.OutletTurnOffPendingForMultipleOutlets.getObjectId(), (Object)new PowerSourceTurnOffPendingForMultipleOutlets(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.IsUPSOutletAware.getObjectId(), (Object)new PowerSourceTurnOffPendingForNonOutletAwareUPS(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.OutletNameForMultipleOutlets.getObjectId(), (Object)new OutletNameForMultipleOutlets(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.OutletStateForMultipleOutlets.getObjectId(), (Object)new OutletStateForMultipleOutlets(this.theDataStore));
        this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffTime.getObjectId(), (Object)new PowerSourceTurnOffTime(this.thePowerSourceComponent, this.theDataStore, this, null, this.services));
        this.theSupportedObjects.addNode(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)new PowerSourceShutdownDelay(this.thePowerSourceComponent, this.theDataStore, null));
        this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffOnBattery.getObjectId(), (Object)new PowerSourceTurnOffOnBattery(this.thePowerSourceComponent, this.theDataStore, this, null, this.services));
        this.theSupportedObjects.addNode(OperatingStatus.ParallelUnitsCount.getObjectId(), (Object)new ParallelUnitsCount(this.theDataStore));
        this.theSupportedObjects.addNode(Input.InputLineVoltage.getObjectId(), (Object)new InputLineVoltage(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OutputState.getObjectId(), (Object)new OutputState(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OverloadState.getObjectId(), (Object)new OverloadState(this.theDataStore));
        this.theSupportedObjects.addNode(Output.SilconOutputStatus.getObjectId(), (Object)new SilconOutputStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OutputLineVoltage.getObjectId(), (Object)new OutputLineVoltage(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OutputLineLoadPctPhase1.getObjectId(), (Object)new OutputLineLoadPctPhase1(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OutputLineLoadPctPhase2.getObjectId(), (Object)new OutputLineLoadPctPhase2(this.theDataStore));
        this.theSupportedObjects.addNode(Output.OutputLineLoadPctPhase3.getObjectId(), (Object)new OutputLineLoadPctPhase3(this.theDataStore));
        this.theSupportedObjects.addNode(Output.SinglePowerFailedState.getObjectId(), (Object)new SinglePowerFailedState(this.theDataStore, this));
        this.theSupportedObjects.addNode(Bypass.ManualBypassState.getObjectId(), (Object)new ManualBypassState(this.theDataStore));
        this.theSupportedObjects.addNode(Bypass.BypassState.getObjectId(), (Object)new BypassState(this.theDataStore));
        this.theSupportedObjects.addNode(Bypass.BypassReason.getObjectId(), (Object)new BypassReason(this.theDataStore));
        this.theSupportedObjects.addNode(Bypass.BypassContactorStatus.getObjectId(), (Object)new BypassContactorStatus(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.NumberOfInverters.getObjectId(), (Object)new NumberOfInverters(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.NumberOfBadInverters.getObjectId(), (Object)new NumberOfBadInverters(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.CurrentRedundancy.getObjectId(), (Object)new CurrentRedundancy(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.RequiredRedundancy.getObjectId(), (Object)new RequireLoadCapability(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.RedundancyStatus.getObjectId(), (Object)new RedundancyStatus(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.ParallelRedundancyStatus.getObjectId(), (Object)new ParallelRedundancyStatus(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.LoadCapabilityStatus.getObjectId(), (Object)new LoadCapabilityStatus(this.theDataStore));
        this.theSupportedObjects.addNode(FaultTolerance.PowerModuleStatus.getObjectId(), (Object)new PowerModuleStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.BatteryChargeStatus.getObjectId(), (Object)new BatteryChargeStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.LastBatteryReplacementDate.getObjectId(), (Object)new BatteryLastReplacementDate(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.BatteryCapacity.getObjectId(), (Object)new BatteryCapacity(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.RuntimeRemaining.getObjectId(), (Object)new BatteryRunTimeRemaining(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.RuntimeRemainingList.getObjectId(), (Object)new BatteryRunTimeRemaining(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.BatteryReplacementIndicator.getObjectId(), (Object)new BatteryReplacementIndicator(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.NumberOfBatteries.getObjectId(), (Object)new NumberOfBatteries(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.NumberOfBadBatteries.getObjectId(), (Object)new NumberOfBadBatteries(this.theDataStore));
        this.theSupportedObjects.addNode(Battery.BatteryDisconnected.getObjectId(), (Object)new BatteryConnectionStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Configuration.LowBatteryRuntime.getObjectId(), (Object)new LowBatteryRuntime(this.theDataStore));
        this.theSupportedObjects.addNode(Configuration.LowBatteryRuntimeList.getObjectId(), (Object)new LowBatteryRuntime(this.theDataStore));
        this.theSupportedObjects.addNode(Control.TurnOffPowerSourceOnShutdown.getObjectId(), (Object)new TurnOffPowerSourceOnShutdown(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(Control.TurnOffSOGOnShutdown.getObjectId(), (Object)new TurnOffSOGOnShutdown(this.thePowerSourceComponent));
        this.theSupportedObjects.addNode(Environment.EnvironmentCommunicationStatus.getObjectId(), (Object)new EnvironmentCommunicationStatus(this.theDataStore));
        this.theSupportedObjects.addNode(Temperature.HiTempViolationProbe1.getObjectId(), (Object)new HiTempViolationProbe1(this.theDataStore));
        this.theSupportedObjects.addNode(Temperature.HiTempViolationProbe2.getObjectId(), (Object)new HiTempViolationProbe2(this.theDataStore));
        this.theSupportedObjects.addNode(Temperature.LowTempViolationProbe1.getObjectId(), (Object)new LowTempViolationProbe1(this.theDataStore));
        this.theSupportedObjects.addNode(Temperature.LowTempViolationProbe2.getObjectId(), (Object)new LowTempViolationProbe2(this.theDataStore));
        this.theSupportedObjects.addNode(Humidity.HiHumidityViolationProbe1.getObjectId(), (Object)new HiHumidityViolationProbe1(this.theDataStore));
        this.theSupportedObjects.addNode(Humidity.HiHumidityViolationProbe2.getObjectId(), (Object)new HiHumidityViolationProbe2(this.theDataStore));
        this.theSupportedObjects.addNode(Humidity.LowHumidityViolationProbe1.getObjectId(), (Object)new LowHumidityViolationProbe1(this.theDataStore));
        this.theSupportedObjects.addNode(Humidity.LowHumidityViolationProbe2.getObjectId(), (Object)new LowHumidityViolationProbe2(this.theDataStore));
        this.theSupportedObjects.addNode(Contacts.ContactFault1.getObjectId(), (Object)new ContactFault1(this.theDataStore));
        this.theSupportedObjects.addNode(Contacts.ContactFault2.getObjectId(), (Object)new ContactFault2(this.theDataStore));
        this.theSupportedObjects.addNode(Contacts.ContactFault3.getObjectId(), (Object)new ContactFault3(this.theDataStore));
        this.theSupportedObjects.addNode(Contacts.ContactFault4.getObjectId(), (Object)new ContactFault4(this.theDataStore));
        this.theSupportedObjects.addNode(DependentDevices.ListOfDevices.getObjectId(), (Object)new ListOfDependentDevices(this.theDataStore));
        this.theSupportedObjects.addNode(DependentDevices.GroupListOfDevices.getObjectId(), (Object)new ListOfDependentDevices(this.theDataStore));
        this.theSupportedObjects.addNode(Adapter.MaStatusPage.getObjectId(), (Object)new MaStatusPage(this.theDataStore));
    }

    public void setOutletGroup(Integer n) {
        if (n != null && n >= 0) {
            this.theSupportedObjects.addNode(OperatingStatus.OutletName.getObjectId(), (Object)new OutletName(this.theDataStore, n));
            this.theSupportedObjects.addNode(OperatingStatus.OutletState.getObjectId(), (Object)new OutletState(this.theDataStore, n));
            this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffPending.getObjectId(), (Object)new PowerSourceTurnOffPending(this.theDataStore));
            this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffTime.getObjectId(), (Object)new PowerSourceTurnOffTime(this.thePowerSourceComponent, this.theDataStore, this, n, this.services));
            this.theSupportedObjects.addNode(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)new PowerSourceShutdownDelay(this.thePowerSourceComponent, this.theDataStore, n));
            this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffOnBattery.getObjectId(), (Object)new PowerSourceTurnOffOnBattery(this.thePowerSourceComponent, this.theDataStore, this, n, this.services));
        } else {
            try {
                if (this.theSupportedObjects.findNode(OperatingStatus.OutletName.getObjectId()) != null) {
                    this.theSupportedObjects.deleteNode(OperatingStatus.OutletName.getObjectId());
                }
                if (this.theSupportedObjects.findNode(OperatingStatus.OutletState.getObjectId()) != null) {
                    this.theSupportedObjects.deleteNode(OperatingStatus.OutletState.getObjectId());
                }
                this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffPending.getObjectId(), (Object)new PowerSourceTurnOffPending(this.theDataStore));
                this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffTime.getObjectId(), (Object)new PowerSourceTurnOffTime(this.thePowerSourceComponent, this.theDataStore, this, null, this.services));
                this.theSupportedObjects.addNode(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)new PowerSourceShutdownDelay(this.thePowerSourceComponent, this.theDataStore, null));
                this.theSupportedObjects.addNode(OperatingStatus.PowerSourceTurnOffOnBattery.getObjectId(), (Object)new PowerSourceTurnOffOnBattery(this.thePowerSourceComponent, this.theDataStore, this, null, this.services));
            }
            catch (RegistrationException registrationException) {
                logger.debug((Object)registrationException);
            }
        }
    }
}

