/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.components.stdpowersource.ITransportAdapter;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.TransportCommException;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataStore {
    private static final Logger logger = LogManager.getLogger(DataStore.class);
    private ITransportAdapter theTransportAdapter;
    private Hashtable<String, String> theDataSet;
    private ReentrantReadWriteLock dataSetLock;
    private Hashtable<String, String> theControlSet;
    private ReentrantReadWriteLock controlSetLock;
    private Hashtable<String, String> theConfigurationSet;
    private ReentrantReadWriteLock configurationSetLock;

    DataStore(ITransportAdapter iTransportAdapter) {
        this.theTransportAdapter = iTransportAdapter;
        this.dataSetLock = new ReentrantReadWriteLock();
        this.controlSetLock = new ReentrantReadWriteLock();
        this.configurationSetLock = new ReentrantReadWriteLock();
        this.theDataSet = null;
    }

    public String readValue(String string) throws CommunicationException, InvalidDataIdentifierException {
        String string2;
        block5: {
            string2 = null;
            logger.trace("Attempting to read from dataStore: " + string);
            if (this.theTransportAdapter != null) {
                this.dataSetLock.readLock().lock();
                try {
                    if (this.theDataSet != null) {
                        string2 = this.theDataSet.get(string);
                        break block5;
                    }
                    logger.trace("Data Set is null!");
                    throw new CommunicationException(1);
                }
                finally {
                    this.dataSetLock.readLock().unlock();
                }
            }
            logger.trace("TransportAdapter is null!");
            throw new CommunicationException();
        }
        logger.trace("DataStore: " + string + " : " + string2);
        return string2;
    }

    public Object readObject(String string) throws CommunicationException, InvalidDataIdentifierException {
        String string2;
        block5: {
            string2 = null;
            if (this.theTransportAdapter != null) {
                this.dataSetLock.readLock().lock();
                try {
                    if (this.theDataSet != null) {
                        string2 = this.theDataSet.get(string);
                        break block5;
                    }
                    throw new CommunicationException(1);
                }
                finally {
                    this.dataSetLock.readLock().unlock();
                }
            }
            throw new CommunicationException();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readControlItem(String string) throws CommunicationException, InvalidDataIdentifierException {
        String string2 = null;
        if (this.theTransportAdapter == null) throw new CommunicationException();
        try {
            this.controlSetLock.writeLock().lock();
            try {
                this.setControlSet(this.theTransportAdapter.getControlSet());
                if (this.theControlSet == null) return string2;
                string2 = this.theControlSet.get(string);
                this.invalidateControlSet();
                return string2;
            }
            finally {
                this.controlSetLock.writeLock().unlock();
            }
        }
        catch (TransportCommException transportCommException) {
            throw new CommunicationException(1);
        }
        catch (SSLException sSLException) {
            throw new CommunicationException(1);
        }
    }

    public String readConfigItem(String string) throws CommunicationException, InvalidDataIdentifierException {
        String string2;
        block5: {
            string2 = null;
            if (this.theTransportAdapter != null) {
                this.configurationSetLock.readLock().lock();
                try {
                    if (this.theConfigurationSet != null) {
                        string2 = this.theConfigurationSet.get(string);
                        break block5;
                    }
                    throw new CommunicationException(1);
                }
                finally {
                    this.configurationSetLock.readLock().unlock();
                }
            }
            throw new CommunicationException();
        }
        return string2;
    }

    public void writeValue(String string, String string2) {
        try {
            this.theTransportAdapter.setControlData(string, string2);
        }
        catch (Exception exception) {
            logger.error("Unable to write Value:" + string2 + " to:" + string, (Throwable)exception);
        }
    }

    public boolean refreshStatusPage(byte[] byArray) {
        boolean bl;
        block9: {
            bl = false;
            try {
                if (!this.theTransportAdapter.isAddressedToMe(byArray)) break block9;
                Hashtable<String, String> hashtable = this.theTransportAdapter.getDataSet(byArray);
                bl = true;
                this.setDataSet(hashtable);
                try {
                    Object object = this.readObject("SD");
                    if (object != null) {
                        logger.info("*** SD = " + object.toString());
                    }
                    if ((object = this.readObject("ST")) != null) {
                        logger.info("*** ST = " + object.toString());
                    } else {
                        logger.info("*** ST = <null>");
                    }
                    object = this.readObject("SM");
                    if (object != null) {
                        logger.info("*** SM = " + object.toString());
                    }
                }
                catch (CommunicationException communicationException) {
                    logger.info("Caught Exception: " + communicationException.toString());
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    logger.info("Caught Exception: " + invalidDataIdentifierException.toString());
                }
            }
            catch (TransportCommException transportCommException) {
                logger.trace((Object)transportCommException);
                bl = false;
            }
        }
        return bl;
    }

    public boolean refreshConfigPage(byte[] byArray) {
        boolean bl = false;
        try {
            if (this.theTransportAdapter.isAddressedToMe(byArray)) {
                this.setConfigurationSet(this.theTransportAdapter.getConfigurationSet(byArray));
                bl = true;
            }
        }
        catch (TransportCommException transportCommException) {
            logger.trace((Object)transportCommException);
            bl = false;
        }
        return bl;
    }

    public void invalidateDataSet() {
        this.dataSetLock.writeLock().lock();
        try {
            if (this.theDataSet != null) {
                this.theDataSet.clear();
                this.theDataSet = null;
            }
        }
        finally {
            this.dataSetLock.writeLock().unlock();
        }
    }

    public void invalidateControlSet() {
        this.controlSetLock.writeLock().lock();
        try {
            if (this.theControlSet != null) {
                this.theControlSet.clear();
                this.theControlSet = null;
            }
        }
        finally {
            this.controlSetLock.writeLock().unlock();
        }
    }

    public void invalidateConfigurationSet() {
        this.configurationSetLock.writeLock().lock();
        try {
            if (this.theConfigurationSet != null) {
                this.theConfigurationSet.clear();
                this.theConfigurationSet = null;
            }
        }
        finally {
            this.configurationSetLock.writeLock().unlock();
        }
    }

    public boolean isNetworkCommEstablished() {
        boolean bl = false;
        this.dataSetLock.readLock().lock();
        try {
            bl = this.theDataSet != null;
        }
        finally {
            this.dataSetLock.readLock().unlock();
        }
        return bl;
    }

    private void setDataSet(Hashtable<String, String> hashtable) {
        this.dataSetLock.writeLock().lock();
        try {
            this.invalidateDataSet();
            this.theDataSet = hashtable;
        }
        finally {
            this.dataSetLock.writeLock().unlock();
        }
    }

    private void setControlSet(Hashtable<String, String> hashtable) {
        this.controlSetLock.writeLock().lock();
        try {
            this.invalidateControlSet();
            this.theControlSet = hashtable;
        }
        finally {
            this.controlSetLock.writeLock().unlock();
        }
    }

    public void setConfigurationSet(Hashtable<String, String> hashtable) {
        this.configurationSetLock.writeLock().lock();
        try {
            this.invalidateConfigurationSet();
            this.theConfigurationSet = hashtable;
        }
        finally {
            this.configurationSetLock.writeLock().unlock();
        }
    }
}

