/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.stdpowersource.IEventHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalEventHandler
implements IEventConsumer {
    private static final Logger logger = LogManager.getLogger(ExternalEventHandler.class);
    private Vector<IEventProducer> theEventProducers = new Vector();
    private Vector<IEventHandler> theEventHandlers = new Vector();

    public void addEventHandler(IEventHandler iEventHandler) {
        this.theEventHandlers.addElement(iEventHandler);
    }

    private void executeEventHandler(Event event) {
        logger.trace(" executeShutdownEventHandler:" + String.valueOf(event.getObjectId()));
        if (this.theEventHandlers != null) {
            Enumeration<IEventHandler> enumeration = this.theEventHandlers.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                ObjectId objectId;
                IEventHandler iEventHandler = enumeration.nextElement();
                if (iEventHandler == null || !(objectId = iEventHandler.getTriggerObjectId()).equals((Object)event.getObjectId())) continue;
                logger.trace("executing:" + String.valueOf(iEventHandler.getClass()) + "becasue:" + String.valueOf(event.getObjectId()));
                iEventHandler.execute(event);
                bl = true;
            }
        }
        logger.trace(" DONE executeShutdownEventHandler:" + String.valueOf(event.getObjectId()));
    }

    public void registerEventProducer(IEventProducer iEventProducer) {
        if (iEventProducer != null) {
            this.theEventProducers.addElement(iEventProducer);
        }
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) {
        if (iEventProducer != null) {
            this.theEventProducers.removeElement(iEventProducer);
        }
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        if (this.theEventHandlers != null) {
            Enumeration<IEventHandler> enumeration = this.theEventHandlers.elements();
            while (enumeration.hasMoreElements()) {
                IEventHandler iEventHandler = enumeration.nextElement();
                if (iEventHandler == null) continue;
                ObjectId objectId = iEventHandler.getTriggerObjectId();
                vector.addElement(objectId);
            }
        }
        return vector.elements();
    }

    public void update(Event event) {
        if (event != null) {
            logger.info("StdPowerSource Received Event: " + event.toString() + " Active=" + event.isActive());
            if (event.isActive()) {
                this.executeEventHandler(event);
            } else {
                logger.info("Do not handle Cancel events");
            }
        }
    }
}

