/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.eventrules.AdvancedGroupOutletStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.AdvancedGroupOutletTurnOffInitiatedRule;
import com.apcc.m11.components.stdpowersource.eventrules.BatteryChargeStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.BypassContactorStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.BypassStateRule;
import com.apcc.m11.components.stdpowersource.eventrules.CommunicationStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.ContactFaultsRule;
import com.apcc.m11.components.stdpowersource.eventrules.EnvironmentCommunicationStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.HumidityProbeStateRule;
import com.apcc.m11.components.stdpowersource.eventrules.InternalTempRule;
import com.apcc.m11.components.stdpowersource.eventrules.LoadCapabilityRule;
import com.apcc.m11.components.stdpowersource.eventrules.LowBatteryStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.ManualBypassStateRule;
import com.apcc.m11.components.stdpowersource.eventrules.MonitoringStartedRule;
import com.apcc.m11.components.stdpowersource.eventrules.NewDataRule;
import com.apcc.m11.components.stdpowersource.eventrules.OutletStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.OutletTurnOffInitiatedRule;
import com.apcc.m11.components.stdpowersource.eventrules.OverloadStatusRule;
import com.apcc.m11.components.stdpowersource.eventrules.ParallelRedundancyRule;
import com.apcc.m11.components.stdpowersource.eventrules.PowerSourceTurnOffInitiatedRule;
import com.apcc.m11.components.stdpowersource.eventrules.PowerSourceTurnedOffRule;
import com.apcc.m11.components.stdpowersource.eventrules.RedundancyRule;
import com.apcc.m11.components.stdpowersource.eventrules.SilconHotStandbyRule;
import com.apcc.m11.components.stdpowersource.eventrules.TempProbeStateRule;
import com.apcc.m11.components.stdpowersource.eventrules.UtilityLineStatusRule;
import com.apcc.m11.ds.events.internalevents.powersource.OperationalEvents;
import com.apcc.pcns.ServiceManager;
import java.util.Enumeration;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlexEventGenerator
implements IEventProducer {
    private static final Logger logger = LogManager.getLogger(FlexEventGenerator.class);
    private IDataSource theDataSource;
    private PowerSourceComponent thePowerSourceComponent;
    private Vector<IEventConsumer> theEventConsumers;
    private Vector<IEventRule> theEventRules;
    private M11ComponentSynchronizer theSynchronizer;
    private ServiceManager services;

    public FlexEventGenerator(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, M11ComponentSynchronizer m11ComponentSynchronizer, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.thePowerSourceComponent = powerSourceComponent;
        this.theDataSource = iDataSource;
        this.theSynchronizer = m11ComponentSynchronizer;
        this.theEventConsumers = new Vector();
        this.theEventRules = new Vector();
        this.buildEventRules();
    }

    public synchronized void checkForFlexEvents() {
        logger.trace("Checking for FlexEvents() called");
        Enumeration<IEventRule> enumeration = this.theEventRules.elements();
        if (this.theSynchronizer.getState() == 2) {
            while (enumeration.hasMoreElements()) {
                IEventRule iEventRule = enumeration.nextElement();
                logger.debug("running rule:" + String.valueOf(iEventRule.getClass()));
                try {
                    iEventRule.execute();
                }
                catch (Exception exception) {
                    logger.error("Exception in rule: " + String.valueOf(iEventRule.getClass()) + ", message: " + exception.getMessage());
                }
            }
            this.postEvent(new Event(OperationalEvents.FlexRulesCompleteOnPacket.getObjectId(), true));
        }
    }

    public void runOneTimeEvents(IDataSource iDataSource) {
        logger.debug("runOneTimeEvents");
        if (this.theSynchronizer.getState() == 2) {
            if (iDataSource != null) {
                MonitoringStartedRule monitoringStartedRule = new MonitoringStartedRule(this, this.services.getProductVersion());
                monitoringStartedRule.execute();
            }
        } else {
            logger.debug("synchyronizer not running:" + this.theSynchronizer.getState());
        }
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) {
        this.theEventConsumers.addElement(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (!this.theEventConsumers.removeElement(iEventConsumer)) {
            throw new RegistrationException(2);
        }
    }

    public void postEvent(Event event) {
        if (event.getObjectId() == null) {
            logger.warn("Attempted to send a null event");
        } else {
            Enumeration<IEventConsumer> enumeration = this.theEventConsumers.elements();
            logger.info("Sending " + String.valueOf(event));
            while (enumeration.hasMoreElements()) {
                IEventConsumer iEventConsumer = enumeration.nextElement();
                try {
                    iEventConsumer.update(event);
                }
                catch (Exception exception) {
                    logger.error("Error handling event in component {} error {}", (Object)iEventConsumer.getClass(), (Object)exception.getLocalizedMessage());
                }
            }
        }
    }

    private void buildEventRules() {
        this.theEventRules.addElement(new CommunicationStatusRule(this.thePowerSourceComponent, this.theDataSource, this, this.services));
        this.theEventRules.addElement(new UtilityLineStatusRule(this.thePowerSourceComponent, this.theDataSource, this));
        this.theEventRules.addElement(new OverloadStatusRule(this.theDataSource, this));
        this.theEventRules.addElement(new LowBatteryStatusRule(this.theDataSource, this));
        this.theEventRules.addElement(new BatteryChargeStatusRule(this.theDataSource, this));
        this.theEventRules.addElement(new InternalTempRule(this.theDataSource, this));
        this.theEventRules.addElement(new ManualBypassStateRule(this.theDataSource, this));
        this.theEventRules.addElement(new BypassStateRule(this.theDataSource, this));
        this.theEventRules.addElement(new BypassContactorStatusRule(this.theDataSource, this));
        this.theEventRules.addElement(new LoadCapabilityRule(this.theDataSource, this));
        this.theEventRules.addElement(new RedundancyRule(this.theDataSource, this));
        this.theEventRules.addElement(new ParallelRedundancyRule(this.theDataSource, this));
        this.theEventRules.addElement(new PowerSourceTurnOffInitiatedRule(this.thePowerSourceComponent, this.theDataSource, this));
        this.theEventRules.addElement(new OutletTurnOffInitiatedRule(this.thePowerSourceComponent, this.theDataSource, this));
        this.theEventRules.addElement(new OutletStatusRule(this.thePowerSourceComponent, this.theDataSource, this));
        if (this.thePowerSourceComponent.isAdvancedMode() && this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV()) {
            this.theEventRules.addElement(new AdvancedGroupOutletTurnOffInitiatedRule(this.thePowerSourceComponent, this.theDataSource, this, this.services));
            this.theEventRules.addElement(new AdvancedGroupOutletStatusRule(this.thePowerSourceComponent, this.theDataSource, this));
        }
        this.theEventRules.addElement(new EnvironmentCommunicationStatusRule(this.theDataSource, this));
        this.theEventRules.addElement(new TempProbeStateRule(this.theDataSource, this));
        this.theEventRules.addElement(new HumidityProbeStateRule(this.theDataSource, this));
        this.theEventRules.addElement(new ContactFaultsRule(this.theDataSource, this));
        this.theEventRules.addElement(new NewDataRule(this.theDataSource, this));
        this.theEventRules.addElement(new PowerSourceTurnedOffRule(this.theDataSource, this));
        this.theEventRules.addElement(new SilconHotStandbyRule(this.theDataSource, this));
    }
}

