/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.AgentCertificateHostnameVerifier;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UntrustedCertificateException;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpFormPoster
extends Thread {
    private static final Logger logger = LogManager.getLogger(HttpFormPoster.class);
    private long timeoutMs = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    private URL theURL;
    private String thePostData;
    private SetResult theSetResult;
    private TrustStoreManager trustStoreManager;
    private UnverifiedCertificateManager unverifiedCertificateManager;

    public HttpFormPoster(URL uRL, String string, SetResult setResult, ApplicationErrorHandler applicationErrorHandler, TrustStoreManager trustStoreManager, UnverifiedCertificateManager unverifiedCertificateManager) {
        logger.trace("Entering HttpFormPoster constructor");
        this.unverifiedCertificateManager = unverifiedCertificateManager;
        this.trustStoreManager = trustStoreManager;
        this.thePostData = string;
        this.theSetResult = setResult;
        this.theURL = uRL;
        logger.trace("Leaving HttpFormPoster constructor");
    }

    private CloseableHttpResponse postData(URL uRL, String string) throws IOException {
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            logger.info("handler.pkgs:" + System.getProperty("java.protocol.handler.pkgs"));
            final Http1Config http1Config = Http1Config.custom().setMaxHeaderCount(200).build();
            DefaultHttpResponseParserFactory defaultHttpResponseParserFactory = new DefaultHttpResponseParserFactory(){

                public HttpMessageParser<ClassicHttpResponse> create() {
                    BasicLineParser basicLineParser = new BasicLineParser(){

                        public Header parseHeader(CharArrayBuffer charArrayBuffer) {
                            try {
                                return super.parseHeader(charArrayBuffer);
                            }
                            catch (ParseException parseException) {
                                return new BasicHeader(charArrayBuffer.toString(), null);
                            }
                        }
                    };
                    return new DefaultHttpResponseParser(http1Config, (LineParser)basicLineParser, (HttpResponseFactory)DefaultClassicHttpResponseFactory.INSTANCE);
                }
            };
            DefaultHttpRequestWriterFactory defaultHttpRequestWriterFactory = new DefaultHttpRequestWriterFactory();
            CharCodingConfig charCodingConfig = CharCodingConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(StandardCharsets.UTF_8).build();
            ManagedHttpClientConnectionFactory managedHttpClientConnectionFactory = new ManagedHttpClientConnectionFactory(http1Config, charCodingConfig, (HttpMessageWriterFactory)defaultHttpRequestWriterFactory, (HttpMessageParserFactory)defaultHttpResponseParserFactory);
            SSLContext sSLContext = this.trustStoreManager.makeSSLContext();
            DefaultClientTlsStrategy defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, (HostnameVerifier)new AgentCertificateHostnameVerifier(true));
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy).setConnectionFactory((HttpConnectionFactory)managedHttpClientConnectionFactory).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).build();
            poolingHttpClientConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
            poolingHttpClientConnectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.timeoutMs)).setSocketTimeout(Timeout.ofMilliseconds((long)this.timeoutMs)).setValidateAfterInactivity((TimeValue)Timeout.ofSeconds((long)10L)).setTimeToLive((TimeValue)Timeout.ofHours((long)1L)).build());
            poolingHttpClientConnectionManager.setDefaultTlsConfig(TlsConfig.custom().setHandshakeTimeout(Timeout.ofSeconds((long)30L)).build());
            poolingHttpClientConnectionManager.setMaxTotal(100);
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(10);
            RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
            try (CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig).build();){
                HttpPost httpPost = new HttpPost(uRL.toString());
                httpPost.setConfig(requestConfig);
                StringEntity stringEntity = new StringEntity(string);
                httpPost.setEntity((HttpEntity)stringEntity);
                HttpClientContext httpClientContext = ContextBuilder.create().build();
                closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpPost);
            }
        }
        catch (SSLException sSLException) {
            X509Certificate[] x509CertificateArray = null;
            if (sSLException.getCause() instanceof UntrustedCertificateException) {
                UntrustedCertificateException untrustedCertificateException = (UntrustedCertificateException)sSLException.getCause();
                x509CertificateArray = untrustedCertificateException.getChain();
            }
            if (x509CertificateArray != null) {
                this.unverifiedCertificateManager.addCertificateChain(uRL.getHost(), Arrays.asList(x509CertificateArray));
            }
            throw sSLException;
        }
        return closeableHttpResponse;
    }

    @Override
    public void run() {
        logger.trace("Entering HttpFormPoster.run()");
        if (this.theURL != null) {
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                closeableHttpResponse = this.postData(this.theURL, this.thePostData);
                if (closeableHttpResponse != null) {
                    int n = closeableHttpResponse.getCode();
                    if (n == 200) {
                        this.theSetResult.setSuccessful(true);
                    }
                    this.theSetResult.setSuccessful(false);
                }
                logger.debug("Got wrong thing back from the server");
                this.theSetResult.setSuccessful(false);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error("Error connecting to {}, {}", (Object)this.theURL, (Object)malformedURLException);
                this.theSetResult.setSuccessful(false);
            }
            catch (SocketException socketException) {
                logger.error("SocketException connecting to " + String.valueOf(this.theURL) + " maybe because of wrong protocol:" + String.valueOf(socketException.getClass()) + "," + String.valueOf(socketException.getCause()));
                this.theSetResult.setSuccessful(false);
            }
            catch (IOException iOException) {
                logger.warn("Error reading URL " + String.valueOf(this.theURL) + ". This does not always mean there was an issue.");
            }
            finally {
                try {
                    if (closeableHttpResponse != null) {
                        closeableHttpResponse.close();
                        closeableHttpResponse = null;
                    }
                }
                catch (IOException iOException) {
                    logger.warn((Object)iOException);
                }
            }
        } else {
            this.theSetResult.setSuccessful(false);
        }
        logger.trace("Leaving HttpFormPoster.run()");
    }
}

