/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.components.stdpowersource.AgentCertificateHostnameVerifier;
import com.apcc.m11.components.stdpowersource.ConfigHtmlPageParser;
import com.apcc.m11.components.stdpowersource.ITransportAdapter;
import com.apcc.m11.components.stdpowersource.NameValueHtmlPageParser;
import com.apcc.m11.components.stdpowersource.PCNSCommsDisabledException;
import com.apcc.m11.components.stdpowersource.TransportCommException;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UntrustedCertificateException;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpTransportAdapter
implements ITransportAdapter {
    private static final int kMaxBufferSize = 8192;
    private static final Logger logger = LogManager.getLogger(HttpTransportAdapter.class);
    private static final String PCNS_DISABLED_MSG = "PCNS is not enabled";
    private int timeoutMs = (int)TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    private Boolean addedCertToKeystore = false;
    private int theHttpPort;
    private char[] theRawHttpConfigBuffer = new char[8192];
    private char[] theRawHttpControlBuffer = new char[8192];
    private char[] theRawHttpStatusBuffer = new char[8192];
    protected String protocol = "http";
    protected InetAddress theHost;
    protected Map<String, String> theKnownNMCs = new HashMap<String, String>();
    protected ApplicationErrorHandler errorHandler;
    protected TrustStoreManager trustStoreManager;
    protected UnverifiedCertificateManager unverifiedCertManager;

    public HttpTransportAdapter(String string, InetAddress inetAddress, Integer n, ApplicationErrorHandler applicationErrorHandler, TrustStoreManager trustStoreManager, UnverifiedCertificateManager unverifiedCertificateManager) {
        this.errorHandler = applicationErrorHandler;
        this.unverifiedCertManager = unverifiedCertificateManager;
        this.trustStoreManager = trustStoreManager;
        this.theHost = inetAddress;
        this.setHttpProtocol(string);
        this.theHttpPort = n != null ? n : 80;
    }

    public Boolean addedCertToKeystore() {
        Boolean bl = this.addedCertToKeystore;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable<String, String> getConfigurationSet(byte[] byArray) throws TransportCommException {
        Hashtable<String, String> hashtable = null;
        ByteArrayInputStream byteArrayInputStream = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        InputStreamReader inputStreamReader = null;
        CharArrayReader charArrayReader = null;
        if (this.theHost != null) {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                inputStreamReader = new InputStreamReader(byteArrayInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                int n = bufferedReader.read(this.theRawHttpConfigBuffer, 0, 8192);
                if (n > 0) {
                    charArrayReader = new CharArrayReader(this.theRawHttpConfigBuffer);
                    bufferedReader2 = new BufferedReader(charArrayReader);
                    hashtable = ConfigHtmlPageParser.parse(bufferedReader2);
                }
                throw new TransportCommException("getConfigurationSet - Could not read information from power source");
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (bufferedReader2 != null) {
                    try {
                        bufferedReader2.close();
                        bufferedReader2 = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                        inputStreamReader = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
            }
        } else {
            throw new TransportCommException();
        }
        if (hashtable == null || !hashtable.containsKey("PT")) {
            throw new TransportCommException();
        }
        return hashtable;
    }

    public BufferedReader getReader(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        AgentCertificateHostnameVerifier agentCertificateHostnameVerifier = null;
        URLConnection uRLConnection = null;
        try {
            logger.info("handler.pkgs: {}", (Object)System.getProperty("java.protocol.handler.pkgs"));
            uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(this.timeoutMs);
            uRLConnection.setReadTimeout(this.timeoutMs);
            if (uRLConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
                agentCertificateHostnameVerifier = new AgentCertificateHostnameVerifier(true);
                httpsURLConnection.setHostnameVerifier(agentCertificateHostnameVerifier);
                httpsURLConnection.setSSLSocketFactory(this.trustStoreManager.makeSSLSocketFactory());
            }
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        }
        catch (SSLException sSLException) {
            logger.debug("The certificate has not been accepted, probably, for: {}", (Object)uRL.getHost());
            logger.debug("Exception was: {}", (Throwable)sSLException);
            X509Certificate[] x509CertificateArray = null;
            if (sSLException.getCause() instanceof UntrustedCertificateException) {
                UntrustedCertificateException untrustedCertificateException = (UntrustedCertificateException)sSLException.getCause();
                x509CertificateArray = untrustedCertificateException.getChain();
            }
            if (x509CertificateArray == null) {
                logger.warn("No cert Chain");
            } else {
                this.unverifiedCertManager.addCertificateChain(uRL.getHost(), Arrays.asList(x509CertificateArray));
                logger.warn("Clearing the chain");
            }
            throw sSLException;
        }
        catch (ConnectException connectException) {
            logger.debug("Failed to connect to {}", (Object)uRL.toString());
            logger.warn((Object)connectException);
            throw connectException;
        }
        catch (IOException iOException) {
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                logger.debug("code : {}", (Object)n);
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                String string = bufferedReader2.readLine();
                if (n == 405 && PCNS_DISABLED_MSG.equals(string)) {
                    logger.debug("Host connection failed:{}", (Object)n);
                    throw new PCNSCommsDisabledException();
                }
                logger.warn("Unknown response from NMS: {}:{}", (Object)n, (Object)string);
            }
            if (agentCertificateHostnameVerifier != null && !agentCertificateHostnameVerifier.isValidHost()) {
                logger.warn("The Host Verifier reported an invalid Host", (Throwable)iOException);
            }
            throw iOException;
        }
        return bufferedReader;
    }

    @Override
    public Hashtable<String, String> getControlSet() throws TransportCommException, SSLException {
        Hashtable<String, String> hashtable = null;
        logger.trace("Entering HttpTransportAdapter.getControlSet()");
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        CharArrayReader charArrayReader = null;
        this.addedCertToKeystore = Boolean.FALSE;
        if (this.theHost != null) {
            boolean bl = false;
            URL uRL = null;
            do {
                block32: {
                    bl = false;
                    try {
                        uRL = new URL(this.protocol, this.theHost.getHostAddress(), this.theHttpPort, "/macontrol.htm");
                        logger.trace("HttpTransportdapter.getControlSet() polling at <{}>", (Object)uRL.toString());
                        bufferedReader = this.getReader(uRL);
                        int n = bufferedReader.read(this.theRawHttpControlBuffer, 0, 8192);
                        logger.trace("HttpTransportAdapter.getControlSet() read http page");
                        if (n > 0) {
                            charArrayReader = new CharArrayReader(this.theRawHttpControlBuffer);
                            bufferedReader2 = new BufferedReader(charArrayReader);
                            logger.trace("HttpTransportAdapter.getControlSet() about to parse page");
                            hashtable = NameValueHtmlPageParser.parse(bufferedReader2);
                            break block32;
                        }
                        throw new TransportCommException("Could not read information from power source 1:" + uRL.getHost());
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error("Malformed URL", (Throwable)malformedURLException);
                    }
                    catch (SocketException socketException) {
                        logger.error("Exception connecting to {}, {} ", uRL, (Object)socketException);
                        throw new TransportCommException("Could not read information from power source " + this.protocol + this.theHost.getHostAddress() + this.theHttpPort, socketException);
                    }
                    catch (SSLException sSLException) {
                        logger.debug("IP: {} not accepting certs", (Object)this.theHost.getHostAddress());
                        ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle("com.apcc.m11.components.omaha.i18n.OmahaEventDescriptions", Locale.getDefault());
                        if (resourceBundleWrapper != null && this.errorHandler != null) {
                            String string = Utils.getResourceString(resourceBundleWrapper, "NotAcceptedCertificate");
                            string = string.replaceAll("\\{0\\}", this.theHost.getHostAddress());
                            string = string.replaceAll("\\{1\\}", ApcHelp.getOnClick(ApcHelp.NETWORK_MANAGEMENT_CARD_CONNECTION));
                            this.errorHandler.put(string);
                        }
                        throw sSLException;
                    }
                    catch (PCNSCommsDisabledException pCNSCommsDisabledException) {
                        logger.warn("PowerChute Communications is disabled on the NMC");
                        throw new TransportCommException(pCNSCommsDisabledException);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)iOException);
                        throw new TransportCommException(iOException);
                    }
                    catch (Exception exception) {
                        logger.error("Exception:", (Throwable)exception);
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        logger.error("Throwable:", throwable);
                        throw throwable;
                    }
                    finally {
                        logger.trace("Finaly");
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                                bufferedReader = null;
                            }
                            catch (IOException iOException) {
                                logger.debug((Object)iOException);
                            }
                        }
                        if (bufferedReader2 != null) {
                            try {
                                bufferedReader2.close();
                                bufferedReader2 = null;
                            }
                            catch (IOException iOException) {
                                logger.debug((Object)iOException);
                            }
                        }
                        if (charArrayReader != null) {
                            charArrayReader.close();
                            charArrayReader = null;
                        }
                    }
                }
                logger.trace("Pass done for: {} retry={}", (Object)this.theHost.getHostAddress(), (Object)bl);
            } while (bl);
        } else {
            logger.warn("HttpTransportAdapter.getControlSet() host is null");
            throw new TransportCommException();
        }
        logger.trace("Leaving HttpTransportAdapter.getControlSet()");
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable<String, String> getDataSet(byte[] byArray) throws TransportCommException {
        Hashtable<String, String> hashtable = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        ByteArrayInputStream byteArrayInputStream = null;
        InputStreamReader inputStreamReader = null;
        CharArrayReader charArrayReader = null;
        if (this.theHost != null) {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                inputStreamReader = new InputStreamReader(byteArrayInputStream);
                bufferedReader2 = new BufferedReader(inputStreamReader);
                int n = bufferedReader2.read(this.theRawHttpStatusBuffer, 0, 8192);
                if (n > 0) {
                    charArrayReader = new CharArrayReader(this.theRawHttpStatusBuffer);
                    bufferedReader = new BufferedReader(charArrayReader);
                    hashtable = NameValueHtmlPageParser.parse(bufferedReader);
                    hashtable.put("mastatus", new String(this.theRawHttpStatusBuffer));
                }
                throw new TransportCommException("getDataSet() Could not read information from power source");
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (bufferedReader2 != null) {
                    try {
                        bufferedReader2.close();
                        bufferedReader2 = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                        inputStreamReader = null;
                    }
                    catch (IOException iOException) {
                        logger.info((Object)iOException);
                    }
                }
                if (charArrayReader != null) {
                    charArrayReader.close();
                    charArrayReader = null;
                }
            }
        } else {
            throw new TransportCommException();
        }
        if (hashtable == null || hashtable.containsKey("PT")) {
            throw new TransportCommException();
        }
        return hashtable;
    }

    @Override
    public boolean isAddressedToMe(byte[] byArray) {
        try {
            for (int i = 0; i < byArray.length - 3; ++i) {
                if (byArray[i] != 80 || byArray[i + 1] != 67 || byArray[i + 2] != 61) continue;
                Object object = "";
                for (int j = 3; j < 46 && i + j < byArray.length && (char)byArray[i + j] != '\n'; ++j) {
                    object = (String)object + (char)byArray[i + j];
                }
                logger.trace("found ip in packet:" + (String)object);
                String string = null;
                try {
                    string = InetAddress.getByName((String)object).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    logger.trace("unable to get full version of IP:" + (String)object);
                }
                if (object != null && string != null && string.equalsIgnoreCase(this.theHost.getHostAddress())) {
                    logger.trace("This packets is valid: " + string);
                    return true;
                }
                logger.trace("This packets is NOT valid: " + string);
                return false;
            }
            logger.trace("This packet doesnt contain address");
        }
        catch (RuntimeException runtimeException) {
            logger.debug("Exception processing packet: {}", (Throwable)runtimeException);
        }
        return false;
    }

    public InetAddress getHostAddress() {
        return this.theHost;
    }

    @Override
    public int getHostPort() {
        return this.theHttpPort;
    }

    public String getHttpProtocol() {
        return this.protocol;
    }

    public Map<String, String> getTheKnownNMCs() {
        return this.theKnownNMCs;
    }

    @Override
    public void setControlData(String string, Object object) throws TransportCommException, SecurityException {
    }

    @Override
    public void setDataSet(Hashtable<String, String> hashtable) throws TransportCommException {
    }

    public void setHostAddress(InetAddress inetAddress) {
        this.theHost = inetAddress;
    }

    @Override
    public void setHostPort(Integer n) {
        this.theHttpPort = n;
    }

    public void setHttpProtocol(String string) {
        this.protocol = string;
    }

    protected String getHttpConfigPage() {
        return new String(this.theRawHttpConfigBuffer);
    }

    protected String getHttpControlPage() {
        return new String(this.theRawHttpControlBuffer);
    }

    protected String getHttpStatusPage() {
        return new String(this.theRawHttpStatusBuffer);
    }
}

