/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataSourceAdapter;
import com.apcc.m11.components.stdpowersource.HttpFormPoster;
import com.apcc.m11.components.stdpowersource.PCNSCommsDisabledException;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.SecureHttpTransportAdapter;
import com.apcc.m11.components.stdpowersource.TransportCommException;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.util.virtualization.vxrail.VxRailUtils;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.util.MD5;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.nmc.request.NmcDetails;
import com.apcc.pcns.util.CountdownTimer;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NMCComms {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String MESSAGE_POSTFIX = ",FFFF";
    private static final Logger logger = LogManager.getLogger(NMCComms.class);
    public static final String UTF8 = "UTF-8";
    private PowerSourceComponent powersource;
    private int registrationResult;
    private InetAddress localhost;
    private InetAddress nmcHost;
    private int nmcPort;
    private String nmcProtocol;
    private Integer outlet;
    private String username;
    private String authPhrase;
    private String challenge;
    private VirtualConfigurationManager config;
    private String multicastAddress;
    private String unicastAddress;
    private ServiceManager services;

    public NMCComms(PowerSourceComponent powerSourceComponent, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        if (powerSourceComponent == null) {
            throw new IllegalArgumentException("PowerSource can't be null");
        }
        this.services = serviceManager;
        this.config = serviceManager.getVirtualConfigurationManager();
        this.powersource = powerSourceComponent;
    }

    public void enrolWithNMC() {
        this.logStart();
        this.prepareVariables();
        try {
            boolean bl = this.config.isIPv6();
            boolean bl2 = this.config.isIPv6Unicast();
            boolean bl3 = this.config.isIPv6Multicast();
            this.challenge = this.getChallenge();
            if (bl && bl3) {
                String string = this.multicastAddress + MESSAGE_POSTFIX;
                this.sendRequestforIPv6Multicast("macontrol1_config_client_1=", string);
            } else if (bl && bl2) {
                String string = this.unicastAddress + MESSAGE_POSTFIX;
                this.sendRequestforIPv6Unicast("macontrol1_config_client_1=", string);
            } else {
                String string = this.localhost.getHostAddress() + MESSAGE_POSTFIX;
                this.sendRequest("macontrol1_config_client_1=", string);
            }
            this.processResponses();
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
    }

    public void checkNmcShutdownSupport() {
        boolean bl = false;
        if (this.services.getVirtualConfigurationManager().isVxRail() && this.registrationResult == 1) {
            VxRailUtils vxRailUtils = this.services.getVxRailUtils();
            NmcDetails nmcDetails = new NmcDetails();
            nmcDetails.setNmcIp(this.nmcHost.getHostAddress());
            nmcDetails.setPort(this.nmcPort);
            nmcDetails.setUsername(this.username);
            nmcDetails.setPassword(this.authPhrase);
            nmcDetails.setAcceptUntrustedCerts(bl);
            nmcDetails.setConnectionTimeout(vxRailUtils.getNMCConnectionTimeout());
            bl = vxRailUtils.checkNmcShutdownSupport(nmcDetails);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("VxRail");
            if (!bl) {
                this.registrationResult = 10;
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingDoneHCIShutdownSupportNotPresent", arrayList);
            } else {
                this.powersource.logCommunicationStatusEntry("RegStatus.ConnectingDoneHCIShutdownSupportPresent", arrayList);
            }
        }
    }

    public void registerWithOutletGroup(Integer n) {
        this.logStart();
        this.prepareVariables();
        this.outlet = n;
        try {
            boolean bl = this.config.isIPv6();
            boolean bl2 = this.config.isIPv6Unicast();
            boolean bl3 = this.config.isIPv6Multicast();
            this.challenge = this.getChallenge();
            if (bl && bl3) {
                String string = this.multicastAddress + "," + n;
                this.sendRequestforIPv6Multicast("macontrol1_client_registersog=", string);
            } else if (bl && bl2) {
                String string = this.unicastAddress + "," + n;
                this.sendRequestforIPv6Unicast("macontrol1_client_registersog=", string);
            } else {
                String string = this.localhost.getHostAddress() + "," + n;
                logger.debug("registerWithOutletGroup() - Challenge: {} ", (Object)this.challenge);
                this.sendRequest("macontrol1_client_registersog=", string);
            }
            this.processResponses();
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        Integer n2 = this.powersource.getOutletState(n);
        if (n2 == null || 0 == n2) {
            this.registrationResult = 8;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.powersource.isAdvancedMode()) {
                arrayList.add(StringEscapeUtils.escapeHtml4((String)this.powersource.getAdvancedUpsSetupName()));
                arrayList.add(this.powersource.getOutletName(n));
                if (this.nmcHost != null) {
                    arrayList.add(this.nmcHost.getHostAddress());
                } else {
                    arrayList.add(UNKNOWN);
                }
                this.powersource.logCommunicationStatusError("RegStatus.InvalidOutletAdv", arrayList);
            } else {
                arrayList.add(this.powersource.getOutletName(n));
                if (this.nmcHost != null) {
                    arrayList.add(this.nmcHost.getHostAddress());
                } else {
                    arrayList.add(UNKNOWN);
                }
                this.powersource.logCommunicationStatusError("RegStatus.InvalidOutlet", arrayList);
            }
            this.powersource.getNMCAddress();
            if (this.powersource.getOutletMap().isEmpty()) {
                this.powersource.setOutletGroup(null);
            }
        } else if (n2 != null && n2.equals(3)) {
            this.registrationResult = 9;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.powersource.setOutletGroup(n);
            if (this.powersource.isAdvancedMode()) {
                arrayList.add(StringEscapeUtils.escapeHtml4((String)this.powersource.getAdvancedUpsSetupName()));
                arrayList.add(this.powersource.getOutletName(n));
                if (this.nmcHost != null) {
                    arrayList.add(this.nmcHost.getHostAddress());
                } else {
                    arrayList.add(UNKNOWN);
                }
                this.powersource.logCommunicationStatusError("RegStatus.OutletTurningOffAdv", arrayList);
            } else {
                arrayList.add(this.powersource.getOutletName(n));
                if (this.nmcHost != null) {
                    arrayList.add(this.nmcHost.getHostAddress());
                } else {
                    arrayList.add(UNKNOWN);
                }
                this.powersource.logCommunicationStatusError("RegStatus.OutletTurningOff", arrayList);
            }
        }
        if (this.registrationResult == 1) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.nmcHost != null) {
                arrayList.add(this.nmcHost.getHostAddress());
            } else {
                arrayList.add(UNKNOWN);
            }
            arrayList.add(Integer.toString(this.nmcPort));
            arrayList.add(this.nmcProtocol);
            arrayList.add(this.powersource.getOutletName(n));
            this.powersource.setOutletGroup(n);
            this.powersource.logCommunicationStatusEntry("RegStatus.ListenSOGDone", arrayList);
        }
    }

    public void unregisterWithOutletGroup() {
        this.logStart();
        this.prepareVariables();
        try {
            boolean bl = this.config.isIPv6();
            boolean bl2 = this.config.isIPv6Unicast();
            boolean bl3 = this.config.isIPv6Multicast();
            this.challenge = this.getChallenge();
            if (bl && bl3) {
                String string = this.multicastAddress + "," + this.outlet;
                this.sendRequestforIPv6Multicast("macontrol1_client_unregistersog=", string);
            } else if (bl && bl2) {
                String string = this.unicastAddress + "," + this.outlet;
                this.sendRequestforIPv6Unicast("macontrol1_client_unregistersog=", string);
            } else {
                String string = this.localhost.getHostAddress() + "," + this.outlet;
                this.sendRequest("macontrol1_client_unregistersog=", string);
            }
            this.processResponses();
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
    }

    public int getRegistrationResult() {
        return this.registrationResult;
    }

    private void processResponses() {
        if (this.registrationResult == 0) {
            this.listenForResponses();
        }
    }

    private void sendRequest(String string, String string2) {
        if (this.registrationResult == 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.nmcHost.getHostAddress());
            arrayList.add(Integer.toString(this.nmcPort));
            arrayList.add(this.nmcProtocol);
            arrayList.add(this.localhost.getHostAddress());
            this.powersource.logCommunicationStatusEntry("RegStatus.Registering", arrayList);
            if (!this.sendRequestToAdapter(string, string2)) {
                this.registrationResult = 5;
                this.powersource.logCommunicationStatusError("RegStatus.RegisteringFail", arrayList);
            }
        }
    }

    private void sendRequestforIPv6Unicast(String string, String string2) {
        if (this.registrationResult == 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = this.nmcHost.getHostAddress();
            if (!((String)object).startsWith("[") && !((String)object).endsWith("]")) {
                object = "[" + (String)object + "]";
            }
            arrayList.add(object);
            arrayList.add(Integer.toString(this.nmcPort));
            arrayList.add(this.nmcProtocol);
            arrayList.add(this.unicastAddress);
            this.powersource.logCommunicationStatusEntry("RegStatus.Registering", arrayList);
            if (!this.sendRequestToAdapter(string, string2)) {
                this.registrationResult = 5;
                this.powersource.logCommunicationStatusError("RegStatus.RegisteringFail", arrayList);
            }
        }
    }

    private void sendRequestforIPv6Multicast(String string, String string2) {
        if (this.registrationResult == 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = this.nmcHost.getHostAddress();
            if (!((String)object).startsWith("[") && !((String)object).endsWith("]")) {
                object = "[" + (String)object + "]";
            }
            arrayList.add(object);
            arrayList.add(Integer.toString(this.nmcPort));
            arrayList.add(this.nmcProtocol);
            arrayList.add(this.multicastAddress);
            this.powersource.logCommunicationStatusEntry("RegStatus.Registering", arrayList);
            if (!this.sendRequestToAdapter(string, string2)) {
                this.registrationResult = 5;
                this.powersource.logCommunicationStatusError("RegStatus.RegisteringFail", arrayList);
            }
            arrayList = null;
        }
    }

    private void logStart() {
        this.registrationResult = 0;
    }

    private void prepareVariables() {
        this.unicastAddress = this.powersource.getUnicastAddress();
        this.multicastAddress = this.powersource.getMulticastAddress();
        this.localhost = this.powersource.getLocalhostAddress();
        this.nmcHost = this.powersource.getNMCAddress();
        this.nmcPort = this.powersource.getNMCPort();
        this.nmcProtocol = this.powersource.getNMCProtocol();
        this.outlet = this.powersource.getOutletGroup();
        this.username = this.powersource.getUsername();
        this.authPhrase = this.powersource.getAuthenticationPhrase();
    }

    private String getChallenge() {
        logger.debug("stdpowersource - getChallenge()");
        String string = null;
        if (this.nmcHost == null) {
            return string;
        }
        List<Object> list = this.logConnectionAttempt();
        try {
            SecureHttpTransportAdapter secureHttpTransportAdapter = new SecureHttpTransportAdapter(this.nmcProtocol, this.nmcHost, this.nmcPort, this.username, this.authPhrase, this.services.getApplicationErrorHandler(), this.services.getTrustStoreManager(), this.services.getUnverifiedCertificateManager());
            if (secureHttpTransportAdapter.addedCertToKeystore().booleanValue()) {
                this.powersource.logCommunicationStatusEntry("RegStatus.AddedCert", list);
            }
            boolean bl = true;
            while (string == null) {
                Hashtable<String, String> hashtable = secureHttpTransportAdapter.getControlSet();
                String string2 = hashtable.get("CI");
                logger.trace("{} = {}", (Object)"CI", (Object)string2);
                bl = "1".equals(hashtable.get("CI"));
                if (bl) {
                    logger.error("Challenge is in use.  Backing off...");
                    new CountdownTimer(500L, TimeUnit.MILLISECONDS).sleep();
                    continue;
                }
                string = hashtable.get("CS");
                hashtable.clear();
                logger.trace("Got challenge string of: {}", (Object)string);
            }
            this.powersource.logCommunicationStatusEntry("RegStatus.ConnectingDone", list);
        }
        catch (TransportCommException transportCommException) {
            logger.error((Object)transportCommException);
            if (transportCommException.getCause() instanceof PCNSCommsDisabledException) {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailedDisabled", list);
            }
            this.registrationResult = 2;
            if (this.powersource.isAdvancedMode()) {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailedAdv", list);
            } else {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailed", list);
            }
        }
        catch (SecurityException securityException) {
            logger.error((Object)securityException);
            this.registrationResult = 6;
            if (this.powersource.isAdvancedMode()) {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailedSecurityAdv", list);
            } else {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailedSecurity", list);
            }
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            logger.error("SSLHandshakeException:", (Throwable)sSLHandshakeException);
            logger.error("Caused by: ", sSLHandshakeException.getCause());
            Throwable throwable = sSLHandshakeException.getCause();
            if (throwable instanceof CertificateException) {
                list.add(ApcHelp.getOnClick(ApcHelp.NETWORK_MANAGEMENT_CARD_CONNECTION));
                this.registrationResult = 3;
                if (this.powersource.isAdvancedMode()) {
                    this.powersource.logCommunicationStatusError("RegStatus.ErrorCertAdv", list);
                } else {
                    this.powersource.logCommunicationStatusError("RegStatus.ErrorCert", list);
                }
            } else {
                this.registrationResult = 4;
                if (this.powersource.isAdvancedMode()) {
                    this.powersource.logCommunicationStatusError("RegStatus.ErrorSslAdv", list);
                } else {
                    this.powersource.logCommunicationStatusError("RegStatus.ErrorSsl", list);
                }
            }
        }
        catch (SSLException sSLException) {
            logger.error("CERTIFICATE ERROR SSLException:", (Throwable)sSLException);
            this.registrationResult = 3;
            list.add(ApcHelp.getOnClick(ApcHelp.NETWORK_MANAGEMENT_CARD_TROUBLESHOOTING));
            if (this.powersource.isAdvancedMode()) {
                this.powersource.logCommunicationStatusError("RegStatus.ErrorCertAdv", list);
            } else {
                this.powersource.logCommunicationStatusError("RegStatus.ErrorCert", list);
            }
        }
        catch (Exception exception) {
            logger.error("Unknown Exception:", (Throwable)exception);
            this.registrationResult = 2;
            if (this.powersource.isAdvancedMode()) {
                this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailedAdv", list);
            }
            this.powersource.logCommunicationStatusError("RegStatus.ConnectingFailed", list);
        }
        return string;
    }

    private List<Object> logConnectionAttempt() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.nmcHost instanceof Inet6Address) {
            arrayList.add("[" + this.nmcHost.getHostAddress() + "]");
        } else {
            arrayList.add(this.nmcHost.getHostAddress());
        }
        arrayList.add(Integer.toString(this.nmcPort));
        arrayList.add(this.nmcProtocol);
        if (this.powersource.isAdvancedMode()) {
            arrayList.add(StringEscapeUtils.escapeHtml4((String)this.powersource.getAdvancedUpsSetupName()));
        }
        this.powersource.logCommunicationStatusEntry("RegStatus.Connecting", arrayList);
        return arrayList;
    }

    private boolean sendRequestToAdapter(String string, String string2) {
        try {
            URL uRL = new URL(this.nmcProtocol, this.nmcHost.getHostAddress(), this.nmcPort, "/Forms/macontrol1");
            String string3 = string + string2 + ",";
            MD5 mD5 = new MD5();
            mD5.Init();
            String string4 = string2 + ",";
            mD5.Update(string3 + this.challenge + this.username + this.authPhrase);
            string3 = string + URLEncoder.encode(string4, UTF8);
            string3 = string3 + mD5.asHex();
            SetResult setResult = new SetResult();
            HttpFormPoster httpFormPoster = new HttpFormPoster(uRL, string3, setResult, this.services.getApplicationErrorHandler(), this.services.getTrustStoreManager(), this.services.getUnverifiedCertificateManager());
            httpFormPoster.start();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.nmcProtocol);
            arrayList.add("/Forms/macontrol1");
            this.powersource.logCommunicationStatusError("RegStatus.RegisteringFailUrl", arrayList);
            return false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.powersource.logCommunicationStatusError("RegStatus.RegisteringFailEncoding");
            return false;
        }
    }

    private void listenForResponses() {
        if (!this.powersource.isListening()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("UDP");
            try {
                arrayList.add(Integer.toString(this.powersource.getEventPort()));
            }
            catch (CommunicationException communicationException) {
                arrayList.add("MISSING");
            }
            this.registrationResult = 7;
            this.powersource.logCommunicationStatusEntry("RegStatus.PowerChuteError", arrayList);
        } else {
            this.powersource.logCommunicationStatusEntry("RegStatus.Listen");
            try {
                DataSourceAdapter dataSourceAdapter = (DataSourceAdapter)this.powersource.getInterface(DataSource.kOid);
                int n = 0;
                boolean bl = false;
                do {
                    int n2 = 2;
                    ++n;
                    new CountdownTimer(1L).sleep();
                    try {
                        Object object;
                        GetResult getResult = dataSourceAdapter.get(Communication.CommunicationStatus.getObjectId());
                        if (getResult == null || !((object = getResult.getValue()) instanceof Integer) || (n2 = ((Integer)object).intValue()) != 1) continue;
                        bl = true;
                    }
                    catch (CommunicationException communicationException) {
                        logger.debug("listenForResponses(): Response not received yet...");
                    }
                } while (!bl && n < 130);
                if (bl) {
                    this.powersource.logCommunicationStatusEntry("RegStatus.ListenDone");
                    this.registrationResult = 1;
                } else {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(ApcHelp.getOnClick(ApcHelp.NETWORK_MANAGEMENT_CARD_TROUBLESHOOTING));
                    if (this.powersource.isAdvancedMode()) {
                        arrayList.add(StringEscapeUtils.escapeHtml4((String)this.powersource.getAdvancedUpsSetupName()));
                        if (this.nmcHost instanceof Inet4Address) {
                            arrayList.add(this.nmcHost.getHostAddress());
                        } else if (this.nmcHost instanceof Inet6Address) {
                            arrayList.add("[" + this.nmcHost.getHostAddress() + "]");
                        }
                        this.powersource.logCommunicationStatusError("RegStatus.ListenFailAdv", arrayList);
                    } else {
                        this.powersource.logCommunicationStatusError("RegStatus.ListenFail", arrayList);
                    }
                    this.registrationResult = 7;
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error("NMCComms - listenForResponse() InvalidObjectError: {}", (Throwable)invalidObjectIdException);
            }
        }
    }
}

