/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletGroup
implements Comparable<OutletGroup>,
Serializable {
    private static final long serialVersionUID = -3526707421417779287L;
    private static final Logger logger = LogManager.getLogger(OutletGroup.class);
    private Integer groupNumber;
    private Integer state;
    private String name;
    private String ipAddress;
    private boolean selected;

    public OutletGroup(Integer n, Integer n2, String string, String string2, boolean bl) throws IllegalArgumentException {
        logger.debug("OutletGroup(" + n + ", " + n2 + ", " + string + ", " + string2 + ", " + bl + ")");
        this.setGroupNumber(n);
        this.setState(n2);
        this.setName(string);
        this.setIpAddress(string2);
        this.setSelected(bl);
    }

    @Override
    public int compareTo(OutletGroup outletGroup) {
        int n = this.ipAddress.compareTo(outletGroup.ipAddress);
        if (n == 0) {
            n = this.groupNumber.compareTo(outletGroup.groupNumber);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OutletGroup)) {
            return false;
        }
        OutletGroup outletGroup = (OutletGroup)object;
        if (this.groupNumber == null) {
            return false;
        }
        return this.ipAddress.equals(outletGroup.ipAddress) && this.groupNumber.equals(outletGroup.groupNumber);
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Integer getState() {
        return this.state;
    }

    public int hashCode() {
        if (this.groupNumber == null) {
            return this.ipAddress.hashCode();
        }
        return this.groupNumber.hashCode() + this.ipAddress.hashCode();
    }

    private void setGroupNumber(Integer n) throws IllegalArgumentException {
        if (n == null) {
            this.groupNumber = null;
        } else if (n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Group Number must be zero or larger.");
            logger.error((Object)illegalArgumentException);
            throw illegalArgumentException;
        }
        this.groupNumber = n;
    }

    private void setIpAddress(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("IP Address must be specified.");
            logger.error((Object)illegalArgumentException);
            throw illegalArgumentException;
        }
        this.ipAddress = string;
    }

    private void setName(String string) {
        this.name = string == null ? "" : string;
    }

    private void setSelected(boolean bl) {
        this.selected = bl;
    }

    private void setState(Integer n) throws IllegalArgumentException {
        if (n != null) {
            switch (n) {
                case 1: {
                    this.state = 1;
                    break;
                }
                case 0: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 2;
                    break;
                }
                case 3: {
                    this.state = 3;
                    break;
                }
                case 4: {
                    this.state = 4;
                    break;
                }
                default: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid outlet state specified.");
                    logger.error((Object)illegalArgumentException);
                    throw illegalArgumentException;
                }
            }
        }
    }
}

