/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.omaha.LogUtils;
import com.apcc.m11.components.stdpowersource.AllComponentsStartedEventHandler;
import com.apcc.m11.components.stdpowersource.BroadcastReceiver;
import com.apcc.m11.components.stdpowersource.CommunicationsStatusLogEntry;
import com.apcc.m11.components.stdpowersource.DataConsumerAdapter;
import com.apcc.m11.components.stdpowersource.DataSourceAdapter;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.ExternalEventHandler;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.HttpTransportAdapter;
import com.apcc.m11.components.stdpowersource.IEventHandler;
import com.apcc.m11.components.stdpowersource.IKeepAliveClient;
import com.apcc.m11.components.stdpowersource.IPv6PacketReceiver;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.KeepAliveTimer;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.stdpowersource.ReloadConfigurationTask;
import com.apcc.m11.components.stdpowersource.SecureHttpTransportAdapter;
import com.apcc.m11.components.stdpowersource.ShutdownOnBatteryEventHandler;
import com.apcc.m11.components.stdpowersource.TurnOffUpsStartingEventHandler;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import com.apcc.m11.components.stdpowersource.tasks.NMCRegisterTask;
import com.apcc.m11.components.stdpowersource.tasks.OutletRegisterTask;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.powersource.Bypass;
import com.apcc.m11.ds.powersource.OIdEventMapping;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.InvalidIniEntryException;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.InetAddressValidator;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import com.apcc.pcns.configservice.validation.ValidationUtil;
import com.apcc.pcns.datagramservice.DatagramManager;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.HostNameLookUpTable;
import com.apcc.pcns.util.IPUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceComponent
implements IComponent,
IM11Component,
IKeepAliveClient {
    public static final int MAX_OUTLET_GROUPS = 10;
    private static final Logger logger = LogManager.getLogger(PowerSourceComponent.class);
    private static final String kComponentName = "Standard Power Source";
    private static final ComponentID kComponentId = new ComponentID("StdPowerSource");
    public static final ComponentID kSharedComponentId = new ComponentID("StdPowerSourceShared");
    private static final String kComponentVersion = "1.0.0";
    public static final String kDebugGroupId = "StdPowerSource";
    public static final String kResourceBundleBasename = "com.apcc.m11.components.stdpowersource.i18n.StdPowerSource";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String kAdapterConfigPageUrl = "/maservices.getConfigurationManager()htm";
    public static final String kEventPort = "PT";
    private static final String kPSEventPortStorageId = "EventReceiverPort";
    private static final String kPollIntervalStorageId = "PollInterval";
    public static final String kAuthUsername = "UPSTurnOffPoint";
    public static final String kESXiHostAuthUsername = "ESXiHostTurnOffPoint";
    public static final String kvCenterAuthUsername = "vCenterTurnOffPoint";
    public static final String kAuthPassword = "PowerSourceUPSSerialNumber";
    public static final String kESXiHostAuthPassword = "ESXiHostSerialNumber";
    public static final String kvCenterAuthPassword = "vCenterSerialNumber";
    public static final String kPasswordPhrase = "PowerSourceUPSId";
    public static final String kNutanixAuthUsername = "NutanixTurnOffPoint";
    public static final String kNutanixAuthClusterPassword = "NutanixClusterSerialNumber";
    public static final String kNutanixAuthHostPassword = "NutanixHostSerialNumber";
    public static final String kNutanixAuthSshKeyPassphrase = "NutanixKeySerialNumber";
    public static final String SIMPLIVITY_PASSWORD = "SimplivityClusterPassword";
    public static final String HYPERFLEX_PASSWORD = "HyperflexAuthPassword";
    private static final int kDefaultEventPort = 3052;
    public static final String kRandomNumberId2 = "Validation";
    public static final String kPowerChuteKeystorePassword = "PowerChuteKeystorePassword";
    public static final String kPowerChuteKeystorePasswordenc = "PowerChuteKeystorePasswordenc";
    public static final String kKeystorePassword = "KeystorePassword";
    public static final String kKeystorePasswordenc = "KeystorePasswordenc";
    private static final Integer kDefaultPollInterval = 240;
    private static final int kMinimumPollInterval = 120;
    public static final String LICENSING_IDENTITY_CLIENT = "LicensingIdentityClient";
    public static final String LICENSING_ACTIVATION_ID = "LicensingActivationId";
    public static final String LICENSING_PROXY_USERNAME = "LicensingProxyUsername";
    public static final String LICENSING_PROXY_PASSWORD = "LicensingProxyPassword";
    public static final String SOFTWARE_UPDATE_STATUS = "SoftwareUpdateStatus";
    public static final String SOFTWARE_UPDATE_RESPONSE = "SoftwareUpdateResponse";
    @NonNull
    public static final String LICENSING_DEVICE_ID = "LicensingDeviceId";
    public static final String BLANK = "";
    private M11ComponentSynchronizer theSynchronizer;
    private IPermanentStorage thePermanentStorage;
    private HttpTransportAdapter theTransportAdapter;
    private DataStore theDataStore;
    private DataSourceAdapter theDataSource;
    private FlexEventGenerator theFlexEventGenerator;
    private BroadcastReceiver theBroadcastReceiver;
    private IPv6PacketReceiver theIPv6PacketReceiver;
    private KeepAliveTimer theKeepAliveTimer;
    private int theEventPort = -1;
    private DataConsumerAdapter theDataConsumer;
    private ExternalEventHandler theExternalEventHandler;
    private Vector<CommunicationsStatusLogEntry> theStatusLog;
    private static int theStatusLogEntryId = 1;
    private Future<?> theNMCRegisterFuture;
    private boolean theNMCRegisterPending = false;
    private NMCRegisterTask theNMCRegisterTask;
    private ServiceManager services;
    private ConfigurationManager config;
    private boolean turnOffUPS;
    private boolean turnOffSOG;
    private InetAddress localhost;
    private Integer outletGroup;
    private boolean enrolWithNMC = true;
    private String MulticastAddress;
    private String UnicastAddress;
    private Set<InetAddress> localIPSet = null;
    private Set<InetAddress> localIPv6Set = null;
    private InetAddress localIP = null;
    private List<String> propertyNames;
    ValidationUtil val = null;
    private EventListener<ConfigurationEvent> configEventListener;
    ResourceBundleWrapper bundle = null;
    private int thePSIndex;
    public static int defautltPSIndexVal = -99;
    private Boolean advancedMode = false;
    private int advanced_ups_setup_idx = 0;
    private String advanced_ups_setup_name = null;
    private boolean bLoopbackAddress = false;
    private boolean appConfigured = false;
    private CountdownTimer restartTimer;
    private DatagramManager datagramManager;
    int loads = 0;

    public PowerSourceComponent() {
        logger.debug("PowerSourceComponent() - start");
        this.services = ServiceManager.getInstance();
        this.datagramManager = this.services.getDatagramManager();
        this.config = this.services.getConfigurationManager();
        this.theSynchronizer = null;
        this.thePermanentStorage = null;
        this.theTransportAdapter = null;
        this.theDataStore = null;
        this.theDataSource = null;
        this.theFlexEventGenerator = null;
        this.theKeepAliveTimer = null;
        this.theDataConsumer = null;
        this.theExternalEventHandler = null;
        this.turnOffUPS = true;
        this.turnOffSOG = true;
        this.thePSIndex = defautltPSIndexVal;
        this.appConfigured = this.isAppConfigured();
        this.localhost = null;
        this.setPropertyNames();
        this.advancedMode = this.checkAdvancedMode();
        logger.trace("PowerSourceComponent() - localhost: " + String.valueOf(this.localhost));
        logger.debug("PowerSourceComponent() - end");
    }

    public Map<String, String> getKnownNMCs() {
        return this.theTransportAdapter.getTheKnownNMCs();
    }

    private boolean isAppConfigured() {
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        try {
            String string = this.services.getConfigurationManager().getString("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(0), inetAddressValidator);
            return StringUtils.isNotBlank((CharSequence)string);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            return false;
        }
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent Storage can't be null.");
        }
        logger.debug("Starting a PowerSource");
        logger.trace("StdPowerSource.init() called.");
        this.services.getAuthHelper().setPermanentStorage(iPermanentStorage);
        try {
            if (!this.appConfigured) {
                logger.error("No NMC Specified yet.  Configuration Required");
            }
            this.theStatusLog = new Vector();
            this.thePermanentStorage = iPermanentStorage;
            this.val = new ValidationUtil();
            OIdEventMapping oIdEventMapping = new OIdEventMapping();
            oIdEventMapping.initMap();
            this.loadConfiguration();
            try {
                String string;
                this.theSynchronizer = new M11ComponentSynchronizer();
                InetAddress inetAddress = this.getNMCAddress();
                if (inetAddress == null) {
                    logger.warn("Powersource host address could not be read from storage");
                } else {
                    logger.info("NMC address is:" + inetAddress.getHostAddress());
                    this.clearCommunicationStatusLog();
                }
                Integer n = this.getNMCPort();
                if (n == null) {
                    logger.warn("Powersource port number could not be read from storage");
                    n = 80;
                }
                if ((string = this.getNMCProtocol()) == null) {
                    logger.warn("Powersource protocol could not be read from storage");
                    string = DEFAULT_PROTOCOL;
                }
                this.theTransportAdapter = new SecureHttpTransportAdapter(string, inetAddress, n, this, this.services.getApplicationErrorHandler(), this.services.getTrustStoreManager(), this.services.getUnverifiedCertificateManager());
                this.theDataStore = new DataStore(this.theTransportAdapter);
                this.theDataSource = new DataSourceAdapter(this, this.theDataStore, this.theSynchronizer, this.services);
                this.setOutletGroup(this.getOutletGroup());
                this.theDataConsumer = new DataConsumerAdapter();
                this.theFlexEventGenerator = new FlexEventGenerator(this, this.theDataSource, this.theSynchronizer, this.services);
                this.theKeepAliveTimer = new KeepAliveTimer(this, this.theSynchronizer);
                if (inetAddress instanceof Inet6Address) {
                    this.theIPv6PacketReceiver = new IPv6PacketReceiver(this.theDataStore, this.theFlexEventGenerator, this.theSynchronizer, this.theKeepAliveTimer, this, this.datagramManager);
                    logger.trace("StdPowerSource.init() IPV6PacketReceiver made");
                } else {
                    this.theBroadcastReceiver = new BroadcastReceiver(this.theDataStore, this.theFlexEventGenerator, this.theSynchronizer, this.theKeepAliveTimer, this, this.datagramManager);
                    logger.trace("StdPowerSource.init() BroadCastReceiver made");
                }
                this.theExternalEventHandler = new ExternalEventHandler();
                IEventHandler iEventHandler = new AllComponentsStartedEventHandler(this.theFlexEventGenerator, this.theDataConsumer);
                this.theExternalEventHandler.addEventHandler(iEventHandler);
                iEventHandler = new ShutdownOnBatteryEventHandler(this, this.theDataConsumer, this.theDataSource, this.services);
                this.theExternalEventHandler.addEventHandler(iEventHandler);
                iEventHandler = new TurnOffUpsStartingEventHandler(this, this.theDataConsumer, this.theDataSource, this.services);
                this.theExternalEventHandler.addEventHandler(iEventHandler);
            }
            catch (Exception exception) {
                logger.error("StdPowerSource.init() FAILED", (Throwable)exception);
                throw new ComponentFailureException(0);
            }
        }
        catch (Exception exception) {
            logger.error("StdPowerSource.init() FAILED.", (Throwable)exception);
        }
        logger.debug("StdPowerSource.init() completed.");
    }

    public void startWithoutEnrol() throws ComponentFailureException {
        try {
            this.theSynchronizer.setState(2);
            this.getLocalIP();
            this.theKeepAliveTimer.start();
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
            throw new ComponentFailureException();
        }
    }

    public void start() throws ComponentFailureException {
        this.start(this.enrolWithNMC);
    }

    public void start(boolean bl) throws ComponentFailureException {
        logger.debug("StdPowerSource.start() called.");
        if (this.theSynchronizer.getState() == 2) {
            logger.trace("StdPowerSource.start() already started");
            return;
        }
        if (this.configEventListener == null) {
            this.configEventListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        logger.debug("update: {} {}", (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName());
                        String string = configurationEvent.getPropertyName();
                        if (StringUtils.isNotBlank((CharSequence)string) && !configurationEvent.isBeforeUpdate() && (PowerSourceComponent.this.propertyNames.contains(configurationEvent.getPropertyName()) || PowerSourceComponent.this.advancedMode.booleanValue() && StringUtils.startsWith((CharSequence)string, (CharSequence)ConfigurationKeys.getAdvancedSetupKey(PowerSourceComponent.this.advanced_ups_setup_idx)))) {
                            PowerSourceComponent.this.rateLimitedReload();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        this.services.getConfigurationManager().addEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.startWithoutEnrol();
        if (bl && this.getNMCAddress() != null) {
            this.enrollWithNMC();
        }
        logger.debug("StdPowerSource.start() complete.");
    }

    private void rateLimitedReload() {
        if (this.restartTimer == null || this.restartTimer.hasElapsed()) {
            this.restartTimer = new CountdownTimer(1L, TimeUnit.SECONDS);
            this.services.getThreadService().execute(new ReloadConfigurationTask(this.restartTimer, this));
        } else {
            this.restartTimer.reset();
        }
    }

    public void enrollWithNMC() {
        this.communicationRegister();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.debug("Wait for register to finish");
                while (PowerSourceComponent.this.getCommunicationStatusLogStatus(false) == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.debug("Registered");
                if (PowerSourceComponent.this.getCommunicationStatusLogStatus(false) == 1) {
                    if (PowerSourceComponent.this.getOutletGroup() != null) {
                        logger.debug("Register Outlet group");
                        try {
                            OutletGroup outletGroup = new OutletGroup(PowerSourceComponent.this.getOutletGroup(), null, null, PowerSourceComponent.this.getNMCAddressStr(), false);
                            PowerSourceComponent.this.theDataSource.set(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup);
                        }
                        catch (InvalidValueException invalidValueException) {
                            logger.debug("error enroling", (Throwable)invalidValueException);
                        }
                        catch (InvalidObjectIdException invalidObjectIdException) {
                            logger.debug("error enroling", (Throwable)invalidObjectIdException);
                        }
                        catch (CommunicationException communicationException) {
                            logger.debug("error enroling", (Throwable)communicationException);
                        }
                    } else {
                        logger.debug("Register Default Outlet group");
                        try {
                            List list;
                            Object object = PowerSourceComponent.this.theDataSource.get(TCPIPCommunication.OutletGroupList.getObjectId()).getValue();
                            if (object instanceof Vector && !(list = (List)object).isEmpty()) {
                                OutletGroup outletGroup = (OutletGroup)list.get(0);
                                for (OutletGroup outletGroup2 : list) {
                                    if (!outletGroup2.getIpAddress().equals(PowerSourceComponent.this.getNMCAddressStr()) || outletGroup.getGroupNumber() <= outletGroup2.getGroupNumber()) continue;
                                    outletGroup = outletGroup2;
                                }
                                ArrayList arrayList = new ArrayList();
                                arrayList.add(Integer.toString(outletGroup.getGroupNumber()));
                                arrayList.add(outletGroup.getName());
                                PowerSourceComponent.this.logCommunicationStatusError("RegStatus.DefaultOutlet", arrayList);
                                try {
                                    PowerSourceComponent.this.theDataSource.set(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup);
                                }
                                catch (InvalidValueException invalidValueException) {
                                    logger.debug("error Setting Outlet", (Throwable)invalidValueException);
                                }
                                catch (InvalidObjectIdException invalidObjectIdException) {
                                    logger.debug("error Setting Outlet", (Throwable)invalidObjectIdException);
                                }
                                catch (CommunicationException communicationException) {
                                    logger.debug("error Setting Outlet", (Throwable)communicationException);
                                }
                            }
                        }
                        catch (InvalidObjectIdException invalidObjectIdException) {
                            logger.debug("error Setting Outlet", (Throwable)invalidObjectIdException);
                        }
                        catch (CommunicationException communicationException) {
                            logger.debug("error Setting Outlet", (Throwable)communicationException);
                        }
                    }
                }
            }
        }, 0L);
    }

    public void start(ITemporaryStorage iTemporaryStorage) throws ComponentFailureException {
        this.theSynchronizer.setState(2);
    }

    public void stop() {
        logger.trace("StdPowerSource.stop() called.");
        this.theSynchronizer.setState(1);
        if (this.theKeepAliveTimer != null) {
            this.theKeepAliveTimer.interrupt();
        }
        this.services.getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.datagramManager.removeDatagramListener(this.theBroadcastReceiver);
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
        logger.trace("StdPowerSource.stop() called.");
        this.stop();
    }

    public void suspend() {
        logger.trace("StdPowerSource.suspend() called.");
        this.theSynchronizer.setState(3);
    }

    public void resume() {
        logger.trace("StdPowerSource.resume() called.");
        if (this.theSynchronizer.getState() == 3) {
            this.theSynchronizer.setState(2);
        }
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        logger.trace("StdPowerSource.getInterface(" + String.valueOf(objectId) + ")");
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this.theDataSource;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this.theDataConsumer;
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            object = this.theFlexEventGenerator;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this.theExternalEventHandler;
        } else {
            throw new InvalidObjectIdException("Unsupported interface.");
        }
        return object;
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        PowerSourceComponent powerSourceComponent = null;
        logger.trace("StdPowerSource.getInstance(" + String.valueOf(objectId) + ")");
        if (!objectId.equals((Object)M11Component.kOid)) {
            throw new InvalidObjectIdException("Unsupported interface.");
        }
        powerSourceComponent = this;
        return powerSourceComponent;
    }

    public String getComponentName() {
        return kComponentName;
    }

    public ComponentID getComponentID() {
        return kComponentId;
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    public synchronized Vector<CommunicationsStatusLogEntry> getCommunicationStatusLog() {
        return (Vector)this.theStatusLog.clone();
    }

    public synchronized void clearCommunicationStatusLog() {
        this.theStatusLog.clear();
        this.theNMCRegisterFuture = null;
        this.theNMCRegisterPending = false;
    }

    public synchronized void logCommunicationStatusEntry(String string, InetAddress inetAddress) {
        this.theStatusLog.add(new CommunicationsStatusLogEntry(++theStatusLogEntryId, new Date(), inetAddress, string, null));
    }

    public synchronized void logCommunicationStatusEntry(String string) {
        this.theStatusLog.add(new CommunicationsStatusLogEntry(++theStatusLogEntryId, new Date(), this.getNMCAddress(), string, null));
    }

    public synchronized void logCommunicationStatusEntry(String string, List<Object> list) {
        this.theStatusLog.add(new CommunicationsStatusLogEntry(++theStatusLogEntryId, new Date(), this.getNMCAddress(), string, list));
    }

    public synchronized void logCommunicationStatusError(String string) {
        this.logCommunicationStatusError(string, null);
    }

    public synchronized void logCommunicationStatusError(String string, List<Object> list) {
        CommunicationsStatusLogEntry communicationsStatusLogEntry = new CommunicationsStatusLogEntry(++theStatusLogEntryId, new Date(), this.getNMCAddress(), string, list);
        this.theStatusLog.add(communicationsStatusLogEntry);
        this.bundle = Utils.getWebServerResourceBundle(Locale.getDefault());
        this.services.getApplicationErrorHandler().put(communicationsStatusLogEntry.getLogMsg(this.bundle));
    }

    public void setRegisterPending() {
        this.theNMCRegisterPending = true;
    }

    public void communicationRegister() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HostNameLookUpTable.getInstance().lookUp(PowerSourceComponent.this.getNMCAddress());
            }
        }, 0L);
        if (!this.isNMCRegisterInProgress()) {
            this.theNMCRegisterTask = new NMCRegisterTask(this, this.services);
            this.theNMCRegisterFuture = ServiceManager.getInstance().getThreadService().submit(this.theNMCRegisterTask);
            this.theNMCRegisterPending = false;
        }
    }

    public void communicationRegisterWithSOG(Integer n) {
        if (!this.isNMCRegisterInProgress()) {
            this.theNMCRegisterTask = new OutletRegisterTask(this, n, this.services);
            this.theNMCRegisterFuture = ServiceManager.getInstance().getThreadService().submit(this.theNMCRegisterTask);
            this.theNMCRegisterPending = false;
        }
    }

    public boolean isNMCRegisterInProgress() {
        boolean bl = false;
        if (this.theNMCRegisterFuture != null) {
            bl = !this.theNMCRegisterFuture.isDone();
        }
        return bl;
    }

    public int getCommunicationStatusLogStatus(boolean bl) {
        int n = 1;
        if (bl && this.theNMCRegisterFuture != null && !this.theNMCRegisterFuture.isDone()) {
            for (int i = 0; !this.theNMCRegisterFuture.isDone() && i < 20; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.theNMCRegisterPending) {
            n = 0;
        } else if (this.theNMCRegisterFuture != null) {
            n = !this.theNMCRegisterFuture.isDone() ? 0 : this.theNMCRegisterTask.getRegistrationResult();
        } else if (this.theStatusLog != null && this.theStatusLog.size() > 0) {
            CommunicationsStatusLogEntry communicationsStatusLogEntry = this.theStatusLog.lastElement();
            if (communicationsStatusLogEntry != null && !communicationsStatusLogEntry.getEntry().equals("RegStatus.ListenDone")) {
                this.logCommunicationStatusEntry("RegStatus.ListenDone");
            }
        } else {
            logger.warn(String.valueOf(this.getNMCAddress()) + " Status Log is empty. Nothing going on so return Communication.OK");
        }
        return n;
    }

    public InetAddress getLocalhostAddress() {
        return this.localhost;
    }

    public String getMulticastAddress() {
        return this.MulticastAddress;
    }

    public String getUnicastAddress() {
        return this.UnicastAddress;
    }

    public void setLocalHostAddress(InetAddress inetAddress) {
        if (inetAddress != null) {
            String string = null;
            try {
                string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
            }
            catch (ConversionException conversionException) {
                string = null;
            }
            String string2 = inetAddress.getHostAddress();
            if (this.localhost == null || !string2.equalsIgnoreCase(this.localhost.getHostAddress()) || string == null || string.isEmpty()) {
                this.localhost = inetAddress;
                logger.debug("setLocalHostAddress: " + string2);
                this.services.getConfigurationManager().setProperty("Networking", "localHostAddress", string2);
            }
        }
    }

    public void setMulticastAddress(String string) {
        if (string != null) {
            this.MulticastAddress = string;
            this.services.getConfigurationManager().setProperty("Networking", "MulticastAddress", string.toString());
        }
    }

    public void setUnicastAddress(String string) {
        if (string != null) {
            this.UnicastAddress = string;
            this.services.getConfigurationManager().setProperty("Networking", "UnicastAddress", string.toString());
        }
    }

    public int getThePSIndex() {
        return this.thePSIndex;
    }

    public void setThePSIndex(int n) {
        if (this.thePSIndex != n) {
            this.thePSIndex = n;
            this.setNMCAddress(this.getNMCAddress());
            this.setOutletGroup(this.getOutletGroup());
        }
    }

    public InetAddress getNMCAddress() {
        logger.trace("getNMCAddress: started");
        InetAddress inetAddress = null;
        String string = null;
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        try {
            if (!this.advancedMode.booleanValue()) {
                string = this.services.getConfigurationManager().getString("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(this.thePSIndex), inetAddressValidator);
            } else {
                List<String> list = this.services.getAdvancedSetupHelper().getNMCListForUPSSetup(this.advanced_ups_setup_idx);
                if (list != null && list.size() > this.thePSIndex && list.get(this.thePSIndex) != null) {
                    string = list.get(this.thePSIndex);
                    if (!inetAddressValidator.isValid(string)) {
                        string = null;
                    }
                } else {
                    logger.error("Error: thePSIndex [" + Integer.toString(this.thePSIndex) + "]");
                    if (list != null) {
                        logger.error("Error: nmcList.size(): " + list.size());
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        if (string != null && !string.isEmpty()) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
        }
        logger.trace("getNMCAddress: completed");
        return inetAddress;
    }

    public String getNMCAddressStr() {
        String string = "UNKNOWN";
        InetAddress inetAddress = this.getNMCAddress();
        if (inetAddress != null) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    public Integer getOutletGroup() {
        Integer n = null;
        try {
            if (!this.advancedMode.booleanValue()) {
                if (this.services.getConfigurationManager().containsKey("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(this.thePSIndex))) {
                    n = this.services.getConfigurationManager().getInt("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(this.thePSIndex));
                }
            } else {
                Integer n2 = this.getNMCIndex();
                if (n2 != null && this.services.getConfigurationManager().containsKey("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2))) {
                    n = this.services.getConfigurationManager().getInt("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2));
                }
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        return n;
    }

    public Integer getOutletState(Integer n) {
        Integer n2 = null;
        try {
            String string = this.theDataStore.readValue(UPSLink.getOutletGroupStateKey(n));
            n2 = Integer.valueOf(string);
            Integer n3 = this.getTurnOffPendingSignal(n);
            if (n3 != null && n3.equals(1) && !n2.equals(0)) {
                n2 = 3;
            }
            logger.debug("PS=" + this.thePSIndex + " outlet=" + n + " pendingOff=" + n3 + " state=" + n2);
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            n2 = 4;
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.error((Object)invalidDataIdentifierException);
            n2 = 4;
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)numberFormatException);
            n2 = 4;
        }
        return n2;
    }

    public Integer getOutletState() {
        return this.getOutletState(this.outletGroup);
    }

    public String getOutletName(Integer n) {
        Object object = "Outlet " + n;
        try {
            object = this.theDataStore.readValue(UPSLink.getOutletGroupNameKey(n));
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return object;
    }

    public String getOutletName() {
        return this.getOutletName(this.outletGroup);
    }

    public void setOutletGroup(Integer n) throws IllegalArgumentException {
        if (n != null && n < 0) {
            n = null;
        }
        this.outletGroup = n;
        if (this.theDataSource != null) {
            this.theDataSource.setOutletGroup(n);
        }
        if (!this.advancedMode.booleanValue()) {
            if (n == null) {
                this.services.getConfigurationManager().clearProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(this.thePSIndex));
            } else {
                this.services.getConfigurationManager().setProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(this.thePSIndex), n);
            }
        } else {
            Integer n2 = this.getNMCIndex();
            if (n2 != null) {
                if (n == null) {
                    this.services.getConfigurationManager().clearProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2));
                } else {
                    this.services.getConfigurationManager().setProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2), n);
                }
            }
        }
    }

    public boolean setNMCAddress(InetAddress inetAddress) {
        logger.debug(">");
        boolean bl = true;
        if (inetAddress != null) {
            logger.debug(">" + inetAddress.toString());
            try {
                if (this.theDataStore != null) {
                    logger.debug("invalidate datastore");
                    this.theDataStore.invalidateDataSet();
                }
                if (!this.advancedMode.booleanValue()) {
                    this.services.getConfigurationManager().setProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(this.thePSIndex), inetAddress.getHostAddress());
                } else {
                    Integer n = this.getNMCIndex();
                    if (n != null) {
                        this.services.getConfigurationManager().setProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n), inetAddress.getHostAddress());
                    }
                }
                if (this.theStatusLog != null && this.theStatusLog.isEmpty()) {
                    this.logCommunicationStatusEntry("RegStatus.Init", inetAddress);
                }
                if (this.theTransportAdapter != null && !inetAddress.equals(this.theTransportAdapter.getHostAddress())) {
                    this.theTransportAdapter.setHostAddress(inetAddress);
                    this.theKeepAliveTimer.interrupt();
                }
            }
            catch (Exception exception) {
                logger.error("exception", (Throwable)exception);
                bl = false;
            }
        }
        logger.debug("<");
        return bl;
    }

    public Integer getNMCPort() {
        Integer n;
        IntRangeSetValidator intRangeSetValidator = null;
        if (this.getNMCProtocol().equalsIgnoreCase(DEFAULT_PROTOCOL)) {
            intRangeSetValidator = new IntRangeSetValidator(80);
            intRangeSetValidator.add(80);
        } else {
            intRangeSetValidator = new IntRangeSetValidator(443);
            intRangeSetValidator.add(443);
        }
        intRangeSetValidator.add(5000, 32678);
        try {
            n = this.services.getConfigurationManager().getInt("NetworkManagementCard", "port", intRangeSetValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            n = (Integer)intRangeSetValidator.getDefault();
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            n = (Integer)intRangeSetValidator.getDefault();
        }
        return n;
    }

    public String getNMCProtocol() {
        String string = null;
        StringSetValidator stringSetValidator = new StringSetValidator(DEFAULT_PROTOCOL);
        stringSetValidator.add(DEFAULT_PROTOCOL);
        stringSetValidator.add("https");
        try {
            string = this.services.getConfigurationManager().getString("NetworkManagementCard", "protocol", stringSetValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            string = DEFAULT_PROTOCOL;
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            string = DEFAULT_PROTOCOL;
        }
        return string;
    }

    public boolean setNMCPort(Integer n) {
        boolean bl = true;
        this.services.getConfigurationManager().setProperty("NetworkManagementCard", "port", n);
        if (this.theTransportAdapter != null) {
            this.theTransportAdapter.setHostPort(n);
        }
        return bl;
    }

    public boolean setNMCProtocol(String string) {
        boolean bl = false;
        if (DEFAULT_PROTOCOL.equalsIgnoreCase(string) || "https".equalsIgnoreCase(string)) {
            bl = true;
            this.services.getConfigurationManager().setProperty("NetworkManagementCard", "protocol", string);
            if (this.theTransportAdapter != null) {
                this.theTransportAdapter.setHttpProtocol(string);
            }
        }
        return bl;
    }

    public boolean isTurnOffPending() {
        boolean bl = false;
        try {
            GetResult getResult = this.theDataSource.get(OperatingStatus.PowerSourceTurnOffPending.getObjectId());
            bl = (Boolean)getResult.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isOnBatteryStatus() {
        boolean bl = false;
        try {
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Integer n = (Integer)getResult.getValue();
            if (n == 2) {
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return bl;
    }

    public boolean isInBypass() {
        return this.isInMaintenanceOrFaultBypass() || this.isInManualBypass();
    }

    public boolean isInMaintenanceOrFaultBypass() {
        boolean bl = false;
        try {
            GetResult getResult = this.theDataSource.get(Bypass.BypassState.getObjectId());
            Object object = getResult.getValue();
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (n == 3) {
                    bl = true;
                } else if (n == 4) {
                    bl = true;
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.debug((Object)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error((Object)invalidObjectIdException);
        }
        return bl;
    }

    public boolean isInManualBypass() {
        boolean bl = false;
        try {
            int n;
            GetResult getResult = this.theDataSource.get(Bypass.ManualBypassState.getObjectId());
            Object object = getResult.getValue();
            if (object instanceof Integer && (n = ((Integer)object).intValue()) == 5) {
                bl = true;
            }
        }
        catch (CommunicationException communicationException) {
            logger.debug((Object)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error((Object)invalidObjectIdException);
        }
        return bl;
    }

    public Integer getPollInterval() {
        Integer n = kDefaultPollInterval;
        try {
            Object object = this.thePermanentStorage.readData(this.getComponentID(), kPollIntervalStorageId);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error((Object)storageEntryException);
            n = null;
        }
        return n;
    }

    public boolean setPollInterval(Integer n) {
        boolean bl = true;
        try {
            if (n >= 120) {
                this.thePermanentStorage.writeData(this.getComponentID(), kPollIntervalStorageId, (Object)n);
            } else {
                bl = false;
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error((Object)storageEntryException);
            bl = false;
        }
        return bl;
    }

    public int getEventPort() throws CommunicationException {
        int n = 3052;
        if (this.theEventPort == -1) {
            try {
                Object object = this.thePermanentStorage.readData(this.getComponentID(), kPSEventPortStorageId);
                if (object instanceof Integer) {
                    n = (Integer)object;
                    logger.debug("Got event port from m11.cfg: " + n);
                }
                if (n < 0) {
                    n = 3052;
                    this.thePermanentStorage.writeData(this.getComponentID(), kPSEventPortStorageId, (Object)n);
                }
            }
            catch (StorageEntryException storageEntryException) {
                logger.trace((Object)storageEntryException);
                logger.debug("No event port in m11.cfg. Using default event port 3052");
                n = 3052;
            }
            this.theEventPort = n;
        } else {
            n = this.theEventPort;
        }
        logger.debug("Event receiver port is: " + n);
        return n;
    }

    public void setEventPort(int n) {
        this.theEventPort = n;
    }

    public String getUsername() {
        logger.trace("getUsername()");
        return this.services.getAuthHelper().getPowerChuteUsername();
    }

    public boolean setUsername(String string) {
        boolean bl = false;
        if (StringUtils.isNotEmpty((CharSequence)string) && this.services.getAuthHelper().checkUsername(string)) {
            this.services.getAuthHelper().setPowerChuteUsername(string);
            bl = true;
        }
        return bl;
    }

    public String getPassword() {
        return this.services.getAuthHelper().getPowerChutePassword();
    }

    public Integer getESXiConfigurationMode() {
        return this.services.getVirtualConfigurationManager().getESXiConfigMode();
    }

    public boolean setPassword(String string) {
        logger.debug("setPassword() - start");
        AuthHelper authHelper = this.services.getAuthHelper();
        if (StringUtils.isEmpty((CharSequence)string) || !authHelper.isPasswordValid(string)) {
            logger.debug("setPassword() - Failed password validation checks, skipping procedure");
            return false;
        }
        authHelper.setPowerChutePassword(string);
        logger.debug("setPassword() - end");
        return true;
    }

    public boolean setESXiConfigurationMode(Integer n) {
        boolean bl = false;
        logger.debug("setESXiConfigurationMode() - {}", (Object)n);
        if (n != null && (n.equals(1) || n.equals(2))) {
            String string = this.services.getVirtualConfigurationManager().getESXiConfigMode(n);
            this.services.getConfigurationManager().setProperty("HostDetails", "ConfigurationMode", string);
            bl = true;
        }
        return bl;
    }

    public String getAuthenticationPhrase() {
        return this.services.getAuthHelper().getAuthenticationPhrase();
    }

    public boolean setAuthenticationPhrase(String string) {
        boolean bl = false;
        if (StringUtils.isNotEmpty((CharSequence)string) && this.services.getAuthHelper().checkAuth(string)) {
            this.services.getAuthHelper().setAuthenticationPhrase(string);
            bl = true;
        }
        return bl;
    }

    @Override
    public void keepAliveTimerExpired() {
        this.theDataStore.invalidateDataSet();
        this.theFlexEventGenerator.checkForFlexEvents();
    }

    public Boolean getTurnOffUpsFlag() {
        return this.turnOffUPS;
    }

    public Boolean getTurnOffSOGFlag() {
        return this.turnOffSOG;
    }

    public boolean setTurnOffUpsFlag(Boolean bl) {
        if (bl != this.turnOffUPS) {
            this.turnOffUPS = bl;
            this.services.getConfigurationManager().setProperty("Shutdown", "turnOffUps", this.turnOffUPS);
        }
        return true;
    }

    public boolean setTurnOffSOGFlag(Boolean bl) {
        if (bl != this.turnOffSOG) {
            this.turnOffSOG = bl;
            this.services.getConfigurationManager().setProperty("Shutdown", "turnOffSOG", this.turnOffSOG);
        }
        return true;
    }

    private synchronized boolean startLoad() {
        ++this.loads;
        logger.debug("loads pending:" + this.loads);
        return this.loads <= 1;
    }

    private synchronized boolean missed() {
        if (this.loads > 1) {
            logger.debug("skipped" + this.loads);
            this.loads = 0;
            return true;
        }
        return false;
    }

    private synchronized void clearLoad() {
        if (this.loads == 1) {
            logger.debug("load cleared");
            this.loads = 0;
        }
    }

    public void removeConfiguration() {
        this.setOutletGroup(null);
        this.services.getConfigurationManager().clearProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(this.thePSIndex));
    }

    void loadConfiguration() throws ComponentFailureException {
        try {
            Object object;
            logger.debug("loadConfiguration() - started");
            this.setUsername(this.readUsername());
            this.setPassword(this.readPassword());
            this.setAuthenticationPhrase(this.readAuthenticationPhrase());
            this.checkLicensing();
            if (this.services.getVirtualConfigurationManager().isESXi()) {
                this.setESXiConfigurationMode(this.services.getVirtualConfigurationManager().getESXiConfigMode());
            }
            Boolean bl = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true);
            this.enrolWithNMC = bl;
            if (!this.advancedMode.booleanValue()) {
                bl = this.services.getConfigurationManager().getBoolean("Shutdown", "turnOffUps", (boolean)Boolean.FALSE);
                this.turnOffUPS = bl;
                bl = this.services.getConfigurationManager().getBoolean("Shutdown", "turnOffSOG", (boolean)Boolean.FALSE);
                this.turnOffSOG = bl;
            } else {
                object = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.advanced_ups_setup_idx);
                if (object == null) {
                    logger.error("Unable to load configuration for setup:" + this.advanced_ups_setup_idx + " from ini file");
                    throw new ComponentFailureException();
                }
                this.turnOffUPS = ((UPSSetup)object).getTurnOffUps();
                this.turnOffSOG = ((UPSSetup)object).getTurnOffSOG();
            }
            object = this.services.getConfigurationManager().getString("Networking", "NetworkConfig");
            InetAddress inetAddress = null;
            if (((String)object).equalsIgnoreCase("IPV4")) {
                inetAddress = this.readLocalHostAddress();
            } else if (((String)object).equalsIgnoreCase("IPV6")) {
                inetAddress = this.readLocalHostIPv6Address();
            }
            if (inetAddress != null) {
                String string = null;
                try {
                    string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
                }
                catch (ConversionException conversionException) {
                    string = null;
                }
                if (StringUtils.isBlank(string)) {
                    this.setLocalHostAddress(inetAddress);
                } else if (this.localhost == null || !inetAddress.getHostAddress().equalsIgnoreCase(this.localhost.getHostAddress())) {
                    this.localhost = inetAddress;
                }
            }
            this.setUnicastAddress(this.readUnicastAddress());
            this.setMulticastAddress(this.readMulticastAddress());
            this.clearLoad();
            logger.debug("loadConfiguration: completed");
        }
        catch (Exception exception) {
            logger.warn("loadConfiguration: failed", (Throwable)exception);
            throw new ComponentFailureException();
        }
    }

    private void checkLicensing() {
        logger.debug("checkLicensing() - start");
        this.checkLicensingAuthenticationId();
        this.checkLicensingProxyUsername();
        this.checkLicensingProxyPassword();
        this.services.getLicensingUtils().getQuantityFromIni();
        logger.debug("checkLicensing() - end");
    }

    private void checkLicensingAuthenticationId() {
        logger.debug("checkLicensingAuthenticationId() - start");
        if (this.config.containsKey("Licensing", "licensingActivationId")) {
            logger.debug("checkLicensingAuthenticationId() - activation id found in INI.");
            String string = this.config.getString("Licensing", "licensingActivationId");
            if (!this.services.getLicensingUtils().getActivationIdValidator().isValid(string)) {
                logger.error("checkLicensingAuthenticationId() - invalid activation id found in INI");
            } else if (this.services.getLicensingManager().isLicensed()) {
                logger.debug("checkLicensingAuthenticationId() - already licensed, ignoring activation id from INI");
            } else if (StringUtils.isNotBlank((CharSequence)string)) {
                logger.debug("checkLicensingAuthenticationId() - not licensed, setting activation id");
                this.services.getAuthHelper().setLicensingActivationId(string);
            }
            logger.debug("checkLicensingAuthenticationId() - removing activation id from INI.");
            this.config.clearProperty("Licensing", "licensingActivationId");
        }
        logger.debug("checkLicensingAuthenticationId() - end");
    }

    private void checkLicensingProxyUsername() {
        logger.debug("checkLicensingProxyUsername() - start");
        if (this.config.containsKey("Licensing", "licensingProxyUsername")) {
            logger.debug("checkLicensingProxyUsername() - proxy username found in INI.");
            String string = this.config.getString("Licensing", "licensingProxyUsername");
            if (StringUtils.isNotBlank((CharSequence)string)) {
                logger.debug("checkLicensingProxyUsername() - setting proxy username");
                this.services.getAuthHelper().setProxyUsername(string);
            }
            logger.debug("checkLicensingProxyUsername() - removing proxy username from INI.");
            this.config.clearProperty("Licensing", "licensingProxyUsername");
        }
        logger.debug("checkLicensingProxyUsername() - end");
    }

    private void checkLicensingProxyPassword() {
        logger.debug("checkLicensingProxyPassword() - start");
        if (this.config.containsKey("Licensing", "licensingProxyPassword")) {
            logger.debug("checkLicensingProxyPassword() - proxy password found in INI.");
            String string = this.config.getString("Licensing", "licensingProxyPassword");
            if (StringUtils.isNotBlank((CharSequence)string)) {
                logger.debug("checkLicensingProxyPassword() - setting proxy password");
                this.services.getAuthHelper().setProxyPassword(string);
            }
            logger.debug("checkLicensingProxyPassword() - removing proxy password from INI.");
            this.config.clearProperty("Licensing", "licensingProxyPassword");
        }
        logger.debug("checkLicensingProxyPassword() - end");
    }

    private String readUsername() {
        String string = this.getUsername();
        String string2 = null;
        if (this.services.getConfigurationManager().containsKey("NetworkManagementCard", "username")) {
            logger.debug("readUsername() - INI contains username key");
            try {
                Pattern pattern = Pattern.compile("^[\\w\" \"!\"#$%&'()\\\\*+,-./:;<=>?@\\^`{|}\\[\\]~]{1,128}$");
                string2 = this.services.getConfigurationManager().getString("NetworkManagementCard", "username", pattern);
                if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                    LogUtils.logMessage("UserNameChangedIni", string, string2);
                }
            }
            catch (InvalidIniEntryException invalidIniEntryException) {
                logger.error("readUsername() - InvalidIniEntryException: {}", (Throwable)invalidIniEntryException);
                this.services.getApplicationErrorHandler().put("regex.failure", new Object[]{"NetworkManagementCard", "username"});
            }
            catch (ConversionException conversionException) {
                logger.error("readUsername() - ConversionException: {}", (Throwable)conversionException);
            }
            this.services.getConfigurationManager().clearProperty("NetworkManagementCard", "username");
        }
        if (StringUtils.isEmpty(string2)) {
            logger.debug("readUsername() - Username not contained in INI.  Trying m11.cfg.");
        }
        return StringUtils.isNotEmpty(string2) ? StringUtils.trim(string2) : string;
    }

    private String readPassword() {
        String string = this.getPassword();
        String string2 = null;
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        if (configurationManager.containsKey("NetworkManagementCard", "password")) {
            logger.debug("readPassword() - Password key contained in INI.");
            try {
                string2 = configurationManager.getString("NetworkManagementCard", "password", Pattern.compile("(^\\S).{10,126}(\\S$)"));
                if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                    LogUtils.logMessage("PasswordChangedIni");
                }
            }
            catch (InvalidIniEntryException invalidIniEntryException) {
                logger.error("readPassword() - InvalidIniEntryException: {}", (Throwable)invalidIniEntryException);
                this.services.getApplicationErrorHandler().put("regex.failure", new Object[]{"NetworkManagementCard", "password"});
            }
            catch (ConversionException conversionException) {
                logger.error("readPassword() - ConversionException: {}", (Throwable)conversionException);
            }
            configurationManager.clearProperty("NetworkManagementCard", "password");
        }
        if (StringUtils.isEmpty(string2)) {
            logger.debug("readPassword() - Failed to find password in INI, looking in m11.cfg");
        }
        return StringUtils.isNotEmpty(string2) ? StringUtils.trim(string2) : string;
    }

    private String readAuthenticationPhrase() {
        String string = this.getAuthenticationPhrase();
        String string2 = null;
        if (this.services.getConfigurationManager().containsKey("NetworkManagementCard", "authenticationPhrase")) {
            logger.debug("Authentication Phrase key in INI.");
            try {
                Pattern pattern = Pattern.compile("^\\S.{13,30}\\S$");
                string2 = this.services.getConfigurationManager().getString("NetworkManagementCard", "authenticationPhrase", pattern);
                if (!StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                    LogUtils.logMessage("AuthPhraseChangedIni");
                }
            }
            catch (InvalidIniEntryException invalidIniEntryException) {
                logger.error((Object)invalidIniEntryException);
                this.services.getApplicationErrorHandler().put("regex.failure", new Object[]{"NetworkManagementCard", "authenticationPhrase"});
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
            this.services.getConfigurationManager().clearProperty("NetworkManagementCard", "authenticationPhrase");
        }
        if (StringUtils.isEmpty(string2)) {
            logger.debug("Failed to get auth phrase from INI, checking m11.cfg");
        }
        return StringUtils.isNotEmpty(string2) ? StringUtils.trim(string2) : string;
    }

    private InetAddress readLocalHostAddress() {
        logger.trace("readLocalHostAddress: started");
        String string = this.getLocalIPStr();
        StringSetValidator stringSetValidator = new StringSetValidator(string);
        if (!this.services.getVirtualConfigurationManager().isConfigWizardComplete()) {
            stringSetValidator.add(BLANK);
        }
        Set<InetAddress> set = this.getLocalIPSet();
        for (InetAddress inetAddress : set) {
            stringSetValidator.add(inetAddress.getHostAddress());
        }
        try {
            string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
            if (string != null) {
                if (!stringSetValidator.isValid(string = string.trim())) {
                    this.services.getApplicationErrorHandler().put("invalid.value", new Object[]{"Networking", "localHostAddress"});
                }
            } else {
                string = this.getLocalIPStr();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        Object object = null;
        if (!BLANK.equals(string)) {
            try {
                object = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException);
            }
        }
        logger.trace("readLocalHostAddress: completed");
        return object;
    }

    private InetAddress readLocalHostIPv6Address() {
        logger.trace("readLocalHostIPv6Address: started");
        String string = this.getLocalIPV6();
        StringSetValidator stringSetValidator = new StringSetValidator(string);
        if (!this.services.getVirtualConfigurationManager().isConfigWizardComplete()) {
            stringSetValidator.add(BLANK);
        }
        Set<InetAddress> set = this.getLocalIPv6Set();
        for (InetAddress inetAddress : set) {
            stringSetValidator.add(inetAddress.getHostAddress());
        }
        try {
            string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
            if (string != null) {
                if (!stringSetValidator.isValid(string = string.trim())) {
                    this.services.getApplicationErrorHandler().put("invalid.value", new Object[]{"Networking", "localHostAddress"});
                }
            } else {
                string = this.getLocalIPV6();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        Object object = null;
        if (!BLANK.equals(string)) {
            try {
                object = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException);
            }
        }
        logger.trace("readLocalHostIPv6Address: completed");
        return object;
    }

    private String readUnicastAddress() {
        logger.trace("readUnicastAddress: started");
        String string = null;
        try {
            string = this.services.getConfigurationManager().getString("Networking", "UnicastAddress");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            string = null;
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            string = null;
        }
        if (BLANK.equals(string)) {
            this.UnicastAddress = null;
        } else if (string != null) {
            this.UnicastAddress = string.toString();
        }
        logger.trace("readLocalHostAddress: completed");
        return this.UnicastAddress;
    }

    private String readMulticastAddress() {
        logger.trace("readMulticastAddress: started");
        String string = null;
        InetAddressValidator inetAddressValidator = new InetAddressValidator(string);
        try {
            string = this.services.getConfigurationManager().getString("Networking", "MulticastAddress", inetAddressValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = null;
            logger.error((Object)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            string = null;
        }
        if (BLANK.equals(string)) {
            this.MulticastAddress = null;
        } else if (string != null) {
            this.MulticastAddress = string.toString();
        }
        logger.trace("readMulticastAddress: completed");
        return this.MulticastAddress;
    }

    private void setPropertyNames() {
        this.propertyNames = new ArrayList<String>();
        this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", "username"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", "password"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", "authenticationPhrase"));
        Set<String> set = this.services.getConfigurationManager().getSectionKeys("NetworkManagementCard");
        for (String string : set) {
            if (!string.startsWith("IP_") || string.endsWith("_Outlet") || string.endsWith("_Outlets")) continue;
            this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", string));
        }
        for (String string : set) {
            if (!string.endsWith("_Outlet")) continue;
            this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", string));
        }
        this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", "port"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("NetworkManagementCard", "protocol"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("Networking", "localHostAddress"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("Shutdown", "turnOffUps"));
        this.propertyNames.add(ConfigurationKeys.getPropertyName("Shutdown", "turnOffSOG"));
    }

    public Map<String, String> getOutletMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            try {
                String string = UPSLink.getOutletTurnOffPendingKey(i);
                Object object = this.theDataStore.readObject(string);
                if (object == null) continue;
                hashMap.put(string, object.toString());
                continue;
            }
            catch (CommunicationException communicationException) {
                logger.info((Object)communicationException);
                continue;
            }
            catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                logger.info((Object)invalidDataIdentifierException);
            }
        }
        return hashMap;
    }

    public boolean hasOutlets() {
        Map<String, String> map = this.getOutletMap();
        boolean bl = !map.isEmpty();
        return bl;
    }

    public int getTurnOffDelay() throws CommunicationException {
        int n = -1;
        String string = UPSLink.getOutletTurnOffDelayKey(this.outletGroup);
        try {
            Object object = this.theDataStore.readObject(string);
            if (object != null) {
                n = Integer.parseInt(object.toString());
            }
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.error((Object)invalidDataIdentifierException);
        }
        return n;
    }

    public int getTurnOffPendingSignal(Integer n) throws CommunicationException {
        int n2 = -1;
        String string = UPSLink.getOutletTurnOffPendingKey(n);
        try {
            Object object = this.theDataStore.readObject(string);
            if (object != null) {
                n2 = Integer.parseInt(object.toString());
            }
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.error((Object)invalidDataIdentifierException);
        }
        return n2;
    }

    public boolean isListening() {
        if (this.theBroadcastReceiver != null && this.theBroadcastReceiver.isListening()) {
            return true;
        }
        return this.theIPv6PacketReceiver != null && this.theIPv6PacketReceiver.isListening();
    }

    private synchronized Set<InetAddress> getLocalIPSet() {
        if (this.localIPSet == null) {
            this.localIPSet = IPUtils.getLocalhostAddresses();
        }
        return this.localIPSet;
    }

    private synchronized Set<InetAddress> getLocalIPv6Set() {
        if (this.localIPv6Set == null) {
            this.localIPv6Set = IPUtils.getLocalhostIPv6Addresses();
        }
        return this.localIPv6Set;
    }

    private synchronized InetAddress getLocalIP() {
        if (this.localIP == null || this.bLoopbackAddress) {
            int n;
            Set<InetAddress> set = this.getLocalIPSet();
            for (n = 0; set.isEmpty() && n < 20; ++n) {
                new CountdownTimer(1000L, TimeUnit.MILLISECONDS).await(this);
                this.localIPSet = IPUtils.getLocalhostAddresses();
                set = this.getLocalIPSet();
            }
            logger.trace("getLocalIP:  slept for: " + n * 1000);
            if (set.isEmpty()) {
                this.localIP = IPUtils.getLoopbackAddress();
                this.bLoopbackAddress = true;
            } else {
                this.localIP = (InetAddress)set.toArray()[0];
                this.bLoopbackAddress = false;
            }
        }
        return this.localIP;
    }

    private String getLocalIPStr() {
        String string = "UNKNOWN";
        InetAddress inetAddress = this.getLocalIP();
        if (inetAddress != null) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    private boolean hasGlobalIPv6Address(Set<InetAddress> set) {
        boolean bl = false;
        for (InetAddress inetAddress : set) {
            if (!(inetAddress instanceof Inet6Address) || inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private synchronized String getLocalIPV6() {
        if (this.localIP == null || this.bLoopbackAddress) {
            int n;
            Set<InetAddress> set = this.getLocalIPv6Set();
            for (n = 0; (set.isEmpty() || !this.hasGlobalIPv6Address(set)) && n < 20; ++n) {
                new CountdownTimer(1000L, TimeUnit.MILLISECONDS).await(this);
                this.localIPv6Set = IPUtils.getLocalhostIPv6Addresses();
                set = this.getLocalIPv6Set();
            }
            logger.trace("getLocalIP6:  slept for: " + n * 1000);
            if (set.isEmpty()) {
                this.localIP = IPUtils.getIPv6LoopbackAddress();
                this.bLoopbackAddress = true;
            } else {
                this.localIP = (InetAddress)set.toArray()[0];
                this.bLoopbackAddress = false;
            }
        }
        if (this.localIP == null) {
            return "UNKNOWN";
        }
        return this.localIP.getHostAddress();
    }

    private boolean checkAdvancedMode() {
        String string = null;
        boolean bl = false;
        try {
            string = this.services.getConfigurationManager().getString("NetworkManagementCard", "mode");
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        bl = string != null && string.equalsIgnoreCase("advanced");
        return bl;
    }

    public void setAdvancedUpsSetupIndex(int n) {
        this.advanced_ups_setup_idx = n;
    }

    public int getAdvancedUpsSetupIndex() {
        return this.advanced_ups_setup_idx;
    }

    public void setAdvancedUpsSetupName(String string) {
        this.advanced_ups_setup_name = string;
    }

    public String getAdvancedUpsSetupName() {
        return this.advanced_ups_setup_name;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    private Integer getNMCIndex() {
        Integer n = null;
        InetAddress inetAddress = this.getNMCAddress();
        if (inetAddress != null) {
            int n2 = 0;
            boolean bl = false;
            do {
                String string = null;
                try {
                    string = this.services.getConfigurationManager().getString("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n2));
                }
                catch (ConversionException conversionException) {
                    logger.error((Object)conversionException);
                    string = null;
                }
                if (string == null) {
                    bl = true;
                    continue;
                }
                if (string.compareTo(inetAddress.getHostAddress()) == 0) {
                    n = n2;
                    bl = true;
                    continue;
                }
                ++n2;
            } while (!bl);
        }
        return n;
    }
}

