/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResolvingHostnameVerifier
implements HostnameVerifier {
    private static final Logger logger = LogManager.getLogger(ResolvingHostnameVerifier.class);

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        logger.trace("verify() - start {} {} ", (Object)string, (Object)sSLSession);
        if (string == null || sSLSession == null) {
            logger.warn("verify() - invalid arguments");
            return false;
        }
        try {
            String string2;
            Integer n;
            Collection<List<?>> collection;
            X509Certificate x509Certificate;
            Certificate[] certificateArray;
            InetAddress inetAddress = InetAddress.getByName(string);
            String string3 = inetAddress.getCanonicalHostName();
            logger.trace("verify() - requested:{}  which resolves as {}", (Object)string, (Object)string3);
            for (Certificate certificate : certificateArray = sSLSession.getPeerCertificates()) {
                if (certificate instanceof X509Certificate) {
                    x509Certificate = (X509Certificate)certificate;
                    collection = x509Certificate.getSubjectAlternativeNames();
                    if (collection != null) {
                        for (List<?> list : collection) {
                            n = (Integer)list.get(0);
                            if (n == 2 || n == 7) {
                                string2 = (String)list.get(1);
                                if (string3.equalsIgnoreCase(string2)) {
                                    logger.trace("verify() - end Found a matching hostname {}", (Object)string2);
                                    return true;
                                }
                                logger.trace("non matching hostname {}", (Object)string2);
                                continue;
                            }
                            logger.trace("ignoring name of type {}", (Object)n);
                        }
                        continue;
                    }
                    logger.trace("No alternative names");
                    continue;
                }
                logger.trace("non X509 Certificate");
            }
            logger.trace("verify() - Check if the certificates have IP addresses");
            for (Certificate certificate : certificateArray) {
                if (certificate instanceof X509Certificate) {
                    x509Certificate = (X509Certificate)certificate;
                    collection = x509Certificate.getSubjectAlternativeNames();
                    if (collection != null) {
                        for (List<?> list : collection) {
                            n = (Integer)list.get(0);
                            if (n == 2 || n == 7) {
                                string2 = (String)list.get(1);
                                InetAddress inetAddress2 = InetAddress.getByName(string2);
                                String string4 = inetAddress2.getCanonicalHostName();
                                if (string3.equalsIgnoreCase(string4)) {
                                    logger.trace("verify() - end Found a matching resolved hostname {}", (Object)string4);
                                    return true;
                                }
                                logger.trace("non matching hostname {}", (Object)string2);
                                continue;
                            }
                            logger.trace("ignoring name of type {}", (Object)n);
                        }
                        continue;
                    }
                    logger.trace("No alternative names");
                    continue;
                }
                logger.trace("non X509 Certificate");
            }
        }
        catch (UnknownHostException | CertificateParsingException | SSLPeerUnverifiedException exception) {
            logger.error("verify()", (Throwable)exception);
        }
        logger.debug("HostnameVerifier() end  - not found");
        return false;
    }
}

