/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.HttpFormPoster;
import com.apcc.m11.components.stdpowersource.HttpTransportAdapter;
import com.apcc.m11.components.stdpowersource.IAdapterAccessConsumer;
import com.apcc.m11.components.stdpowersource.PendingRequest;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.TransportCommException;
import com.apcc.m11.components.stdpowersource.TurnOffAdapterThread;
import com.apcc.m11.components.stdpowersource.WaitForAdapterAccess;
import com.apcc.m11.util.ApcQueue;
import com.apcc.m11.util.MD5;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecureHttpTransportAdapter
extends HttpTransportAdapter
implements IAdapterAccessConsumer {
    private static final String UTF8 = "UTF-8";
    private static final Logger logger = LogManager.getLogger(SecureHttpTransportAdapter.class);
    private PowerSourceComponent thePowerSourceComponent;
    private String theUserName;
    private String thePasswordPhrase;
    private boolean useStaticData = false;
    private ApcQueue thePendingSetQueue;
    private long theNumberOfReboots = 0L;
    private long theUpTime = 0L;
    private String addr = null;
    private String addr_verify = null;
    private static final long kUptimeTwoMinutes = 12000L;
    private static final int kHexRadix = 16;
    private TurnOffAdapterThread theTurnOffThread;

    public SecureHttpTransportAdapter(String string, InetAddress inetAddress, Integer n, PowerSourceComponent powerSourceComponent, ApplicationErrorHandler applicationErrorHandler, TrustStoreManager trustStoreManager, UnverifiedCertificateManager unverifiedCertificateManager) {
        super(string, inetAddress, n, applicationErrorHandler, trustStoreManager, unverifiedCertificateManager);
        this.thePowerSourceComponent = powerSourceComponent;
        this.theTurnOffThread = null;
    }

    public SecureHttpTransportAdapter(String string, InetAddress inetAddress, Integer n, String string2, String string3, ApplicationErrorHandler applicationErrorHandler, TrustStoreManager trustStoreManager, UnverifiedCertificateManager unverifiedCertificateManager) {
        super(string, inetAddress, n, applicationErrorHandler, trustStoreManager, unverifiedCertificateManager);
        this.theUserName = string2;
        this.thePasswordPhrase = string3;
        this.useStaticData = true;
        this.theTurnOffThread = null;
    }

    @Override
    public void setHostAddress(InetAddress inetAddress) {
        if (!inetAddress.equals(this.theHost)) {
            super.setHostAddress(inetAddress);
            this.theNumberOfReboots = 0L;
            this.theUpTime = 0L;
        }
    }

    @Override
    public Hashtable<String, String> getDataSet(byte[] byArray) throws TransportCommException {
        Hashtable<String, String> hashtable = super.getDataSet(byArray);
        try {
            if (hashtable == null) {
                throw new TransportCommException("Could not read information from power source");
            }
            if (!this.verify_status_data(hashtable)) {
                throw new TransportCommException("DataSet could not be authenticated");
            }
        }
        catch (TransportCommException transportCommException) {
            throw transportCommException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return hashtable;
    }

    @Override
    public Hashtable<String, String> getControlSet() throws TransportCommException, SecurityException, SSLException {
        logger.trace("getControlSet: started");
        Hashtable<String, String> hashtable = super.getControlSet();
        try {
            if (hashtable == null) {
                throw new TransportCommException("Could not read information from power source");
            }
            if (!this.verify_control_data(hashtable)) {
                throw new SecurityException("Control set could not be authenticated");
            }
        }
        catch (TransportCommException transportCommException) {
            logger.warn((Object)transportCommException);
            throw transportCommException;
        }
        catch (SecurityException securityException) {
            logger.warn((Object)securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        logger.trace("getControlSet: completed");
        return hashtable;
    }

    @Override
    public Hashtable<String, String> getConfigurationSet(byte[] byArray) throws TransportCommException {
        Hashtable<String, String> hashtable = super.getConfigurationSet(byArray);
        try {
            if (hashtable == null) {
                throw new TransportCommException("Could not read information from power source");
            }
            if (!this.verify_config_data(hashtable)) {
                throw new TransportCommException("ConfigurationSet could not be authenticated");
            }
        }
        catch (TransportCommException transportCommException) {
            throw transportCommException;
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return hashtable;
    }

    @Override
    public void setControlData(String string, Object object) throws TransportCommException, SecurityException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("macontrol1_config_client_1=");
        arrayList.add("macontrol1_client_registersog=");
        arrayList.add("macontrol1_client_unregistersog=");
        arrayList.add("macontrol1_control_shutdown_1=");
        arrayList.add("macontrol1_control_shutdowngroup=");
        arrayList.add("macontrol1_maxctrl_shutdowngroup=");
        arrayList.add("macontrol1_maxctrl_shutdown_1=");
        if (arrayList.contains(string)) {
            if (this.thePendingSetQueue == null) {
                this.thePendingSetQueue = new ApcQueue();
            }
            if (this.theTurnOffThread != null && this.theTurnOffThread.isFinished()) {
                logger.info("SecureHttpTransportAdapter.setControlSet() reset turnOffThread null");
                this.theTurnOffThread = null;
            }
            if (this.theTurnOffThread == null) {
                PendingRequest pendingRequest = new PendingRequest(string, object);
                if (string.equals("macontrol1_control_shutdown_1=") || string.equals("macontrol1_control_shutdowngroup=")) {
                    logger.info("SecureHttpTransportAdapter.setControlSet() starting turn off thread");
                    this.theTurnOffThread = new TurnOffAdapterThread(this, this, pendingRequest, this.thePowerSourceComponent);
                    this.theTurnOffThread.start();
                } else {
                    logger.info("SecureHttpTransportAdapter.setControlSet() waiting for adapter access");
                    WaitForAdapterAccess waitForAdapterAccess = new WaitForAdapterAccess(this, this, pendingRequest);
                    waitForAdapterAccess.start();
                }
            }
        } else {
            throw new SecurityException("ConfigurationSet could not be authenticated");
        }
    }

    private boolean verify_status_data(Hashtable<String, String> hashtable) {
        boolean bl = false;
        logger.trace("This is the parsed data" + String.valueOf(hashtable));
        bl = this.verify_data(hashtable, this.getHttpStatusPage());
        return bl;
    }

    private boolean verify_config_data(Hashtable<String, String> hashtable) {
        boolean bl = false;
        bl = this.verify_c_data(hashtable, this.getHttpConfigPage());
        return bl;
    }

    private boolean verify_control_data(Hashtable<String, String> hashtable) {
        boolean bl = false;
        logger.trace("This is the parsed data" + String.valueOf(hashtable));
        bl = this.verify_data(hashtable, this.getHttpControlPage());
        return bl;
    }

    private boolean verify_data(Hashtable<String, String> hashtable, String string) {
        boolean bl = false;
        if (hashtable != null && this.is_firmware_version_ok(hashtable.get("MV"))) {
            MD5 mD5 = new MD5();
            mD5.Init();
            String string2 = hashtable.get("MD");
            String string3 = string;
            int n = string3.indexOf("MD=");
            if (n > 0) {
                String string4 = new String(string3.substring(0, n));
                if (!this.useStaticData) {
                    this.theUserName = this.thePowerSourceComponent.getUsername();
                    this.thePasswordPhrase = this.thePowerSourceComponent.getAuthenticationPhrase();
                }
                mD5.Update(string4 + this.theUserName + this.thePasswordPhrase);
                String string5 = mD5.asHex();
                logger.trace("Received Hash: " + string2);
                logger.trace("Computed Hash: " + string5);
                if (string5.equals(string2)) {
                    String string6 = hashtable.get("PC");
                    try {
                        this.addr_verify = InetAddress.getByName(string6).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.error((Object)unknownHostException);
                    }
                    if (string6 != null && this.addr_verify.equals(this.theHost.getHostAddress())) {
                        logger.debug("This packets is valid: " + this.addr_verify);
                        long l = Long.valueOf(hashtable.get("SU"), 16);
                        long l2 = Long.valueOf(hashtable.get("SR"), 16);
                        logger.debug("SecureHttpTransportAdapter.verify_data() checking reboots/uptime . . .");
                        logger.debug("SecureHttpTransportAdapter.verify_data() last reboot " + this.theNumberOfReboots);
                        logger.debug("SecureHttpTransportAdapter.verify_data() last uptime " + this.theUpTime);
                        logger.debug("SecureHttpTransportAdapter.verify_data() packet reboot " + l2);
                        logger.debug("SecureHttpTransportAdapter.verify_data() packet uptime " + l);
                        if (l2 == this.theNumberOfReboots && l >= this.theUpTime) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        } else if (l2 > this.theNumberOfReboots) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        } else if (l < 12000L) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        } else {
                            logger.debug("SecureHttpTransportAdapter.verify_data() reboots/uptime failed");
                        }
                    } else {
                        logger.debug("This packets is rejected: " + this.addr_verify);
                        String string7 = hashtable.get("01");
                        this.theKnownNMCs.put(string6, string7);
                    }
                } else {
                    logger.debug("SecureHttpTransportAdapter.verify_data() MD5 Hash failed. Username: {}, Auth Phrase: {}", (Object)this.theUserName, (Object)this.thePasswordPhrase);
                }
            }
        }
        if (bl) {
            logger.info("StdPowerSource: GET VERIFICATION PASSED");
        }
        return bl;
    }

    private boolean verify_c_data(Hashtable<String, String> hashtable, String string) {
        boolean bl = false;
        if (hashtable != null && this.is_firmware_version_ok(hashtable.get("MV"))) {
            MD5 mD5 = new MD5();
            mD5.Init();
            String string2 = hashtable.get("MD");
            String string3 = string;
            int n = string3.indexOf("MD=");
            if (n > 0) {
                String string4 = new String(string3.substring(0, n));
                if (!this.useStaticData) {
                    this.theUserName = this.thePowerSourceComponent.getUsername();
                    this.thePasswordPhrase = this.thePowerSourceComponent.getAuthenticationPhrase();
                }
                mD5.Update(string4 + this.theUserName + this.thePasswordPhrase);
                String string5 = mD5.asHex();
                if (string5.equals(string2)) {
                    String string6 = hashtable.get("PC");
                    try {
                        this.addr = InetAddress.getByName(string6).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.error((Object)unknownHostException);
                    }
                    if (string6 != null && this.addr.equals(this.theHost.getHostAddress())) {
                        long l = Long.valueOf(hashtable.get("SU"), 16);
                        long l2 = Long.valueOf(hashtable.get("SR"), 16);
                        if (l2 == this.theNumberOfReboots && l >= this.theUpTime) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        } else if (l2 > this.theNumberOfReboots) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        } else if (l < 12000L) {
                            bl = true;
                            this.theUpTime = l;
                            this.theNumberOfReboots = l2;
                        }
                    } else {
                        String string7 = hashtable.get("01");
                        this.theKnownNMCs.put(string6, string7);
                    }
                }
            }
        }
        if (bl) {
            logger.info("StdPowerSource: GET VERIFICATION PASSED");
        }
        return bl;
    }

    @Override
    public void tokenGranted(String string, PendingRequest pendingRequest) {
        if (string == null) {
            logger.info("Entering SecureHttpTransportAdapter.tokenGranted() aChallengeString is null");
        }
        if (pendingRequest != null) {
            this.sendRequestToAdapter(pendingRequest, string);
        } else {
            logger.info("Entering SecureHttpTransportAdapter.tokenGranted() request is null");
        }
    }

    private void sendRequestToAdapter(PendingRequest pendingRequest, String string) {
        block7: {
            InetAddress inetAddress = super.getHostAddress();
            String string2 = inetAddress.getHostAddress();
            try {
                string2 = new String(string2.substring(0, string2.indexOf("/")));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            if (!this.useStaticData) {
                this.theUserName = this.thePowerSourceComponent.getUsername();
                this.thePasswordPhrase = this.thePowerSourceComponent.getAuthenticationPhrase();
            }
            int n = super.getHostPort();
            try {
                if (string2 == null) break block7;
                URL uRL = new URL(this.protocol, string2, n, "/Forms/macontrol1");
                String string3 = pendingRequest.getRequest() + pendingRequest.getValue().toString() + ",";
                MD5 mD5 = new MD5();
                mD5.Init();
                String string4 = pendingRequest.getValue().toString() + ",";
                mD5.Update(string3 + string + this.theUserName + this.thePasswordPhrase);
                try {
                    string3 = pendingRequest.getRequest() + URLEncoder.encode(string4, UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error((Object)unsupportedEncodingException);
                }
                SetResult setResult = new SetResult();
                string3 = string3 + mD5.asHex();
                HttpFormPoster httpFormPoster = new HttpFormPoster(uRL, string3, setResult, this.errorHandler, this.trustStoreManager, this.unverifiedCertManager);
                httpFormPoster.start();
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException);
            }
        }
    }

    private boolean is_firmware_version_ok(String string) {
        return true;
    }
}

