/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.stdpowersource.DataConsumerAdapter;
import com.apcc.m11.components.stdpowersource.DataSourceAdapter;
import com.apcc.m11.components.stdpowersource.IEventHandler;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.powersource.DependentDevices;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownEventHandler
implements IEventHandler {
    private static final Logger logger = LogManager.getLogger(ShutdownEventHandler.class);
    private static final int kDefaultShutdownTime = 60;
    private static final boolean kDefaultTurnOffPowerSourceFlag = true;
    private static final int kRequestTimeout = 1000;
    private static final int kRequestRetryCount = 3;
    private static final String kLoopbackAddress = "127.0.0.1";
    private ObjectId theTriggerObjectId;
    protected PowerSourceComponent thePowerSourceComponent;
    protected DataConsumerAdapter theDataConsumerAdapter;
    private DataSourceAdapter theDataSourceAdapter;
    private ServiceManager services;
    private Vector<String> theLocalServerAddress = new Vector();

    public ShutdownEventHandler(PowerSourceComponent powerSourceComponent, DataConsumerAdapter dataConsumerAdapter, DataSourceAdapter dataSourceAdapter, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.thePowerSourceComponent = powerSourceComponent;
        this.theDataConsumerAdapter = dataConsumerAdapter;
        this.theDataSourceAdapter = dataSourceAdapter;
        this.theTriggerObjectId = ShutdownEvents.ShutdownStarting.getObjectId();
        this.findServerIPAddress();
    }

    protected void findServerIPAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    String string = enumeration2.nextElement().getHostAddress();
                    if (this.theLocalServerAddress.contains(string) || string.equals(kLoopbackAddress)) continue;
                    this.theLocalServerAddress.add(string);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            this.theLocalServerAddress = new Vector();
        }
    }

    @Override
    public void execute(Event event) {
        logger.debug("Shutdown starting event received:" + String.valueOf(event));
        if (event instanceof AdvancedGroupEvent) {
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
            if (this.thePowerSourceComponent.getAdvancedUpsSetupIndex() != advancedGroupEvent.getGroup()) {
                logger.info("This event is not for us Index[" + Integer.toString(this.thePowerSourceComponent.getAdvancedUpsSetupIndex()) + "] Group[" + Integer.toString(advancedGroupEvent.getGroup()) + "]");
            } else {
                logger.warn("Shutdown starting event received. For Index[" + Integer.toString(this.thePowerSourceComponent.getAdvancedUpsSetupIndex()) + "] Group[" + Integer.toString(advancedGroupEvent.getGroup()) + "]");
                this.processShutdownStartingEvent();
            }
        } else {
            logger.warn("Shutdown starting event received. Index[" + Integer.toString(this.thePowerSourceComponent.getAdvancedUpsSetupIndex()) + "]");
            this.processShutdownStartingEvent();
        }
    }

    protected void setPowerSourceShutdownDelayValue(String string) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theDataConsumerAdapter.getDataSource();
        if (iDataSource != null) {
            iDataSource.set(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)string);
        }
    }

    public void setTurnOffValue(Integer n) throws InvalidValueException, InvalidObjectIdException, CommunicationException, ConversionException {
        IDataSource iDataSource = (IDataSource)this.thePowerSourceComponent.getInterface(DataSource.kOid);
        if (iDataSource != null) {
            iDataSource.set(OperatingStatus.PowerSourceTurnOffTime.getObjectId(), (Object)n);
            logger.info("DONE ShutdownEventhandler OnlyOnBattery = false");
        }
    }

    protected void processShutdownStartingEvent() {
        logger.warn("processShutdownStartingEvent() - start() turn off power source");
        if (!this.isPowerSourceTurnedOffOnShutdown()) {
            logger.warn("Not Configured to Turn off PS");
            return;
        }
        Integer n = this.getTotalShutdownTime();
        Integer n2 = this.getRemainingTurnOffDelayTime();
        Integer n3 = (n - 1) / 60 + 1;
        logger.debug("processShutdownStartingEvent turn off delay:{}", (Object)n3);
        this.findServerIPAddress();
        boolean bl = this.isTurnOffPendingOnOutlet();
        if (bl) {
            logger.warn("ShutdownEventhandler.processShutdownStartingEvent power source already turning off");
            if (n2 == null || n3 > n2) {
                if (this.isServerRegistered()) {
                    logger.info("Increasing the adapter's shutdown delay to " + n3);
                    try {
                        this.setPowerSourceShutdownDelayValue(n3.toString());
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                    }
                } else {
                    logger.error("Not turning off UPS because PCNS is not registered with it");
                }
            }
        } else {
            logger.info("ShutdownEventhandler.processShutdownStartingEvent turning off power source:" + String.valueOf(this.thePowerSourceComponent));
            if (this.isServerRegistered()) {
                logger.info("Signalling the adapter to turn off in  " + n3 + " on " + this.thePowerSourceComponent.getNMCAddressStr());
                try {
                    logger.debug("processShutdownStartingEvent setTurnOffValue({})", (Object)n3);
                    this.setTurnOffValue(n3);
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
            } else {
                logger.error("Not turning off UPS because PCNS is not registered with it");
            }
        }
        logger.info("processShutdownStartingEvent() - end()");
    }

    public boolean isServerRegistered() {
        boolean bl = false;
        logger.debug("isServerRegistered - start()");
        try {
            IDataSource iDataSource = this.theDataConsumerAdapter.getDataSource();
            if (iDataSource != null) {
                GetResult getResult = iDataSource.get(DependentDevices.ListOfDevices.getObjectId());
                Vector vector = (Vector)getResult.getValue();
                Enumeration enumeration = vector.elements();
                int n = 0;
                while (!enumeration.hasMoreElements()) {
                    Thread.sleep(2000L);
                    logger.debug("Find ListOfDevices attempt {}", (Object)n);
                    getResult = iDataSource.get(DependentDevices.ListOfDevices.getObjectId());
                    vector = (Vector)getResult.getValue();
                    enumeration = vector.elements();
                    if (++n <= 10) continue;
                    logger.info("Could not find ListOfDevices ");
                    break;
                }
                block3: while (!bl && enumeration.hasMoreElements()) {
                    InetAddress inetAddress = (InetAddress)enumeration.nextElement();
                    logger.debug("is this {} ", (Object)inetAddress);
                    Enumeration<String> enumeration2 = this.theLocalServerAddress.elements();
                    while (enumeration2.hasMoreElements()) {
                        String string = enumeration2.nextElement();
                        if (string.contains("%")) {
                            int n2 = string.indexOf("%");
                            string = string.substring(0, n2);
                        }
                        if (!string.equals(inetAddress.getHostAddress())) continue;
                        bl = true;
                        continue block3;
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error("No server IP in adapters table. ", (Throwable)exception);
            bl = false;
        }
        logger.debug("isServerRegistered - returns({})", (Object)bl);
        return bl;
    }

    private Integer getTotalShutdownTime() {
        Integer n = 0;
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        boolean bl = true;
        if (this.thePowerSourceComponent.isAdvancedMode()) {
            var4_4 = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.thePowerSourceComponent.getAdvancedUpsSetupIndex());
            if (var4_4 != null) {
                if (((UPSSetup)var4_4).getCmdFileEnabled()) {
                    n = n + ((UPSSetup)var4_4).getCmdFileDuration();
                    logger.info("getTotalShutdownTime adding CmdFileDuration to give shudtown time:{}", (Object)n);
                    if (((UPSSetup)var4_4).isExecuteCommandFileAfterHostShutdown()) {
                        boolean bl2 = true;
                        if (this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && ((UPSSetup)var4_4).getHosts().isEmpty() && !((UPSSetup)var4_4).isVirtualHostsShutdownEnabled()) {
                            bl2 = false;
                        }
                        if (bl2) {
                            n = n + ((UPSSetup)var4_4).getCmdFileDelay();
                            logger.info("getTotalShutdownTime adding CmdFileDelay to give shudtown time:{}", (Object)n);
                        }
                    }
                }
                bl = ((UPSSetup)var4_4).getLocalMachineShutdownEnabled();
                if (this.services.getVirtualConfigurationManager().isManagedESXi() && this.services.getHostSystemUtils().isVCenterServerInstalledOnTargetHost(((UPSSetup)var4_4).getHosts())) {
                    n = n + this.services.getVirtualConfigurationManager().getDurationAdvanced(this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), "VCSA_shutdown_duration");
                    logger.info("getTotalShutdownTime adding vcsa shutdown duration to give shudtown time:{}", (Object)n);
                }
            } else {
                logger.error("Unable to load configuration for setup:" + this.thePowerSourceComponent.getAdvancedUpsSetupIndex() + " from ini file");
            }
        } else {
            try {
                if (configurationManager.getBoolean("Shutdown", "shutdownCommandFileEnabled").booleanValue()) {
                    n = n + configurationManager.getInt("Shutdown", "shutdownCommandFileDelay");
                    n = n + configurationManager.getInt("Shutdown", "shutdownCommandFileDuration");
                }
                if (this.services.getVirtualConfigurationManager().isManagedESXi()) {
                    var4_4 = new LinkedHashSet();
                    List<String> list = this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings");
                    ((AbstractCollection)((Object)var4_4)).addAll(list);
                    if (this.services.getHostSystemUtils().isVCenterServerInstalledOnTargetHost((LinkedHashSet<String>)var4_4)) {
                        n = n + this.services.getVirtualConfigurationManager().getDurationGlobal("VCSA_shutdown_duration");
                    }
                }
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug("getTotalShutdownTime exception:{}", throwable);
            }
        }
        if (bl) {
            try {
                n = n + configurationManager.getInt("Shutdown", "shutdownDelay");
                n = n + configurationManager.getInt("Shutdown", "shutdownCommandDuration");
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug("getTotalShutdownTime exception:{}", throwable);
            }
        }
        logger.debug("getTotalShutdownTime returns({})", (Object)n);
        return n;
    }

    private Integer getRemainingTurnOffDelayTime() {
        Integer n = null;
        try {
            IDataSource iDataSource = this.theDataConsumerAdapter.getDataSource();
            if (iDataSource != null) {
                GetResult getResult = iDataSource.get(OperatingStatus.PowerSourceTurnOffTime.getObjectId());
                for (int i = 0; !getResult.isReady() && i < 3; ++i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                n = getResult.isReady() && !getResult.hasError() ? (Integer)getResult.getValue() : null;
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            n = null;
        }
        catch (CommunicationException communicationException) {
            n = null;
        }
        logger.debug("getRemainingTurnOffDelayTime returns({})", n);
        return n;
    }

    private boolean isPowerSourceTurnedOffOnShutdown() {
        boolean bl = true;
        if (this.thePowerSourceComponent != null) {
            Boolean bl2 = this.thePowerSourceComponent.getTurnOffUpsFlag();
            if (bl2 != null) {
                bl = bl2;
            }
            if (bl || (bl2 = this.thePowerSourceComponent.getTurnOffSOGFlag()) == null || (bl = bl2.booleanValue())) {
                // empty if block
            }
        }
        return bl;
    }

    private boolean isTurnOffPendingOnOutlet() {
        boolean bl = Boolean.FALSE;
        try {
            GetResult getResult = this.theDataSourceAdapter.get(OperatingStatus.OutletTurnOffPendingForMultipleOutlets.getObjectId());
            HashMap hashMap = new HashMap();
            for (int i = 0; !getResult.isReady() && i < 3; ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (getResult.isReady()) {
                Integer n = this.thePowerSourceComponent.getOutletGroup();
                hashMap.putAll((Map)getResult.getValue());
                Boolean bl2 = (Boolean)hashMap.get(n);
                if (bl2 != null && bl2.equals(Boolean.TRUE)) {
                    bl = Boolean.TRUE;
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            bl = Boolean.FALSE;
        }
        catch (CommunicationException communicationException) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    @Override
    public ObjectId getTriggerObjectId() {
        return this.theTriggerObjectId;
    }
}

