/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.components.stdpowersource.DataConsumerAdapter;
import com.apcc.m11.components.stdpowersource.DataSourceAdapter;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.ShutdownEventHandler;
import com.apcc.m11.components.stdpowersource.SinglePSSetValue;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.pcns.ServiceManager;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownOnBatteryEventHandler
extends ShutdownEventHandler {
    private static final Logger logger = LogManager.getLogger(ShutdownOnBatteryEventHandler.class);
    private ObjectId theTriggerObjectId;

    public ShutdownOnBatteryEventHandler(PowerSourceComponent powerSourceComponent, DataConsumerAdapter dataConsumerAdapter, DataSourceAdapter dataSourceAdapter, @NonNull ServiceManager serviceManager) {
        super(powerSourceComponent, dataConsumerAdapter, dataSourceAdapter, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theTriggerObjectId = ShutdownEvents.ShutdownOnBattery.getObjectId();
    }

    @Override
    public void setTurnOffValue(Integer n) throws InvalidValueException, InvalidObjectIdException, CommunicationException, ConversionException {
        logger.debug("setTurnOffValue");
        Object object = this.thePowerSourceComponent.isAdvancedMode() ? new SinglePSSetValue(n.toString(), this.thePowerSourceComponent.getNMCAddressStr()) : n.toString();
        IDataSource iDataSource = (IDataSource)this.thePowerSourceComponent.getInterface(DataSource.kOid);
        if (iDataSource != null) {
            logger.info("ShutdownEventhandler OnlyOnBattery = true");
            iDataSource.set(OperatingStatus.PowerSourceTurnOffOnBattery.getObjectId(), object);
            logger.info("DONE ShutdownEventhandler OnlyOnBattery = true");
        }
    }

    @Override
    protected void setPowerSourceShutdownDelayValue(String string) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
    }

    @Override
    public ObjectId getTriggerObjectId() {
        return this.theTriggerObjectId;
    }
}

