/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.components.stdpowersource.IAdapterAccessConsumer;
import com.apcc.m11.components.stdpowersource.PendingRequest;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.SecureHttpTransportAdapter;
import java.util.Hashtable;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurnOffAdapterThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(TurnOffAdapterThread.class);
    private static final String kAccessGranted = "0";
    private static final int kMaxRetries = 4;
    private IAdapterAccessConsumer theAdapterAccessConsumer;
    private SecureHttpTransportAdapter theDataSource;
    private boolean theFinished = false;
    private PowerSourceComponent thePowerSourceComponent;
    private int theWaitTime = 0;
    private PendingRequest theRequest;

    public TurnOffAdapterThread(SecureHttpTransportAdapter secureHttpTransportAdapter, IAdapterAccessConsumer iAdapterAccessConsumer, PendingRequest pendingRequest, PowerSourceComponent powerSourceComponent) {
        this.theDataSource = secureHttpTransportAdapter;
        this.theAdapterAccessConsumer = iAdapterAccessConsumer;
        this.thePowerSourceComponent = powerSourceComponent;
        this.theRequest = pendingRequest;
        this.theWaitTime = 2000;
    }

    private boolean isPowerSourceTurningOff() {
        return this.thePowerSourceComponent.isTurnOffPending();
    }

    @Override
    public void run() {
        String string = "";
        int n = 0;
        Hashtable<String, String> hashtable = null;
        Random random = new Random(System.currentTimeMillis());
        int n2 = random.nextInt(1000);
        String string2 = this.thePowerSourceComponent.getNMCAddressStr() + "|" + Integer.toString(n2);
        logger.debug(string2 + " Turn off thread started (" + Integer.toString(this.theWaitTime) + ")");
        try {
            Thread.sleep(this.theWaitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (string != null && !string.equals(kAccessGranted) && n <= 4 && !this.isPowerSourceTurningOff()) {
            try {
                Thread.sleep(this.theWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isPowerSourceTurningOff()) {
                logger.debug(string2 + " Power source is not yet turning off");
                try {
                    hashtable = this.theDataSource.getControlSet();
                    logger.debug(string2 + " Got control set");
                    string = hashtable.get("CI");
                    if (string != null) {
                        logger.debug(string2 + " Tried to get token (" + string + ")");
                    } else {
                        logger.debug(string2 + " Tried to get token (null)");
                    }
                }
                catch (Exception exception) {
                    logger.error(string2 + " Exception trying to get token - ", (Throwable)exception);
                }
            }
            ++n;
        }
        logger.debug(string2 + " got Token after:" + n);
        if (hashtable != null && string != null && string.equals(kAccessGranted)) {
            logger.debug(string2 + " Access granted");
            String string3 = (String)hashtable.get("CS");
            hashtable.clear();
            hashtable = null;
            this.theAdapterAccessConsumer.tokenGranted(string3, this.theRequest);
        } else {
            logger.error(string2 + " Access not granted. Turn off will NOT proceed.");
        }
        this.theFinished = true;
    }

    public boolean isFinished() {
        return this.theFinished;
    }
}

