/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

import com.apcc.m11.components.stdpowersource.IAdapterAccessConsumer;
import com.apcc.m11.components.stdpowersource.PendingRequest;
import com.apcc.m11.components.stdpowersource.SecureHttpTransportAdapter;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitForAdapterAccess
extends Thread {
    private static final Logger logger = LogManager.getLogger(WaitForAdapterAccess.class);
    private static final String kAccessGranted = "0";
    private static final int kWaitForAccessBase = 4;
    private static final int kWaitForAccessRange = 3;
    private static final int kMaxRetries = 2;
    private static final int kMillisecsPerSec = 1000;
    private IAdapterAccessConsumer theAdapterAccessConsumer;
    private SecureHttpTransportAdapter theDataSource;
    private int theWaitTime = 0;
    private boolean theAbortThread = false;
    private PendingRequest theRequest;

    WaitForAdapterAccess(SecureHttpTransportAdapter secureHttpTransportAdapter, IAdapterAccessConsumer iAdapterAccessConsumer, PendingRequest pendingRequest) {
        this.theDataSource = secureHttpTransportAdapter;
        this.theAdapterAccessConsumer = iAdapterAccessConsumer;
        this.theRequest = pendingRequest;
        this.theWaitTime = (int)((Math.random() * 3.0 + 4.0) * 1000.0);
    }

    public void abort() {
        this.theAbortThread = true;
    }

    @Override
    public void run() {
        String string = "";
        Hashtable<String, String> hashtable = null;
        for (int i = 0; !string.equals(kAccessGranted) && i <= 2 && !this.theAbortThread; ++i) {
            try {
                Thread.sleep(this.theWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.theAbortThread) continue;
            try {
                hashtable = this.theDataSource.getControlSet();
                if (this.theDataSource.addedCertToKeystore().booleanValue()) {
                    logger.debug("PCNS added NMC SSL certificate to the keystore, to enable secure HTTPS communications \n");
                }
                string = hashtable.get("CI");
                continue;
            }
            catch (Exception exception) {
                logger.debug("Hiding exception and continuing", (Throwable)exception);
            }
        }
        if (!this.theAbortThread && hashtable != null) {
            String string2 = (String)hashtable.get("CS");
            hashtable.clear();
            hashtable = null;
            this.theAdapterAccessConsumer.tokenGranted(string2, this.theRequest);
        } else {
            logger.error("Unable to get control data");
        }
    }
}

