/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource;

public class WindowsFirewallControl {
    public static final int kSuccess = 2;
    public static final int kEnabled = 1;
    public static final int kDisabled = 0;
    public static final int kUnknown = -1;
    public static final int kDoesntExist = -2;
    public static final int kFailed = -3;
    public static final int kNativeLibraryNotLoaded = -4;
    public static final int kTCP = 1;
    public static final int kUDP = 0;
    public static final String kNativeLibraryName32BIT = "fwallctl_32.dll";
    public static final String kNativeLibraryName64BIT = "fwallctl_32.dll";
    private static final String kNativeLibrary32BIT = "fwallctl_32";
    private static final String kNativeLibrary64BIT = "fwallctl_64";
    private boolean theNativeLibraryLoadedFlag = false;

    private native int getFirewallState_Native();

    private native int getApplicationState_Native(String var1);

    private native int setApplicationState_Native(String var1, int var2);

    private native int addApplication_Native(String var1, String var2);

    private native int removeApplication_Native(String var1);

    private native int getExceptionsNotAllowedState_Native();

    private native int setExceptionsNotAllowedState_Native(int var1);

    private native int addPortException_Native(String var1, int var2, int var3);

    private native int removePortException_Native(int var1, int var2);

    private native int getPortState_Native(int var1, int var2);

    private native int setPortState_Native(int var1, int var2, int var3);

    public WindowsFirewallControl() {
        try {
            String string = System.getProperty("sun.arch.data.model");
            if (string != null && string.length() > 0) {
                if ("32".equalsIgnoreCase(string)) {
                    System.loadLibrary(kNativeLibrary32BIT);
                    this.theNativeLibraryLoadedFlag = true;
                } else if ("64".equalsIgnoreCase(string)) {
                    System.loadLibrary(kNativeLibrary64BIT);
                }
            }
        }
        catch (Exception exception) {
            this.theNativeLibraryLoadedFlag = false;
        }
    }

    public int getFirewallState() {
        int n = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n = -3;
            n = this.getFirewallState_Native();
        }
        return n;
    }

    public int getApplicationState(String string) {
        int n = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n = -3;
            if (string != null) {
                n = this.getApplicationState_Native(string);
            }
        }
        return n;
    }

    public int setApplicationState(String string, int n) {
        int n2 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n2 = -3;
            if (string != null) {
                n2 = this.setApplicationState_Native(string, n);
            }
        }
        return n2;
    }

    public int addApplication(String string, String string2) {
        int n = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n = -3;
            if (string != null && string2 != null) {
                n = this.addApplication_Native(string, string2);
            }
        }
        return n;
    }

    public int removeApplication(String string) {
        int n = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n = -3;
            if (string != null) {
                n = this.removeApplication_Native(string);
            }
        }
        return n;
    }

    public int getExceptionsNotAllowedState() {
        int n = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n = -3;
            n = this.getExceptionsNotAllowedState_Native();
        }
        return n;
    }

    public int setExceptionsNotAllowedState(int n) {
        int n2 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n2 = -3;
            n2 = this.setExceptionsNotAllowedState_Native(n);
        }
        return n2;
    }

    public int addPortException(String string, int n, int n2) {
        int n3 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n3 = -3;
            if (string != null) {
                n3 = this.addPortException_Native(string, n, n2);
            }
        }
        return n3;
    }

    public int removePortException(int n, int n2) {
        int n3 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n3 = -3;
            n3 = this.removePortException_Native(n, n2);
        }
        return n3;
    }

    public int getPortState(int n, int n2) {
        int n3 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n3 = -3;
            n3 = this.getPortState_Native(n, n2);
        }
        return n3;
    }

    public int setPortState(int n, int n2, int n3) {
        int n4 = -4;
        if (this.theNativeLibraryLoadedFlag) {
            n4 = -3;
            n4 = this.setPortState_Native(n, n2, n3);
        }
        return n4;
    }
}

