/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDataObject
implements IDataObject {
    private static Logger logger = LogManager.getLogger(AbstractDataObject.class);
    private DataStore dataStore;

    public AbstractDataObject(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        if (dataStore != null) {
            this.dataStore = dataStore;
        }
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    protected boolean isCommEstablished() {
        boolean bl = false;
        try {
            String string = this.dataStore.readValue("UC");
            if (string != null && string.equalsIgnoreCase("1")) {
                bl = true;
            }
        }
        catch (CommunicationException communicationException) {
            logger.trace((Object)communicationException);
            bl = false;
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.trace((Object)invalidDataIdentifierException);
            bl = false;
        }
        return bl;
    }

    protected boolean isEnvironmentalCommEstablished() {
        boolean bl = false;
        try {
            int n;
            String string;
            boolean bl2 = this.dataStore.isNetworkCommEstablished();
            if (bl2 && (string = this.getDataStore().readValue("MC")) != null && (n = Integer.parseInt(string)) == 1) {
                bl = true;
            }
        }
        catch (CommunicationException communicationException) {
            bl = false;
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            bl = false;
        }
        return bl;
    }

    protected boolean isNetworkCommEstablished() {
        boolean bl = false;
        if (this.getDataStore() != null) {
            bl = this.getDataStore().isNetworkCommEstablished();
        }
        return bl;
    }
}

