/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.battery;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.formatters.FloatFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryCapacity
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(BatteryCapacity.class);
    private static final int kNumberOfDecimalDigits = 2;

    public BatteryCapacity(DataStore dataStore) {
        super(dataStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() throws CommunicationException {
        Float f = null;
        if (this.getDataStore() == null) throw new CommunicationException(1);
        if (!this.isCommEstablished()) throw new CommunicationException(1);
        try {
            String string = this.getDataStore().readValue("UC");
            if (string == null) return f;
            if (!string.equalsIgnoreCase("1")) throw new CommunicationException(1);
            String string2 = this.getDataStore().readValue("66");
            if (string2 == null) throw new CommunicationException(1);
            try {
                return Float.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn((Object)numberFormatException);
                throw new CommunicationException(1);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
            throw new CommunicationException(3);
        }
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue("66");
                    if (this.isCommEstablished() && string != null) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    logger.warn("Object not currently available", (Throwable)communicationException);
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    logger.error("Invalid Data Identifier:66", (Throwable)invalidDataIdentifierException);
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new FloatFormatter(2);
    }
}

