/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.battery;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.BitField;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryConnectionStatus
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(BatteryConnectionStatus.class);

    public BatteryConnectionStatus(DataStore dataStore) {
        super(dataStore);
    }

    @Override
    public Object getValue() throws CommunicationException {
        Object object = null;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                object = this.isSymmetraAndDP3() || this.isSUVTorGalaxy() ? this.checkStateForSymmetra() : this.checkStateForSU();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                throw new CommunicationException(3);
            }
        }
        return object;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block5: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue("27");
                    if (string != null) {
                        availability = Availability.AVAILABLE;
                        break block5;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (Exception exception) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    private boolean isSymmetraAndDP3() {
        boolean bl = false;
        try {
            String string = this.getDataStore().readValue("01");
            if (string != null) {
                if (string.indexOf("DP3") > 0) {
                    bl = true;
                } else if (string.regionMatches(true, 0, "SYMMETRA", 0, "SYMMETRA".length())) {
                    bl = true;
                } else if (Pattern.matches("MGE GALAXY 3\\d\\d.*", string.toUpperCase())) {
                    bl = true;
                } else if (Pattern.matches("GALAXY 7\\d\\d\\d.*", string.toUpperCase())) {
                    bl = true;
                }
            }
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.info((Object)invalidDataIdentifierException);
        }
        catch (CommunicationException communicationException) {
            logger.info((Object)communicationException);
        }
        return bl;
    }

    private boolean isSUVTorGalaxy() {
        boolean bl = false;
        try {
            String string = this.getDataStore().readValue("01");
            if (string != null) {
                if (string.indexOf("VT") > 0) {
                    bl = true;
                } else if (string.regionMatches(true, 0, "GALAXY", 0, "GALAXY".length())) {
                    bl = true;
                }
            }
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.info((Object)invalidDataIdentifierException);
        }
        catch (CommunicationException communicationException) {
            logger.info((Object)communicationException);
        }
        return bl;
    }

    private Object checkStateForSymmetra() throws CommunicationException {
        Integer n = null;
        try {
            String string = this.getDataStore().readValue("05");
            if (string != null) {
                int n2 = Integer.parseInt(string, 16);
                n = BitField.isBitSet(n2, 23L) ? Integer.valueOf(2) : Integer.valueOf(1);
            }
        }
        catch (Exception exception) {
            throw new CommunicationException("checkStateForSymmetra Exception :" + exception.toString());
        }
        return n;
    }

    private Object checkStateForSU() throws CommunicationException {
        Integer n = null;
        try {
            String string = this.getDataStore().readValue("27");
            if (string != null) {
                int n2 = Integer.parseInt(string, 16);
                n = BitField.isBitSet(n2, 5L) ? Integer.valueOf(2) : Integer.valueOf(1);
            }
        }
        catch (Exception exception) {
            throw new CommunicationException("checkStateForSU Exception :" + exception.toString());
        }
        return n;
    }
}

