/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.battery;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.formatters.FloatFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryRunTimeRemaining
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(BatteryRunTimeRemaining.class);
    private static final int kNumberOfDecimalDigits = 2;
    private static final String kUnknownRuntimeString = ">>>>:";

    public BatteryRunTimeRemaining(DataStore dataStore) {
        super(dataStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() throws CommunicationException {
        Integer n = null;
        if (this.getDataStore() == null) throw new CommunicationException(1);
        if (!this.isCommEstablished()) throw new CommunicationException(1);
        try {
            String string = this.getDataStore().readValue("6A");
            if (string == null) throw new CommunicationException(1);
            if (string.equals(kUnknownRuntimeString)) return n;
            try {
                int n2 = 4;
                if (string.length() >= 4) return Integer.valueOf(string.substring(0, n2));
                n2 = string.length();
                return Integer.valueOf(string.substring(0, n2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn((Object)numberFormatException);
                throw new CommunicationException(1);
            }
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.warn((Object)invalidDataIdentifierException);
            throw new CommunicationException(3);
        }
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue("6A");
                    if (string != null && !string.equals(kUnknownRuntimeString)) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new FloatFormatter(2);
    }
}

