/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.communication;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.CommunicationsStatusLogEntry;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.IpAddressFormatter;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommunicationStatusLog
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(CommunicationStatusLog.class);
    private PowerSourceComponent thePowerSourceComponent;

    public CommunicationStatusLog(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        Vector<CommunicationsStatusLogEntry> vector = null;
        vector = this.thePowerSourceComponent.getCommunicationStatusLog();
        if (vector == null) {
            logger.warn("Error obtaining CommunicationStatusLog");
            throw new CommunicationException();
        }
        return vector;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (!object.equals(1)) {
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        this.thePowerSourceComponent.clearCommunicationStatusLog();
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IpAddressFormatter();
    }
}

