/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.communication;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.formatters.CommunicationStatusFormatter;
import com.apcc.m11.ds.powersource.OperatingStatus;

public class UPSConfigurationStatusDataRule
implements IDataObject {
    private IDataSource theDataSource;

    public UPSConfigurationStatusDataRule(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    @Override
    public Object getValue() throws CommunicationException, InvalidValueException {
        Integer n = 101;
        Integer n2 = 0;
        try {
            GetResult getResult = this.theDataSource.get(OperatingStatus.ParallelUnitsCount.getObjectId());
            n2 = (Integer)getResult.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 1) {
            n = 108;
        }
        return n;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new CommunicationStatusFormatter();
    }
}

