/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.control;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.IntegerFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurnOffSOGOnShutdown
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(TurnOffSOGOnShutdown.class);
    private PowerSourceComponent thePowerSourceComponent;

    public TurnOffSOGOnShutdown(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        Boolean bl = null;
        bl = this.thePowerSourceComponent.getTurnOffSOGFlag();
        if (bl == null) {
            logger.info("Error obtaining PS TurnOffSOGFlag");
            throw new CommunicationException();
        }
        return bl;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            if (!this.thePowerSourceComponent.setTurnOffSOGFlag(bl)) {
                logger.info("Error setting PS TurnOffUPSFlag");
                setResult.setSuccessful(false);
                throw new InvalidValueException();
            }
            if (bl.booleanValue()) {
                this.thePowerSourceComponent.setTurnOffUpsFlag(false);
            }
        } else {
            logger.info("Invalid Object specified");
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IntegerFormatter();
    }
}

