/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.dependentdevices;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.formatters.IpAddressFormatter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListOfDependentDevices
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(ListOfDependentDevices.class);
    private static final String kDeviceSeparator = ",";

    public ListOfDependentDevices(DataStore dataStore) {
        super(dataStore);
    }

    private InetAddress get_inet_address(String string) {
        if (string.length() == 8) {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(2, 4);
            String string4 = string.substring(4, 6);
            String string5 = string.substring(6, 8);
            String string6 = String.valueOf(Integer.valueOf(string2, 16)) + "." + String.valueOf(Integer.valueOf(string3, 16)) + "." + String.valueOf(Integer.valueOf(string4, 16)) + "." + String.valueOf(Integer.valueOf(string5, 16));
            try {
                return InetAddress.getByName(string6);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        if (string.length() > 2) {
            String string7 = string.toString();
            try {
                return InetAddress.getByName(string7);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() throws CommunicationException {
        Vector<InetAddress> vector = new Vector<InetAddress>();
        if (this.getDataStore() == null) throw new CommunicationException(1);
        try {
            String string = this.getDataStore().readConfigItem("CL");
            if (string == null) throw new CommunicationException(1);
            try {
                InetAddress inetAddress;
                String string2;
                int n = 0;
                int n2 = string.indexOf(kDeviceSeparator) + 1;
                while (n2 > 0) {
                    string2 = string.substring(n, n2 - 1);
                    inetAddress = this.get_inet_address(string2);
                    if (inetAddress != null) {
                        vector.addElement(inetAddress);
                    }
                    n = n2;
                    n2 = string.indexOf(kDeviceSeparator, n2) + 1;
                }
                string2 = string.substring(n, string.length());
                inetAddress = this.get_inet_address(string2);
                if (inetAddress == null) return vector;
                vector.addElement(inetAddress);
                return vector;
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn((Object)numberFormatException);
                throw new CommunicationException(1);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
            throw new CommunicationException(3);
        }
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IpAddressFormatter();
    }
}

