/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.environment;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.formatters.IntegerFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContactFault2
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(ContactFault2.class);

    public ContactFault2(DataStore dataStore) {
        super(dataStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() throws CommunicationException {
        Boolean bl = Boolean.FALSE;
        if (this.getDataStore() == null) throw new CommunicationException(1);
        if (!this.isEnvironmentalCommEstablished()) throw new CommunicationException(1);
        try {
            String string = this.getDataStore().readValue("E9");
            if (string == null) throw new CommunicationException(1);
            int n = Integer.parseInt(string);
            if (n != 1) return bl;
            return Boolean.TRUE;
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
            throw new CommunicationException(3);
        }
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block5: {
            availability = null;
            if (this.getDataStore() != null && this.isEnvironmentalCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue("E9");
                    if (string != null) {
                        availability = Availability.AVAILABLE;
                        break block5;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (Exception exception) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IntegerFormatter();
    }
}

