/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.identification;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.formatters.StringFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReadOnlyOptionalValue
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(ReadOnlyOptionalValue.class);
    private String packetKey;

    public ReadOnlyOptionalValue(DataStore dataStore, String string) {
        super(dataStore);
        this.packetKey = string;
    }

    @Override
    public Object getValue() throws CommunicationException {
        String string = null;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                String string2 = this.getDataStore().readValue(this.packetKey);
                string = StringUtils.defaultString((String)string2, (String)"NA");
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
                throw new CommunicationException(3);
            }
        } else {
            throw new CommunicationException(1);
        }
        return string;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability = null;
        availability = this.getDataStore() != null && this.isCommEstablished() ? Availability.AVAILABLE : Availability.UNAVAILABLE;
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new StringFormatter();
    }
}

