/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.BitField;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternalTempWarningIndicator
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(InternalTempWarningIndicator.class);

    public InternalTempWarningIndicator(DataStore dataStore) {
        super(dataStore);
    }

    @Override
    public Object getValue() throws CommunicationException {
        Integer n = null;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                if (this.isSUVTorGalaxy()) {
                    String string = this.getDataStore().readValue("18");
                    if (string != null) {
                        int n2 = Integer.parseInt(string, 16);
                        if (BitField.isBitSet(n2, 5L)) {
                            n = 2;
                        }
                        n = 1;
                    }
                    throw new CommunicationException(1);
                }
                String string = this.getDataStore().readValue("38");
                if (string != null) {
                    int n3 = Integer.parseInt(string, 16);
                    if (BitField.isBitSet(n3, 7L)) {
                        n = 2;
                    }
                    n = 1;
                }
                throw new CommunicationException(1);
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
                throw new CommunicationException(3);
            }
        } else {
            throw new CommunicationException(1);
        }
        return n;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block5: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue("38");
                    if (string != null) {
                        availability = Availability.AVAILABLE;
                        break block5;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (Exception exception) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    private boolean isSUVTorGalaxy() throws CommunicationException, InvalidDataIdentifierException {
        boolean bl = false;
        String string = this.getDataStore().readValue("01");
        if (string != null) {
            if (Pattern.matches(".*GALAXY 7\\d\\d\\d.*", string.toUpperCase())) {
                bl = false;
            } else if (string.indexOf("VT") > 0) {
                bl = true;
            } else if (string.regionMatches(true, 0, "GALAXY", 0, "GALAXY".length())) {
                bl = true;
            }
        }
        return bl;
    }
}

