/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletNameForMultipleOutlets
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(OutletNameForMultipleOutlets.class);
    private int outlet;

    public OutletNameForMultipleOutlets(DataStore dataStore) {
        super(dataStore);
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue(UPSLink.getOutletGroupNameKey(this.outlet));
                    if (string != null && !string.isEmpty()) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    @Override
    public Object getValue() throws CommunicationException, InvalidValueException {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                for (int i = 0; i < 4; ++i) {
                    this.outlet = i;
                    Object object = this.getDataStore().readValue(UPSLink.getOutletGroupNameKey(this.outlet));
                    if (object == null || ((String)object).isEmpty()) {
                        object = "Outlet " + this.outlet;
                    }
                    hashMap.put(this.outlet, object);
                }
            }
            catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                logger.error((Object)invalidDataIdentifierException);
                throw new CommunicationException(3);
            }
        } else {
            throw new CommunicationException(1);
        }
        return hashMap;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }
}

