/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.SinglePSShutdownDelayValue;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceShutdownDelay
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceShutdownDelay.class);
    private Integer outlet;
    private PowerSourceComponent powerSource;
    private static final int kMinutesToSecondsConversion = 60;

    public PowerSourceShutdownDelay(PowerSourceComponent powerSourceComponent, DataStore dataStore, Integer n) {
        super(dataStore);
        this.outlet = n;
        this.powerSource = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        Integer n = null;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                int n2;
                String string = UPSLink.getOutletTurnOffDelayKey(this.outlet);
                String string2 = this.getDataStore().readValue(string);
                if (string2 != null) {
                    n2 = Integer.parseInt(string2, 10);
                    if (this.outlet == null) {
                        n2 *= 60;
                    }
                } else {
                    throw new CommunicationException(1);
                }
                n = n2;
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
                throw new CommunicationException(3);
            }
        } else {
            throw new CommunicationException(1);
        }
        return n;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        logger.debug("setValue:" + String.valueOf(object));
        if (object == null) {
            setResult.setSuccessful(true);
            logger.debug("Received null, no set required");
        } else if (object instanceof SinglePSShutdownDelayValue) {
            if (this.getDataStore() != null && this.isCommEstablished()) {
                String string;
                String string2 = this.powerSource.getNMCAddressStr();
                if (string2.equalsIgnoreCase(string = ((SinglePSShutdownDelayValue)object).getIpAddress())) {
                    String string3 = ((SinglePSShutdownDelayValue)object).getShutdownDelay();
                    int n = Integer.parseInt(string3.toString());
                    setResult.setSuccessful(true);
                    String string4 = "macontrol1_maxctrl_shutdown_1=";
                    Object object2 = "";
                    if (this.outlet != null) {
                        string4 = "macontrol1_maxctrl_shutdowngroup=";
                        object2 = this.outlet + ",";
                    } else {
                        n /= 60;
                    }
                    String string5 = Integer.toHexString(n);
                    object2 = (String)object2 + string5;
                    this.getDataStore().writeValue(string4, (String)object2);
                    logger.trace("setting the outlet Single");
                }
            } else {
                setResult.setSuccessful(false);
            }
        } else {
            int n = Integer.parseInt(object.toString());
            if (this.getDataStore() != null && this.isCommEstablished()) {
                setResult.setSuccessful(true);
                String string = "macontrol1_maxctrl_shutdown_1=";
                Object object3 = "";
                if (this.outlet != null) {
                    string = "macontrol1_maxctrl_shutdowngroup=";
                    object3 = this.outlet + ",";
                } else {
                    n /= 60;
                }
                String string6 = Integer.toHexString(n);
                object3 = (String)object3 + string6;
                this.getDataStore().writeValue(string, (String)object3);
                logger.trace("setting the outlet string");
            } else {
                setResult.setSuccessful(false);
            }
        }
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = UPSLink.getOutletTurnOffDelayKey(this.outlet);
                    String string2 = this.getDataStore().readValue(string);
                    if (string2 != null) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    logger.warn((Object)invalidDataIdentifierException);
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    logger.warn((Object)communicationException);
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }
}

