/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus.PowerSourceTurnOffTime;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.pcns.ServiceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceTurnOffOnBattery
extends PowerSourceTurnOffTime {
    private static final Logger logger = LogManager.getLogger(PowerSourceTurnOffOnBattery.class);
    private IDataSource theDataSource;

    public PowerSourceTurnOffOnBattery(PowerSourceComponent powerSourceComponent, DataStore dataStore, IDataSource iDataSource, Integer n, ServiceManager serviceManager) {
        super(powerSourceComponent, dataStore, iDataSource, n, serviceManager);
        this.theDataSource = iDataSource;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        try {
            GetResult getResult = this.theDataSource.get(Output.SinglePowerFailedState.getObjectId());
            Boolean bl = (Boolean)getResult.getValue();
            if (bl.booleanValue()) {
                super.setValue(object, setResult);
                logger.info("PowerSourceTurnOffOnBattery - On battery");
            } else {
                logger.info("PowerSourceTurnOffOnBattery - not on battery");
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

