/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceTurnOffPendingForNonOutletAwareUPS
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceTurnOffPendingForNonOutletAwareUPS.class);
    private Integer outlet;

    public PowerSourceTurnOffPendingForNonOutletAwareUPS(DataStore dataStore) {
        super(dataStore);
    }

    @Override
    public Object getValue() throws CommunicationException {
        Boolean bl = null;
        String string = null;
        Object var4_3 = null;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                for (int i = 0; i < 4; ++i) {
                    this.outlet = i;
                    logger.debug("getValue for outlet" + this.outlet);
                    String string2 = this.getDataStore().readValue(UPSLink.getOutletTurnOffPendingKey(this.outlet));
                    if (string2 != null) {
                        bl = Boolean.FALSE;
                    }
                    bl = Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
                throw new CommunicationException(3);
            }
        } else {
            throw new CommunicationException(1);
        }
        logger.debug("Adapter: " + string + ", outlet: " + this.outlet + " is shutting down: " + bl);
        return bl;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability = null;
        String string = null;
        HashMap<Integer, Availability> hashMap = new HashMap<Integer, Availability>();
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                for (int i = 0; i < 4; ++i) {
                    this.outlet = i;
                    string = this.getDataStore().readValue(UPSLink.getOutletTurnOffPendingKey(this.outlet));
                    availability = string != null ? Availability.AVAILABLE : Availability.UNAVAILABLE;
                    hashMap.put(this.outlet, availability);
                }
            }
            catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                logger.warn((Object)invalidDataIdentifierException);
                availability = Availability.UNAVAILABLE;
            }
            catch (CommunicationException communicationException) {
                logger.warn((Object)communicationException);
                availability = Availability.UNAVAILABLE;
            }
        } else {
            availability = Availability.UNAVAILABLE;
        }
        for (Integer n : hashMap.keySet()) {
            String string2 = (String)hashMap.get(n);
            if (!string2.equals(Availability.UNAVAILABLE.toString())) continue;
            availability = Availability.UNAVAILABLE;
        }
        return availability;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }
}

