/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.operatingstatus;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.SinglePSSetValue;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.BitField;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Control;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceTurnOffTime
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceTurnOffTime.class);
    private static final String MODE_STAY_OFF = "0";
    private static final String MODE_RETURN_ON_AC = "1";
    private IDataSource theDataSource;
    private Integer outlet;
    private PowerSourceComponent powerSource;
    protected ServiceManager services;

    public PowerSourceTurnOffTime(PowerSourceComponent powerSourceComponent, DataStore dataStore, IDataSource iDataSource, Integer n, @NonNull ServiceManager serviceManager) {
        super(dataStore);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theDataSource = iDataSource;
        this.outlet = n;
        this.powerSource = powerSourceComponent;
    }

    private boolean isTurnOffPending() {
        boolean bl = Boolean.FALSE;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            try {
                String string = UPSLink.getOutletTurnOffPendingKey(this.outlet);
                String string2 = this.getDataStore().readValue(string);
                if (string2 != null) {
                    int n = Integer.parseInt(string2, 16);
                    bl = n == 1 ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
                }
            }
            catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                logger.error((Object)invalidDataIdentifierException);
                bl = Boolean.FALSE;
            }
            catch (CommunicationException communicationException) {
                logger.error((Object)communicationException);
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() throws CommunicationException {
        Integer n = null;
        if (this.getDataStore() == null) return null;
        if (!this.isCommEstablished()) return null;
        if (!this.isTurnOffPending()) return null;
        try {
            String string = this.getDataStore().readValue(UPSLink.getOutletTimeUntilTurnOffKey(this.outlet));
            if (string == null) return n;
            int n2 = Integer.parseInt(string, 10);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)numberFormatException);
            throw new CommunicationException(3);
        }
        catch (InvalidDataIdentifierException invalidDataIdentifierException) {
            logger.warn((Object)invalidDataIdentifierException);
            throw new CommunicationException();
        }
        catch (CommunicationException communicationException) {
            logger.warn((Object)communicationException);
            return null;
        }
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        logger.trace("setValue:" + String.valueOf(object));
        boolean bl = true;
        String string = MODE_STAY_OFF;
        if (this.getDataStore() != null && this.isCommEstablished()) {
            String string2;
            Object object2;
            Object object3;
            try {
                object3 = this.theDataSource.get(Output.OutputState.getObjectId());
                object2 = (Integer)object3.getValue();
                if ((Integer)object2 == 2) {
                    int n;
                    string = MODE_RETURN_ON_AC;
                    string2 = this.getDataStore().readValue("51");
                    if (string2 != null && BitField.isBitSet(n = Integer.parseInt(string2, 16), 6L) && this.isTurnOffPending()) {
                        bl = false;
                    }
                } else if ((Integer)object2 == 5 && !this.powerSource.isInBypass()) {
                    bl = false;
                    logger.trace("Already Off, no neet to turn off");
                }
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
            }
            try {
                object3 = this.getDataStore().readValue("47");
                if (object3 != null && ((String)object3).equalsIgnoreCase("K")) {
                    bl = false;
                }
            }
            catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                logger.warn((Object)invalidDataIdentifierException);
            }
            if (!bl) {
                logger.debug("Not going to perform the set");
                return;
            }
            object3 = this.powerSource.getNMCAddressStr();
            if (object instanceof SinglePSSetValue) {
                String string3;
                Object[] objectArray;
                GetResult getResult;
                logger.trace("single SetValue");
                object2 = (SinglePSSetValue)object;
                string2 = ((SinglePSSetValue)object2).getIpAddress();
                String string4 = ((SinglePSSetValue)object2).getTurnOffTime();
                int n = Integer.parseInt(string4.toString());
                String string5 = Integer.toHexString(n);
                if (!((String)object3).equalsIgnoreCase(string2)) {
                    setResult.setSuccessful(false);
                    return;
                }
                try {
                    if (this.outlet != null && (getResult = this.theDataSource.get(Control.TurnOffSOGOnShutdown.getObjectId())).getValue().equals(Boolean.TRUE) && !this.isOutletOff(this.outlet)) {
                        objectArray = new Object[]{this.powerSource.getOutletName(this.outlet), object3};
                        string3 = this.getLocalizedString("OutletTurnoff.Log", objectArray);
                        this.services.getApplicationErrorHandler().put(string3);
                        this.getDataStore().writeValue("macontrol1_control_shutdowngroup=", this.outlet + "," + string + "," + string5);
                    }
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    // empty catch block
                }
                try {
                    getResult = this.theDataSource.get(Control.TurnOffPowerSourceOnShutdown.getObjectId());
                    if (getResult.getValue().equals(Boolean.TRUE)) {
                        logger.info("Turn off Powersource:" + (String)object3);
                        objectArray = new Object[]{object3};
                        string3 = this.getLocalizedString("UPSTurnoff.Log", objectArray);
                        this.services.getApplicationErrorHandler().put(string3);
                        this.getDataStore().writeValue("macontrol1_control_shutdown_1=", string5);
                    }
                }
                catch (InvalidObjectIdException invalidObjectIdException) {}
            } else {
                String string6;
                Object[] objectArray;
                logger.trace("multiple SetValue");
                int n = Integer.parseInt(object.toString());
                string2 = Integer.toHexString(n);
                try {
                    GetResult getResult;
                    if (this.outlet != null && (getResult = this.theDataSource.get(Control.TurnOffSOGOnShutdown.getObjectId())).getValue().equals(Boolean.TRUE) && !this.isOutletOff(this.outlet)) {
                        objectArray = new Object[]{this.powerSource.getOutletName(this.outlet), object3};
                        string6 = this.getLocalizedString("OutletTurnoff.Log", objectArray);
                        this.services.getApplicationErrorHandler().put(string6);
                        this.getDataStore().writeValue("macontrol1_control_shutdowngroup=", this.outlet + "," + string + "," + string2);
                    }
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    // empty catch block
                }
                try {
                    GetResult getResult = this.theDataSource.get(Control.TurnOffPowerSourceOnShutdown.getObjectId());
                    if (getResult.getValue().equals(Boolean.TRUE)) {
                        logger.info("Turn off (multi)  Powersource:" + (String)object3);
                        objectArray = new Object[]{object3};
                        string6 = this.getLocalizedString("UPSTurnoff.Log", objectArray);
                        this.services.getApplicationErrorHandler().put(string6);
                        this.getDataStore().writeValue("macontrol1_control_shutdown_1=", string2);
                    }
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue(UPSLink.getOutletTurnOffPendingKey(this.outlet));
                    String string2 = this.getDataStore().readValue(UPSLink.getOutletTimeUntilTurnOffKey(this.outlet));
                    if (string != null && string2 != null) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    private boolean isOutletOff(Integer n) {
        boolean bl = true;
        try {
            Object object;
            GetResult getResult = this.theDataSource.get(OperatingStatus.OutletStateForMultipleOutlets.getObjectId());
            if (getResult.isReady() && !getResult.hasError() && (object = getResult.getValue()) instanceof Map) {
                HashMap hashMap = new HashMap();
                hashMap.putAll((Map)getResult.getValue());
                Integer n2 = (Integer)hashMap.get(n);
                bl = n2 == 0;
            }
        }
        catch (CommunicationException | InvalidObjectIdException throwable) {
            logger.debug("Unable to get the outlet state.  Assume it is off");
        }
        return bl;
    }

    private String getLocalizedString(String string, Object[] objectArray) {
        String string2 = string;
        Locale locale = Locale.getDefault();
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        if (resourceBundleWrapper != null) {
            String string3 = Utils.getResourceString(resourceBundleWrapper, string);
            messageFormat.applyPattern(string3);
            try {
                string2 = messageFormat.format(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
            }
        }
        return string2;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }
}

