/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.StringFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ESXIConfigurationMode
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(ESXIConfigurationMode.class);
    private PowerSourceComponent thePowerSourceComponent;

    public ESXIConfigurationMode(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        Integer n = null;
        n = this.thePowerSourceComponent.getESXiConfigurationMode();
        if (n == null) {
            logger.info("Error obtaining ESXi Configuration Mode");
            throw new CommunicationException();
        }
        return n;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (!this.thePowerSourceComponent.setESXiConfigurationMode(n)) {
                logger.info("Error setting ESXi Configuration Mode");
                setResult.setSuccessful(false);
                throw new InvalidValueException();
            }
        } else {
            logger.warn("Invalid Object specified");
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new StringFormatter();
    }
}

