/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.IpAddressFormatter;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalHostAddress
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(LocalHostAddress.class);
    private PowerSourceComponent thePowerSourceComponent;

    public LocalHostAddress(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        InetAddress inetAddress = null;
        inetAddress = this.thePowerSourceComponent.getLocalhostAddress();
        if (inetAddress == null) {
            logger.warn("Error obtaining PS host address");
            throw new CommunicationException();
        }
        return inetAddress;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (!(object instanceof InetAddress)) {
            logger.warn("Invalid IP address specified");
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        InetAddress inetAddress = (InetAddress)object;
        this.thePowerSourceComponent.setLocalHostAddress(inetAddress);
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IpAddressFormatter();
    }
}

