/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.IpAddressFormatter;
import java.net.Inet6Address;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MulticastAddress
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(MulticastAddress.class);
    private PowerSourceComponent thePowerSourceComponent;

    public MulticastAddress(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        String string = null;
        string = this.thePowerSourceComponent.getMulticastAddress();
        if (string == null) {
            logger.warn("Error obtaining MulticastAddress");
            throw new CommunicationException();
        }
        return string;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (!(object instanceof Inet6Address)) {
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        Inet6Address inet6Address = (Inet6Address)object;
        this.thePowerSourceComponent.setMulticastAddress(inet6Address.getHostAddress());
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IpAddressFormatter();
    }
}

