/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.StringFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceAuthKey
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceAuthKey.class);
    private PowerSourceComponent thePowerSourceComponent;

    public PowerSourceAuthKey(PowerSourceComponent powerSourceComponent) {
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public Object getValue() throws CommunicationException {
        String string = null;
        string = this.thePowerSourceComponent.getPassword();
        if (string == null) {
            logger.info("Error obtaining PS authorization key");
            throw new CommunicationException();
        }
        return string;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (object instanceof String) {
            String string = (String)object;
            if (!this.thePowerSourceComponent.setPassword(string)) {
                logger.info("Error setting PS authorization key");
                setResult.setSuccessful(false);
                throw new InvalidValueException();
            }
        } else {
            logger.warn("Invalid Object specified");
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new StringFormatter();
    }
}

