/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.IDataObject;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.IpAddressFormatter;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import java.net.InetAddress;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceIpAddress
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceIpAddress.class);
    private PowerSourceComponent thePowerSourceComponent;
    private ServiceManager services;

    public PowerSourceIpAddress(PowerSourceComponent powerSourceComponent, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePowerSourceComponent = powerSourceComponent;
        this.services = serviceManager;
    }

    @Override
    public Object getValue() throws CommunicationException {
        InetAddress inetAddress = null;
        inetAddress = this.thePowerSourceComponent.getNMCAddress();
        if (inetAddress == null) {
            logger.warn("Error obtaining PS host address");
        }
        return inetAddress;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        logger.debug("> setValue");
        if (object instanceof InetAddress) {
            InetAddress inetAddress = (InetAddress)object;
            if (!this.thePowerSourceComponent.setNMCAddress(inetAddress)) {
                logger.warn("Error setting PS host address");
                setResult.setSuccessful(false);
                throw new InvalidValueException();
            }
            logger.debug("success");
            setResult.setSuccessful(true);
        } else if (object instanceof Vector) {
            logger.debug("Got an IPaddress vector.  Mode change coming.");
            Vector vector = (Vector)object;
            ConfigurationManager configurationManager = this.services.getConfigurationManager();
            for (int i = 0; i < vector.size(); ++i) {
                configurationManager.setProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(i), ((InetAddress)vector.get(i)).getHostAddress());
                configurationManager.clearProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(i));
            }
            setResult.setSuccessful(true);
        } else {
            logger.warn("Invalid IP address specified");
            setResult.setSuccessful(false);
            throw new InvalidValueException();
        }
        logger.debug("< setValue");
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return new IpAddressFormatter();
    }
}

