/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import com.apcc.m11.components.stdpowersource.dataobjects.tcpip.OutletRegistrationTask;
import com.apcc.pcns.ServiceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceOutletGroup
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceOutletGroup.class);
    private PowerSourceComponent powerSource;

    public PowerSourceOutletGroup(PowerSourceComponent powerSourceComponent, DataStore dataStore) {
        super(dataStore);
        this.powerSource = powerSourceComponent;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IAvailability getAvailability() {
        Availability availability;
        block6: {
            availability = null;
            if (this.getDataStore() != null && this.isCommEstablished()) {
                try {
                    String string = this.getDataStore().readValue(UPSLink.getOutletTurnOffPendingKey(this.powerSource.getOutletGroup()));
                    if (this.isCommEstablished() && string != null) {
                        availability = Availability.AVAILABLE;
                        break block6;
                    }
                    availability = Availability.UNAVAILABLE;
                }
                catch (CommunicationException communicationException) {
                    availability = Availability.UNAVAILABLE;
                }
                catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                    availability = Availability.UNAVAILABLE;
                }
            } else {
                availability = Availability.UNAVAILABLE;
            }
        }
        return availability;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    @Override
    public Object getValue() throws CommunicationException, InvalidValueException {
        Integer n = this.powerSource.getOutletGroup();
        if (n == null) {
            return null;
        }
        Integer n2 = this.powerSource.getOutletState();
        String string = this.powerSource.getOutletName();
        String string2 = this.powerSource.getNMCAddressStr();
        OutletGroup outletGroup = new OutletGroup(n, n2, string, string2, true);
        return outletGroup;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        if (!(object instanceof OutletGroup)) {
            setResult.setSuccessful(false);
            throw new InvalidValueException("Expecting an OutletGroup here.");
        }
        if (!(object instanceof OutletGroup)) {
            setResult.setSuccessful(true);
        } else {
            String string;
            OutletGroup outletGroup = (OutletGroup)object;
            String string2 = this.powerSource.getNMCAddressStr();
            if (!string2.equalsIgnoreCase(string = outletGroup.getIpAddress())) {
                setResult.setSuccessful(true);
            } else {
                OutletRegistrationTask outletRegistrationTask = new OutletRegistrationTask(this.powerSource, setResult, object);
                ServiceManager.getInstance().getThreadService().submit(outletRegistrationTask);
            }
        }
    }
}

