/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.dataobjects.tcpip;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.DataStore;
import com.apcc.m11.components.stdpowersource.InvalidDataIdentifierException;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.dataobjects.AbstractDataObject;
import com.apcc.m11.components.stdpowersource.dataobjects.UPSLink;
import java.net.InetAddress;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceOutletGroupList
extends AbstractDataObject {
    private static final Logger logger = LogManager.getLogger(PowerSourceOutletGroupList.class);
    private PowerSourceComponent powersource;

    public PowerSourceOutletGroupList(PowerSourceComponent powerSourceComponent, DataStore dataStore) {
        super(dataStore);
        this.powersource = powerSourceComponent;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    @Override
    public Object getValue() throws CommunicationException, InvalidValueException {
        Vector<OutletGroup> vector = new Vector<OutletGroup>();
        InetAddress inetAddress = this.powersource.getNMCAddress();
        if (inetAddress != null) {
            String string = inetAddress.getHostAddress();
            Integer n = this.powersource.getOutletGroup();
            if (this.getDataStore() != null && this.isCommEstablished()) {
                for (int i = 0; i < 10; ++i) {
                    try {
                        if (this.getDataStore().readObject(UPSLink.getOutletTurnOffPendingKey(i)) == null) continue;
                        Integer n2 = this.powersource.getOutletState(i);
                        String string2 = this.getDataStore().readValue(UPSLink.getOutletGroupNameKey(i));
                        boolean bl = false;
                        if (n != null) {
                            bl = n == i;
                        }
                        OutletGroup outletGroup = new OutletGroup(i, n2, string2, string, bl);
                        vector.add(outletGroup);
                        continue;
                    }
                    catch (CommunicationException communicationException) {
                        logger.error((Object)communicationException);
                        continue;
                    }
                    catch (InvalidDataIdentifierException invalidDataIdentifierException) {
                        logger.error((Object)invalidDataIdentifierException);
                    }
                }
            } else {
                throw new CommunicationException(1);
            }
        }
        return vector;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }
}

