/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedGroupOutletStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(AdvancedGroupOutletStatusRule.class);
    private static final String kSOGPowerOffMsg = "PowerOffSOGFlexEvent";
    private static final String kSOGPowerOnMsg = "PowerOnSOGFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private Map<Integer, Boolean> theOutletOffSentMap = new HashMap<Integer, Boolean>();
    private PowerSourceComponent thePowerSourceComponent;

    public AdvancedGroupOutletStatusRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public synchronized void execute() {
        try {
            Object object;
            Integer n;
            GetResult getResult = this.theDataSource.get(OperatingStatus.IsUPSOutletAware.getObjectId());
            Boolean bl = (Boolean)getResult.getValue();
            if (bl.booleanValue()) {
                logger.trace("non-outlet aware UPS");
                return;
            }
            GetResult getResult2 = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object2 = getResult2.getValue();
            if (object2 instanceof Integer) {
                n = (Integer)object2;
                switch (n) {
                    case 5: 
                    case 8: {
                        return;
                    }
                }
            }
            n = this.theDataSource.get(OperatingStatus.OutletStateForMultipleOutlets.getObjectId());
            GetResult getResult3 = this.theDataSource.get(OperatingStatus.OutletNameForMultipleOutlets.getObjectId());
            if (n.isReady() && !n.hasError() && (object = n.getValue()) instanceof Map) {
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                hashMap.putAll((Map)n.getValue());
                hashMap2.putAll((Map)getResult3.getValue());
                for (Integer n2 : hashMap.keySet()) {
                    AdvancedGroupOutletEvent advancedGroupOutletEvent;
                    Integer n3 = (Integer)hashMap.get(n2);
                    if (n3.equals(0)) {
                        if (this.theOutletOffSentMap.get(n2) != null && this.theOutletOffSentMap.get(n2).booleanValue()) continue;
                        if (this.theOutletOffSentMap.get(n2) != null) {
                            advancedGroupOutletEvent = new AdvancedGroupOutletEvent(UtilityLineStatus.OutletOn.getObjectId(), false, (IFormatter)new AdvancedGroupFormatter(kSOGPowerOnMsg), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n2, (String)hashMap2.get(n2));
                            this.theFlexEventGenerator.postEvent(advancedGroupOutletEvent);
                        }
                        advancedGroupOutletEvent = new AdvancedGroupOutletEvent(UtilityLineStatus.OutletOff.getObjectId(), true, (IFormatter)new AdvancedGroupFormatter(kSOGPowerOffMsg), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n2, (String)hashMap2.get(n2));
                        this.theFlexEventGenerator.postEvent(advancedGroupOutletEvent);
                        this.theOutletOffSentMap.put(n2, Boolean.TRUE);
                        continue;
                    }
                    if (!n3.equals(1) || this.theOutletOffSentMap.get(n2) == null || !this.theOutletOffSentMap.get(n2).booleanValue()) continue;
                    advancedGroupOutletEvent = new AdvancedGroupOutletEvent(UtilityLineStatus.OutletOff.getObjectId(), false, (IFormatter)new AdvancedGroupFormatter(kSOGPowerOffMsg), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n2, (String)hashMap2.get(n2));
                    this.theFlexEventGenerator.postEvent(advancedGroupOutletEvent);
                    advancedGroupOutletEvent = new AdvancedGroupOutletEvent(UtilityLineStatus.OutletOn.getObjectId(), true, new AdvancedGroupFormatter(kSOGPowerOnMsg), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n2, (String)hashMap2.get(n2), true);
                    this.theFlexEventGenerator.postEvent(advancedGroupOutletEvent);
                    this.theOutletOffSentMap.put(n2, Boolean.FALSE);
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.debug((Object)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error((Object)invalidObjectIdException);
        }
    }
}

