/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.pcns.ServiceManager;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedGroupOutletTurnOffInitiatedRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(AdvancedGroupOutletTurnOffInitiatedRule.class);
    private static final String kSOGTurnOffInitiatedMsg = "SOGTurnOffInitiatedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private Map<Integer, Boolean> theOutletTurnOffSentMap = new HashMap<Integer, Boolean>();
    private PowerSourceComponent thePowerSourceComponent;
    private ServiceManager services;

    public AdvancedGroupOutletTurnOffInitiatedRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public void execute() {
        try {
            logger.trace("execute()");
            if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() || !this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV()) {
                logger.trace("not advanced shutdown mode with virtualization support enabled");
                return;
            }
            GetResult getResult = this.theDataSource.get(OperatingStatus.IsUPSOutletAware.getObjectId());
            Boolean bl = (Boolean)getResult.getValue();
            if (bl.booleanValue()) {
                logger.trace("non-outlet aware UPS");
                return;
            }
            GetResult getResult2 = this.theDataSource.get(OperatingStatus.OutletTurnOffPendingForMultipleOutlets.getObjectId());
            HashMap hashMap = new HashMap();
            hashMap.putAll((Map)getResult2.getValue());
            GetResult getResult3 = this.theDataSource.get(OperatingStatus.OutletNameForMultipleOutlets.getObjectId());
            HashMap hashMap2 = new HashMap();
            hashMap2.putAll((Map)getResult3.getValue());
            GetResult getResult4 = this.theDataSource.get(OperatingStatus.OutletStateForMultipleOutlets.getObjectId());
            HashMap hashMap3 = new HashMap();
            hashMap3.putAll((Map)getResult4.getValue());
            logger.trace("Handle Outlets Turn Off");
            for (Integer n : hashMap.keySet()) {
                Object object;
                Boolean bl2 = (Boolean)hashMap.get(n);
                logger.trace("Consider Outlet:" + n + " turningOff:" + bl2);
                if (bl2.booleanValue()) {
                    if (this.theOutletTurnOffSentMap.get(n) != null && this.theOutletTurnOffSentMap.get(n).booleanValue()) continue;
                    object = new AdvancedGroupOutletEvent(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), true, new AdvancedGroupFormatter(kSOGTurnOffInitiatedMsg, (String)hashMap2.get(n)), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n, (String)hashMap2.get(n), false, ShutdownEvents.UPSOutletTurnOffInitiated.getEventId());
                    this.theFlexEventGenerator.postEvent((Event)object);
                    this.theOutletTurnOffSentMap.put(n, Boolean.TRUE);
                    continue;
                }
                object = (Integer)hashMap3.get(n);
                if (!object.equals(1) || this.theOutletTurnOffSentMap.get(n) == null || !this.theOutletTurnOffSentMap.get(n).booleanValue()) continue;
                AdvancedGroupOutletEvent advancedGroupOutletEvent = new AdvancedGroupOutletEvent(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), false, (IFormatter)new AdvancedGroupFormatter(kSOGTurnOffInitiatedMsg), this.thePowerSourceComponent.getAdvancedUpsSetupIndex(), this.thePowerSourceComponent.getAdvancedUpsSetupName(), n, (String)hashMap2.get(n));
                this.theFlexEventGenerator.postEvent(advancedGroupOutletEvent);
                this.theOutletTurnOffSentMap.put(n, Boolean.FALSE);
            }
        }
        catch (CommunicationException communicationException) {
            logger.trace(" coms not established ");
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

