/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.AmbientTemperatureHumidityMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.Group;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.powersource.DependentDevices;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AmbientTemperatureHumidityRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(AmbientTemperatureHumidityRule.class);
    private static final String kUpperTempExceededMsg = "UpperAmbientTemperatureFlexEvent";
    private static final String kTemperatureNormalMsg = "TemperatureNormalFlexEvent";
    private static final String kLowerTempExceededMsg = "LowerAmbientTemperatureFlexEvent";
    private static final String kUpperHumidityExceededMsg = "UpperAmbientHumidityFlexEvent";
    private static final String kLowerHumidityExceededMsg = "LowerAmbientHumidityFlexEvent";
    private static final String kHumidityNormalMsg = "HumidityNormalFlexEvent";
    private static final String kFieldSeparator = ",";
    public static final int kUpperTemperatureExceeded = 7;
    public static final int kLowerTemperatureExceeded = 6;
    public static final int kUpperHumidityExceeded = 5;
    public static final int kLowerHumidityExceeded = 4;
    private IDataSource theDataSource;
    private FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;
    private LastAmbientTemperatureHumidity theProbeOneLastEvents;
    private LastAmbientTemperatureHumidity theProbeTwoLastEvents;

    private boolean isBitSet(long l, long l2) {
        long l3 = (long)Math.pow(2.0, l2);
        return (l & l3) == l3;
    }

    private boolean UpperTemperatureExceeded(int n) {
        boolean bl = false;
        if (this.isBitSet(n, 7L)) {
            bl = true;
        }
        return bl;
    }

    private boolean LowerTemperatureExceeded(int n) {
        boolean bl = false;
        if (this.isBitSet(n, 6L)) {
            bl = true;
        }
        return bl;
    }

    private boolean UpperHumidityExceeded(int n) {
        boolean bl = false;
        if (this.isBitSet(n, 5L)) {
            bl = true;
        }
        return bl;
    }

    private boolean LowerHumidityExceeded(int n) {
        boolean bl = false;
        if (this.isBitSet(n, 4L)) {
            bl = true;
        }
        return bl;
    }

    public void generate_probe_events(int n, int n2, LastAmbientTemperatureHumidity lastAmbientTemperatureHumidity) {
        ObjectId objectId = null;
        if (this.UpperTemperatureExceeded(n)) {
            objectId = Temperature.UpperAmbientTemperatureExceeded.getObjectId();
            if (!lastAmbientTemperatureHumidity.theLastHumidityEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastTemperatureEvent, false));
                this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kUpperTempExceededMsg, n2)));
                lastAmbientTemperatureHumidity.theLastTemperatureEvent = objectId;
            }
        } else if (this.LowerTemperatureExceeded(n)) {
            objectId = Temperature.LowerAmbientTemperatureExceeded.getObjectId();
            if (!lastAmbientTemperatureHumidity.theLastHumidityEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastTemperatureEvent, false));
                this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kLowerTempExceededMsg, n2)));
                lastAmbientTemperatureHumidity.theLastTemperatureEvent = objectId;
            }
        } else if (!lastAmbientTemperatureHumidity.theLastTemperatureEvent.equals((Object)Temperature.TemperatureNormal.getObjectId())) {
            this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastTemperatureEvent, false));
            this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kTemperatureNormalMsg, n2)));
            lastAmbientTemperatureHumidity.theLastTemperatureEvent = Temperature.TemperatureNormal.getObjectId();
        }
        if (this.UpperHumidityExceeded(n)) {
            objectId = Temperature.UpperHumidityExceeded.getObjectId();
            if (!lastAmbientTemperatureHumidity.theLastHumidityEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastHumidityEvent, false));
                this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kUpperHumidityExceededMsg, n2)));
                lastAmbientTemperatureHumidity.theLastHumidityEvent = objectId;
            }
        } else if (this.LowerHumidityExceeded(n)) {
            objectId = Temperature.LowerHumidityExceeded.getObjectId();
            if (!lastAmbientTemperatureHumidity.theLastHumidityEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastHumidityEvent, false));
                this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kLowerHumidityExceededMsg, n2)));
                lastAmbientTemperatureHumidity.theLastHumidityEvent = objectId;
            }
        } else if (!lastAmbientTemperatureHumidity.theLastHumidityEvent.equals((Object)Temperature.HumidityNormal.getObjectId())) {
            this.theFlexEventGenerator.postEvent(new Event(lastAmbientTemperatureHumidity.theLastHumidityEvent, false));
            this.theFlexEventGenerator.postEvent(new Event(objectId, true, (IFormatter)new AmbientTemperatureHumidityMessageFormatter(kHumidityNormalMsg, n2)));
            lastAmbientTemperatureHumidity.theLastHumidityEvent = Temperature.HumidityNormal.getObjectId();
        }
    }

    public AmbientTemperatureHumidityRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theProbeOneLastEvents = new LastAmbientTemperatureHumidity();
        this.theProbeTwoLastEvents = new LastAmbientTemperatureHumidity();
        this.theLastEvent = Battery.BatteryChargeInRange.getObjectId();
    }

    @Override
    public synchronized void execute() {
        try {
            GetResult getResult = this.theDataSource.get(DependentDevices.MeasureUpsAlarmRegister.getObjectId());
            String string = (String)getResult.getValue();
            if (string != null) {
                int n = string.indexOf(kFieldSeparator);
                String string2 = string.substring(0, n - 1);
                String string3 = string.substring(n + 1, string.length());
                int n2 = Integer.parseInt(string2, 16);
                int n3 = Integer.parseInt(string3, 16);
                this.generate_probe_events(n2, 1, this.theProbeOneLastEvents);
                this.generate_probe_events(n3, 2, this.theProbeTwoLastEvents);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    private static class LastAmbientTemperatureHumidity {
        ObjectId theLastTemperatureEvent = Group.kOid;
        ObjectId theLastHumidityEvent = Group.kOid;

        private LastAmbientTemperatureHumidity() {
        }
    }
}

